/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.tools.to.docx.poi;

import com.google.inject.Injector;
import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.ocl.pivot.internal.delegate.OCLInvocationDelegateFactory;
import org.eclipse.ocl.pivot.internal.delegate.OCLSettingDelegateFactory;
import org.eclipse.ocl.pivot.internal.delegate.OCLValidationDelegateFactory;
import org.eclipse.ocl.xtext.essentialocl.EssentialOCLStandaloneSetup;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.etsi.mts.tdl.TPLan2StandaloneSetup;
import org.etsi.mts.tdl.impl.tdlPackageImpl;
import org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl;
import org.etsi.mts.tdl.tools.to.docx.poi.Generator;

public class GeneratorApp {
    public static void main(String[] args) {
        Generator generator = new Generator();
        try {
            String filename = args[0];
            GeneratorApp.init();
            Resource resource = GeneratorApp.load(filename);
            File file = new File(filename);
            String target = String.valueOf(file.getName()) + ".docx";
            generator.generate(resource, target, "TEST-RESOURCE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void init() {
        tdlPackageImpl.init();
        StructuredObjectivesPackageImpl.init();
        EssentialOCLStandaloneSetup.doSetup();
        GeneratorApp.initializeValidator();
    }

    public static Resource load(String filename) {
        new StandaloneSetup().setPlatformUri("../");
        Injector injector = new TPLan2StandaloneSetup().createInjectorAndDoEMFRegistration();
        XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        Resource resource = resourceSet.getResource(URI.createURI((String)filename), true);
        return resource;
    }

    public static void initializeValidator() {
        String oclDelegateURI = "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot";
        EOperation.Internal.InvocationDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLInvocationDelegateFactory(oclDelegateURI));
        EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLSettingDelegateFactory(oclDelegateURI));
        EValidator.ValidationDelegate.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLValidationDelegateFactory(oclDelegateURI));
    }
}

