/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.tools.to.docx.poi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.etsi.mts.tdl.Annotation;
import org.etsi.mts.tdl.Behaviour;
import org.etsi.mts.tdl.Block;
import org.etsi.mts.tdl.CompoundBehaviour;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.TestConfiguration;
import org.etsi.mts.tdl.TestDescription;
import org.etsi.mts.tdl.TestObjective;
import org.etsi.mts.tdl.resources.ResourceHandler;
import org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective;
import org.etsi.mts.tdl.structuredobjectives.TestObjectiveVariant;
import org.etsi.mts.tdl.structuredobjectives.VariantBinding;
import org.etsi.mts.tdl.tools.to.docx.poi.Placeholders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;

public class Generator {
    int index = 0;
    String templateFilename = "template.docx";
    public static String selectedTemplate = "TO_4_TABLE_TEMPLATE_EDITHELP";
    XWPFDocument template;
    private boolean hierarchical = true;

    public void generate(Resource resource, String filename, String title) throws Exception {
        this.generate(resource, filename, title, selectedTemplate);
    }

    public void generate(Resource resource, String filename, String title, String templateName) throws Exception {
        selectedTemplate = templateName;
        XWPFDocument document = this.createDocument();
        this.template = this.loadTemplate();
        this.loadStyles(document, this.template);
        this.createTitle(title, document);
        int hLevel = 3;
        if (this.hierarchical) {
            String prefix = "X.Y";
            this.generatePackageHeadings(resource, document, prefix, hLevel);
        } else {
            EObject p = (EObject)resource.getContents().get(0);
            List stos = EcoreUtil2.getAllContentsOfType((EObject)p, StructuredTestObjective.class);
            this.generateSTOs(document, stos);
            this.generateTPDs(document, EcoreUtil2.getAllContentsOfType((EObject)p, TestDescription.class));
        }
        this.storeDocument(filename, document);
        this.template.close();
    }

    private void generatePackageHeadings(Resource resource, XWPFDocument document, String prefix, int hLevel) {
        List<Package> packages = this.getContentsOfType(resource, Package.class);
        this.generatePackageHeadings(document, packages, prefix, hLevel);
    }

    private void generatePackageHeadings(XWPFDocument document, List<Package> packages, String prefix, int hLevel) {
        int i = 1;
        for (Package p : packages) {
            this.generatePackageHeading(document, prefix, i, p, hLevel);
            List<StructuredTestObjective> stos = this.getContentsOfType((EObject)p, StructuredTestObjective.class);
            this.generateSTOs(document, stos);
            this.generateTPDs(document, this.getContentsOfType((EObject)p, TestDescription.class));
            this.generatePackageHeadings(document, this.getContentsOfType((EObject)p, Package.class), String.valueOf(prefix) + "." + i, hLevel + 1);
            ++i;
        }
    }

    private void generateSTOs(XWPFDocument document, List<StructuredTestObjective> stos) {
        for (StructuredTestObjective sto : stos) {
            String sectionTitle = sto.getName();
            LinkedHashMap<String, String> map = this.getSTOReplacementMap(sto);
            this.generateTable(document, sectionTitle, map);
            LinkedHashMap<String, LinkedHashMap<String, String>> variants = this.getSTOVariantsMap(sto);
            this.generateVariants(document, variants);
        }
    }

    private void generateTPDs(XWPFDocument document, List<TestDescription> tpds) {
        for (TestDescription tpd : tpds) {
            if (!tpd.getAnnotation().stream().anyMatch(a -> a.getKey().getName().startsWith("Test Purpose"))) continue;
            String sectionTitle = tpd.getName();
            LinkedHashMap<String, String> map = this.getTPDReplacementMap(tpd);
            this.generateTable(document, sectionTitle, map);
        }
    }

    private void generatePackageHeading(XWPFDocument document, String prefix, int i, Package p, int hLevel) {
        System.out.println(p.getName());
        XWPFParagraph par = document.createParagraph();
        par.setStyle(this.template.getStyles().getStyleWithName("heading " + hLevel).getStyleId());
        XWPFRun titleRun = par.createRun();
        titleRun.setText(String.valueOf(prefix) + "." + i);
        titleRun.addTab();
        titleRun.setText(p.getName());
    }

    private <T> List<T> getContentsOfType(Resource resource, Class<T> type) {
        List elements = resource.getContents().stream().filter(e -> type.isInstance(e)).map(e -> e).collect(Collectors.toList());
        return elements;
    }

    private <T> List<T> getContentsOfType(EObject eObject, Class<T> type) {
        List elements = eObject.eContents().stream().filter(e -> type.isInstance(e)).map(e -> e).collect(Collectors.toList());
        return elements;
    }

    private void generateVariants(XWPFDocument document, LinkedHashMap<String, LinkedHashMap<String, String>> variants) {
        LinkedHashSet<String> headers = new LinkedHashSet<String>();
        for (LinkedHashMap<String, String> e : variants.values()) {
            headers.addAll(e.keySet());
        }
        if (headers.size() > 0) {
            XWPFTableCell xWPFTableCell;
            XWPFTable table = this.loadTemplate(this.template, String.valueOf(selectedTemplate) + "_VARIANT");
            if (table == null) {
                return;
            }
            CTTbl tbl = document.getDocument().getBody().insertNewTbl(document.getDocument().getBody().sizeOfTblArray());
            tbl.set((XmlObject)table.getCTTbl());
            XWPFTable target = new XWPFTable(tbl, (IBody)document);
            ((XWPFRun)((XWPFParagraph)target.getRow(0).getCell(0).getParagraphs().get(0)).getRuns().get(0)).setText("REPLACE", 0);
            target.removeRow(0);
            ArrayList hList = new ArrayList(headers);
            target.getCTTbl().addNewTblGrid();
            int i = 0;
            while (i < hList.size()) {
                if (i > 0) {
                    xWPFTableCell = target.getRow(0).createCell();
                }
                XWPFTableCell cell = target.getRow(0).getCell(i + 1);
                cell.getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(1200L));
                XWPFParagraph p = (XWPFParagraph)target.getRow(0).getCell(0).getParagraphs().get(0);
                ((XWPFParagraph)cell.getParagraphs().get(0)).getCTP().set((XmlObject)p.getCTP());
                ((CTText)((CTR)((XWPFParagraph)cell.getParagraphs().get(0)).getCTP().getRList().get(0)).getTList().get(0)).setStringValue((String)hList.get(i));
                ++i;
            }
            int r = 1;
            for (String id : variants.keySet()) {
                XWPFTableRow row = target.getRow(r);
                XWPFParagraph rp = (XWPFParagraph)target.getRow(1).getCell(0).getParagraphs().get(0);
                if (r > 1) {
                    target.createRow();
                }
                XWPFTableCell hCell = target.getRow(r).getCell(0);
                ((XWPFParagraph)hCell.getParagraphs().get(0)).getCTP().set((XmlObject)rp.getCTP());
                ((CTText)((CTR)((XWPFParagraph)hCell.getParagraphs().get(0)).getCTP().getRList().get(0)).getTList().get(0)).setStringValue(id);
                int i2 = 0;
                while (i2 < hList.size()) {
                    if (r == 1 && i2 > 0) {
                        XWPFTableCell xWPFTableCell2 = target.getRow(r).createCell();
                    }
                    XWPFTableCell cell = target.getRow(r).getCell(i2 + 1);
                    cell.getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(1200L));
                    if (variants.get(id).containsKey(hList.get(i2))) {
                        XWPFParagraph p = (XWPFParagraph)target.getRow(r).getCell(0).getParagraphs().get(0);
                        ((XWPFParagraph)cell.getParagraphs().get(0)).getCTP().set((XmlObject)p.getCTP());
                        ((CTText)((CTR)((XWPFParagraph)cell.getParagraphs().get(0)).getCTP().getRList().get(0)).getTList().get(0)).setStringValue(variants.get(id).get(hList.get(i2)));
                    }
                    ++i2;
                }
                ++r;
            }
            target.getCTTbl().addNewTblGrid();
            for (XWPFTableCell cell : target.getRow(0).getTableCells()) {
                table.getCTTbl().getTblGrid().addNewGridCol().setW(BigInteger.valueOf(3200L));
            }
            xWPFTableCell = document.createParagraph();
        }
    }

    void generateExample(String filename, String title) throws Exception {
        XWPFDocument document = this.createDocument();
        this.template = this.loadTemplate();
        this.loadStyles(document, this.template);
        this.createTitle(title, document);
        int i = 0;
        while (i < 5) {
            String sectionTitle = "Test " + i;
            LinkedHashMap<String, String> map = this.getReplacementMap();
            this.generateTable(document, sectionTitle, map);
            ++i;
        }
        this.storeDocument(filename, document);
        this.template.close();
    }

    private XWPFDocument loadTemplate() throws Exception {
        URI templateLocation = ResourceHandler.getSourceUri(this.getClass(), (String)"org.etsi.mts.tdl.to.docx.poi", (String)this.templateFilename);
        this.template = this.loadTemplateDocument(templateLocation);
        return this.template;
    }

    private void generateTable(XWPFDocument document, String sectionTitle, LinkedHashMap<String, String> map) {
        XWPFTable table = this.loadTemplate(this.template, selectedTemplate);
        CTTbl tbl = document.getDocument().getBody().insertNewTbl(document.getDocument().getBody().sizeOfTblArray());
        tbl.set((XmlObject)table.getCTTbl());
        XWPFTable target = new XWPFTable(tbl, (IBody)document);
        ((XWPFRun)((XWPFParagraph)target.getRow(0).getCell(0).getParagraphs().get(0)).getRuns().get(0)).setText("REPLACE", 0);
        target.removeRow(0);
        this.makeReplacements(target, map);
        this.cleanUp(target);
        XWPFParagraph par = document.createParagraph();
    }

    private void cleanUp(XWPFTable target) {
        LinkedHashMap colors = new LinkedHashMap();
        ArrayList<String> cleanColors = new ArrayList<String>();
        int rn = 0;
        for (XWPFTableRow r : target.getRows()) {
            for (XWPFTableCell c : r.getTableCells()) {
                if (c.getColor() == null || c.getColor().equals("auto")) continue;
                colors.putIfAbsent(c.getColor(), new TreeSet());
                ((TreeSet)colors.get(c.getColor())).add(rn);
                if (!c.getText().trim().isEmpty()) continue;
                cleanColors.add(c.getColor());
            }
            ++rn;
        }
        int o = 0;
        for (String c : colors.keySet()) {
            if (!cleanColors.contains(c)) continue;
            Iterator iterator = ((TreeSet)colors.get(c)).iterator();
            while (iterator.hasNext()) {
                int r = (Integer)iterator.next();
                target.removeRow(r - o);
                ++o;
            }
        }
        for (XWPFTableRow r : target.getRows()) {
            for (XWPFTableCell c : r.getTableCells()) {
                if (c.getColor() != null && !c.getColor().equals("auto")) {
                    c.setColor(null);
                    c.getCTTc().getTcPr().getShd().unsetThemeFill();
                }
                c.getColor();
            }
        }
    }

    private void makeReplacements(XWPFTable target, LinkedHashMap<String, String> map) {
        for (XWPFTableRow r : target.getRows()) {
            for (XWPFTableCell c : r.getTableCells()) {
                for (XWPFParagraph p : c.getParagraphs()) {
                    for (XWPFRun run : p.getRuns()) {
                        if (!map.containsKey(run.getText(0))) continue;
                        String text = map.get(run.getText(0));
                        if (text == null || text.isEmpty()) {
                            for (XWPFRun rr : p.getRuns()) {
                                rr.setText("", 0);
                            }
                            continue;
                        }
                        String[] lines = text.split("\n");
                        run.setText("", 0);
                        int l = 0;
                        String[] stringArray = lines;
                        int n = lines.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String line = stringArray[n2];
                            run.setText(line);
                            if (++l < lines.length) {
                                run.addBreak();
                            }
                            ++n2;
                        }
                    }
                }
            }
        }
    }

    private LinkedHashMap<String, LinkedHashMap<String, String>> getSTOVariantsMap(StructuredTestObjective sto) {
        LinkedHashMap<String, LinkedHashMap<String, String>> variants = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        if (sto.getVariants() != null) {
            for (TestObjectiveVariant v : sto.getVariants().getVariants()) {
                variants.put(v.getName(), new LinkedHashMap());
                if (v.getDescription() != null) {
                    variants.get(v.getName()).put("Description", v.getDescription());
                }
                if (!v.getObjectiveURI().isEmpty()) {
                    variants.get(v.getName()).put("Reference", String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)v.getObjectiveURI()));
                }
                if (!v.getPicsReference().isEmpty()) {
                    String pics = String.join((CharSequence)" ", v.getPicsReference().stream().map(p -> NodeModelUtils.getNode((EObject)p).getText()).collect(Collectors.toList())).trim();
                    variants.get(v.getName()).put("PICS", pics);
                }
                for (VariantBinding b : v.getBindings()) {
                    String value = NodeModelUtils.getNode((EObject)b.getValue()).getText();
                    String boundTo = NodeModelUtils.getNode((EObject)b.getBoundTo()).getText();
                    variants.get(v.getName()).put(value, boundTo);
                }
            }
        }
        return variants;
    }

    private LinkedHashMap<String, String> getTPDReplacementMap(TestDescription tpd) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(Placeholders.NAME, tpd.getName());
        map.put(Placeholders.DESCRIPTION, ((TestObjective)tpd.getTestObjective().get(0)).getDescription().replaceAll("\"", ""));
        String uri = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)((TestObjective)tpd.getTestObjective().get(0)).getObjectiveURI()).trim();
        map.put(Placeholders.URI, uri.replaceAll("\"", ""));
        TestConfiguration configuration = tpd.getTestConfiguration();
        String config = "";
        if (configuration != null && configuration.getName() != null) {
            config = configuration.getName();
        }
        map.put(Placeholders.CONFIGURATION, config);
        String pics = "N/A";
        map.put(Placeholders.PICS, pics);
        map.put(Placeholders.INITIAL, "");
        map.put(Placeholders.EXPECTED, "");
        map.put(Placeholders.FINAL, "");
        Behaviour behaviour = tpd.getBehaviourDescription().getBehaviour();
        if (behaviour instanceof CompoundBehaviour) {
            Block block = ((CompoundBehaviour)behaviour).getBlock();
            for (Behaviour b : block.getBehaviour()) {
                if (((Annotation)b.getAnnotation().get(0)).getKey().getName().startsWith("Initial")) {
                    String initialConditions = NodeModelUtils.getNode((EObject)b).getText();
                    initialConditions = initialConditions.replaceAll("\\s*Initial conditions", "");
                    initialConditions = this.filterSource(initialConditions, "\n", "\\w").trim();
                    map.put(Placeholders.INITIAL, initialConditions);
                    continue;
                }
                if (((Annotation)b.getAnnotation().get(0)).getKey().getName().startsWith("Expected")) {
                    String expected = NodeModelUtils.getNode((EObject)b).getText();
                    expected = expected.replaceAll("\\s*Expected behaviour", "");
                    expected = this.filterSource(expected, "\n", "ensure").trim();
                    map.put(Placeholders.EXPECTED, expected);
                    EList expectedBehaviours = ((CompoundBehaviour)b).getBlock().getBehaviour();
                    if (expectedBehaviours.size() != 2) continue;
                    String when = NodeModelUtils.getNode((EObject)((EObject)expectedBehaviours.get(0))).getText();
                    String then = NodeModelUtils.getNode((EObject)((EObject)expectedBehaviours.get(1))).getText();
                    when = this.filterSource(when, "\n", "\\s\\s\\s\\s\\w");
                    then = this.filterSource(then, "\n", "\\s+\\w");
                    map.put(Placeholders.WHEN, "when {" + when + "\n}");
                    map.put(Placeholders.THEN, "then {" + then + "\n}");
                    continue;
                }
                if (!((Annotation)b.getAnnotation().get(0)).getKey().getName().startsWith("Final")) continue;
                String finalConditions = NodeModelUtils.getNode((EObject)b).getText();
                finalConditions = finalConditions.replaceAll("\\s*Final conditions", "");
                finalConditions = this.filterSource(finalConditions, "\n", "\\w").trim();
                map.put(Placeholders.FINAL, finalConditions);
            }
        }
        return map;
    }

    private LinkedHashMap<String, String> getSTOReplacementMap(StructuredTestObjective sto) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(Placeholders.NAME, sto.getName());
        map.put(Placeholders.DESCRIPTION, sto.getDescription().replaceAll("\"", ""));
        String uri = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)sto.getObjectiveURI()).trim();
        map.put(Placeholders.URI, uri.replaceAll("\"", ""));
        TestConfiguration configuration = sto.getConfiguration();
        String config = "";
        if (configuration != null && configuration.getName() != null) {
            config = configuration.getName();
        }
        map.put(Placeholders.CONFIGURATION, config);
        String pics = String.join((CharSequence)" ", sto.getPicsReference().stream().map(p -> NodeModelUtils.getNode((EObject)p).getText()).collect(Collectors.toList())).trim();
        map.put(Placeholders.PICS, pics);
        map.put(Placeholders.INITIAL, "");
        if (sto.getInitialConditions() != null) {
            String initialConditions = NodeModelUtils.getNode((EObject)sto.getInitialConditions()).getText();
            initialConditions = initialConditions.replaceAll("\\s*Initial conditions", "");
            initialConditions = this.filterSource(initialConditions, "\n", "\\w").trim();
            map.put(Placeholders.INITIAL, initialConditions);
        }
        if (sto.getExpectedBehaviour() != null) {
            String expected = NodeModelUtils.getNode((EObject)sto.getExpectedBehaviour()).getText();
            expected = expected.replaceAll("\\s*Expected behaviour", "");
            expected = this.filterSource(expected, "\n", "ensure").trim();
            map.put(Placeholders.EXPECTED, expected);
        } else {
            map.put(Placeholders.EXPECTED, "");
        }
        map.put(Placeholders.FINAL, "");
        if (sto.getFinalConditions() != null) {
            String finalConditions = NodeModelUtils.getNode((EObject)sto.getFinalConditions()).getText();
            finalConditions = finalConditions.replaceAll("\\s*Final conditions", "");
            finalConditions = this.filterSource(finalConditions, "\n", "\\w").trim();
            map.put(Placeholders.FINAL, finalConditions);
        }
        if (sto.getExpectedBehaviour() != null && sto.getExpectedBehaviour().getWhenClause() != null && sto.getExpectedBehaviour().getThenClause() != null) {
            String when = NodeModelUtils.getNode((EObject)sto.getExpectedBehaviour().getWhenClause()).getText();
            String then = NodeModelUtils.getNode((EObject)sto.getExpectedBehaviour().getThenClause()).getText();
            when = this.filterSource(when, "\n", "\\s\\s\\s\\s\\w");
            then = this.filterSource(then, "\n", "\\s+\\w");
            map.put(Placeholders.WHEN, "when {" + when + "\n}");
            map.put(Placeholders.THEN, "then {" + then + "\n}");
        }
        return map;
    }

    private String filterSource(String source, String prefix, String offsetKeyword) {
        Matcher matcher = Pattern.compile(String.valueOf(prefix) + "(.+?)" + offsetKeyword).matcher(source);
        String offset = "";
        if (matcher.find()) {
            offset = matcher.group(1).replaceAll("\t", "    ");
            System.out.println("|" + offset + "|");
        }
        source = source.replaceAll("\t", "    ").replaceAll("\n" + offset, "\n").replaceAll("[\\s\n\r]+" + prefix, prefix).replaceAll(" \\((typed|predefined)\\) ", " ").replaceAll(" entity ", " ").replaceAll("\\^", "").replaceAll(";", "").replaceAll("\\(|\\)", "");
        return source;
    }

    private LinkedHashMap<String, String> getReplacementMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(Placeholders.NAME, "Name");
        map.put(Placeholders.DESCRIPTION, "Descripion");
        map.put(Placeholders.URI, "URI");
        map.put(Placeholders.CONFIGURATION, "Configuration");
        map.put(Placeholders.PICS, "PICS");
        map.put(Placeholders.INITIAL, "Initial");
        map.put(Placeholders.EXPECTED, "Expected\nWhen\n  {\n  }\nThen\n  {\n  }");
        map.put(Placeholders.FINAL, "Final");
        map.put(Placeholders.FINAL, "");
        map.put(Placeholders.WHEN, "When");
        map.put(Placeholders.THEN, "Then");
        return map;
    }

    private XWPFTable loadTemplate(XWPFDocument template, String selectedTemplate) {
        XWPFTable table = null;
        List bodyElements = template.getBodyElements();
        for (IBodyElement e : bodyElements) {
            String id;
            if (!(e instanceof XWPFTable) || !(id = ((XWPFTable)e).getRow(0).getCell(0).getText()).trim().equals(selectedTemplate)) continue;
            table = (XWPFTable)e;
        }
        return table;
    }

    private XWPFDocument createDocument() {
        XWPFDocument report = new XWPFDocument();
        return report;
    }

    private XWPFDocument loadTemplateDocument(URI templateLocation) throws Exception {
        File file = new File(templateLocation);
        FileInputStream fis = new FileInputStream(file.getAbsolutePath());
        XWPFDocument document = new XWPFDocument((InputStream)fis);
        fis.close();
        return document;
    }

    private void storeDocument(String reportLocation, XWPFDocument report) {
        try {
            FileOutputStream out = new FileOutputStream(reportLocation);
            report.write((OutputStream)out);
            out.close();
            report.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createTitle(String title, XWPFDocument report) {
        XWPFParagraph titleParagraph = report.createParagraph();
        titleParagraph.setAlignment(ParagraphAlignment.CENTER);
        XWPFRun titleRun = titleParagraph.createRun();
        titleRun.setText("Export: " + title);
        titleRun.setColor("444444");
        titleRun.setBold(true);
        titleRun.setFontFamily("Helvetica");
        titleRun.setFontSize(20);
    }

    private void loadStyles(XWPFDocument report, XWPFDocument templateDocument) {
        XWPFStyles newStyles = report.createStyles();
        try {
            newStyles.setStyles(templateDocument.getStyle());
        }
        catch (IOException | XmlException e) {
            e.printStackTrace();
        }
    }
}

