/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.openapi2tdl.next.doc;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.etsi.mts.tdl.openapi2tdl.next.OpenAPI2TDLTranslatorNext;
import org.etsi.mts.tdl.openapi2tdl.next.doc.ICSDetail;
import org.etsi.mts.tdl.openapi2tdl.next.doc.ICSHierarchical;
import org.etsi.mts.tdl.openapi2tdl.next.doc.ICSMethod;
import org.etsi.mts.tdl.openapi2tdl.next.doc.ICSPath;
import org.etsi.mts.tdl.openapi2tdl.next.doc.OpenAPIVisitor;
import org.etsi.mts.tdl.openapi2tdl.next.doc.RQ;
import org.etsi.mts.tdl.openapi2tdl.next.doc.TSS;

public class Doc {
    StringBuffer content = new StringBuffer();
    private OpenAPI model;

    public void append(String s) {
        this.content.append(s);
    }

    public static void main(String[] args) throws Exception {
        boolean validate = args.length < 1 || !args[0].equals("-n");
        Doc doc = new Doc();
        doc.processModel(args[1], validate);
        Files.writeString(Path.of(String.valueOf(args[1]) + "-RQ-ICS-TSS.md", new String[0]), (CharSequence)doc.content, new OpenOption[0]);
    }

    public void processModel(String filename, boolean validate) throws Exception {
        this.model = OpenAPI2TDLTranslatorNext.parseSpec(filename, true);
        this.append(String.format("== Model %s\n", filename));
        this.append("# Generated Documentation\n");
        Doc.processModel(this.model, new RQ().init(this.model, this));
        this.append("\n## Implementation Conformance Statements\n");
        Doc.processModel(this.model, new ICSDetail().init(this.model, this));
        Doc.processModel(this.model, new ICSMethod().init(this.model, this));
        Doc.processModel(this.model, new ICSPath().init(this.model, this));
        Doc.processModel(this.model, new ICSHierarchical().init(this.model, this));
        Doc.processModel(this.model, new TSS().init(this.model, this));
        this.append("------\n\n");
    }

    private static void processModel(OpenAPI model, OpenAPIVisitor visitor) {
        visitor.preamble(model);
        for (Map.Entry pathEntry : model.getPaths().entrySet()) {
            String path = (String)pathEntry.getKey();
            PathItem pathItem = (PathItem)pathEntry.getValue();
            visitor.path(path);
            for (Map.Entry o : pathItem.readOperationsMap().entrySet()) {
                visitor.operation(path, ((PathItem.HttpMethod)o.getKey()).name(), (Operation)o.getValue());
            }
        }
        visitor.postamble(model);
    }

    private static void getICSTemplate(OpenAPI model) {
        String level = "Template";
        System.out.printf("\n#### %s\n\n", level);
        String header = "| ID | Resource  | Reference | Method | Type  | Request | Response |\n| -- | --------- | --------- | ------ | ----- | ------- | -------- |";
        String footer = "[Table X.Y: Extracted ICS (" + level + ")]{custom-style=\"FL\"}";
        System.out.println(header);
        for (Map.Entry pathEntry : model.getPaths().entrySet()) {
            String path = (String)pathEntry.getKey();
            PathItem pathItem = (PathItem)pathEntry.getValue();
            for (Map.Entry op : pathItem.readOperationsMap().entrySet()) {
                for (String string : ((Operation)op.getValue()).getResponses().keySet()) {
                }
            }
        }
        System.out.println(footer);
    }

    public StringBuffer getContent() {
        return this.content;
    }
}

