/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.asn2tdl;

import antlr.TokenStream;
import com.beanit.asn1bean.compiler.model.AsnAny;
import com.beanit.asn1bean.compiler.model.AsnBitString;
import com.beanit.asn1bean.compiler.model.AsnBoolean;
import com.beanit.asn1bean.compiler.model.AsnCharacterString;
import com.beanit.asn1bean.compiler.model.AsnChoice;
import com.beanit.asn1bean.compiler.model.AsnDefinedType;
import com.beanit.asn1bean.compiler.model.AsnElementType;
import com.beanit.asn1bean.compiler.model.AsnEnum;
import com.beanit.asn1bean.compiler.model.AsnInteger;
import com.beanit.asn1bean.compiler.model.AsnModel;
import com.beanit.asn1bean.compiler.model.AsnModule;
import com.beanit.asn1bean.compiler.model.AsnNamedNumber;
import com.beanit.asn1bean.compiler.model.AsnNull;
import com.beanit.asn1bean.compiler.model.AsnObjectIdentifier;
import com.beanit.asn1bean.compiler.model.AsnOctetString;
import com.beanit.asn1bean.compiler.model.AsnParameter;
import com.beanit.asn1bean.compiler.model.AsnSelectionType;
import com.beanit.asn1bean.compiler.model.AsnSequenceOf;
import com.beanit.asn1bean.compiler.model.AsnSequenceSet;
import com.beanit.asn1bean.compiler.model.AsnTaggedType;
import com.beanit.asn1bean.compiler.model.AsnType;
import com.beanit.asn1bean.compiler.parser.ASNLexer;
import com.beanit.asn1bean.compiler.parser.ASNParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.etsi.mts.tdl.CollectionDataType;
import org.etsi.mts.tdl.DataElementMapping;
import org.etsi.mts.tdl.DataResourceMapping;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.EnumDataType;
import org.etsi.mts.tdl.MappableDataElement;
import org.etsi.mts.tdl.Member;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.SimpleDataInstance;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.tdlFactory;
import org.etsi.mts.tdl.tdlPackage;
import org.etsi.mts.tdl.transform.AbstractTranslator;

public class ASN2TDLTranslator
extends AbstractTranslator {
    public void translate(String filename) throws Exception {
        AsnModel model = this.getAsnModelFromAsn1File(filename);
        this.drm = (DataResourceMapping)this.getTypeFor("SOURCE_MAPPING", tdlPackage.Literals.DATA_RESOURCE_MAPPING);
        this.drm.setResourceURI("\"" + new File(filename).getName() + "\"");
        for (String moduleName : model.modulesByName.keySet()) {
            Package nestedPackage = tdlFactory.eINSTANCE.createPackage();
            nestedPackage.setName("generated_from_" + ASN2TDLTranslator.cleanName((String)moduleName));
            this.getGeneratedPackage().getNestedPackage().add((Object)nestedPackage);
            AsnModule module = (AsnModule)model.modulesByName.get(moduleName);
            this.translateTypes(module);
        }
    }

    private void translateTypes(AsnModule module) {
        if (module.typesByName != null) {
            this.translateTypes(module, PASS.TYPES);
            this.translateTypes(module, PASS.PROPERTIES);
            this.translateTypes(module, PASS.SELECTION);
            for (String e : module.typesByName.keySet()) {
                DataType dataType = (DataType)this.getTypeFor(e, tdlPackage.Literals.DATA_TYPE);
                DataElementMapping mapping = (DataElementMapping)this.getTypeFor(String.valueOf(e) + "_MAPPING", tdlPackage.Literals.DATA_ELEMENT_MAPPING);
                mapping.setMappableDataElement((MappableDataElement)dataType);
                mapping.setElementURI("\"" + e + "\"");
                mapping.setDataResourceMapping(this.drm);
            }
        }
    }

    private void translateTypes(AsnModule module, PASS pass) {
        System.out.println("PASS: " + pass.name());
        for (String e : module.typesByName.keySet()) {
            AsnType type = (AsnType)module.typesByName.get(e);
            System.out.println("  Type: " + type.name);
            if (type.parameters != null) {
                for (AsnParameter p : type.parameters) {
                    System.out.println("    " + p.dummyReference + " : " + p.paramGovernor);
                }
            }
            this.translateType(type, "", pass);
        }
    }

    private DataType translateType(AsnType type, String prefix, PASS pass) {
        Object generatedType;
        if (type instanceof AsnSequenceSet) {
            generatedType = this.getStructuredDataTypeFor(type.name);
            if (pass != PASS.TYPES) {
                for (AsnElementType c : ((AsnSequenceSet)type).componentTypes) {
                    this.translateMember((StructuredDataType)generatedType, c, pass);
                }
            }
        } else if (type instanceof AsnChoice) {
            generatedType = this.getStructuredDataTypeFor(type.name);
            if (pass != PASS.TYPES) {
                this.constrainWith((DataType)generatedType, "union");
                for (AsnElementType c : ((AsnChoice)type).componentTypes) {
                    this.translateMember((StructuredDataType)generatedType, c, pass);
                }
            }
        } else if (type instanceof AsnSequenceOf) {
            generatedType = (DataType)this.getTypeFor(ASN2TDLTranslator.cleanName((String)type.name), tdlPackage.Literals.COLLECTION_DATA_TYPE);
            if (pass != PASS.TYPES) {
                AsnElementType componentType = ((AsnSequenceOf)type).componentType;
                String itemTypePrefix = "";
                if (componentType.name.isEmpty() && componentType.typeReference instanceof AsnSequenceSet) {
                    itemTypePrefix = String.valueOf(generatedType.getName()) + "___item";
                }
                DataType itemType = this.translateType((AsnType)componentType, itemTypePrefix, pass);
                ((CollectionDataType)generatedType).setItemType(itemType);
                System.out.println("  Flat collection: " + generatedType.getName() + " of " + itemType.getName());
            } else {
                AsnElementType componentType = ((AsnSequenceOf)type).componentType;
                DataType itemType = this.translateType((AsnType)componentType, "", pass);
                ((CollectionDataType)generatedType).setItemType(itemType);
                System.out.println("  Extended collection: " + generatedType.getName() + " of " + itemType.getName());
            }
        } else if (type instanceof AsnElementType) {
            AsnElementType eType = (AsnElementType)type;
            if (eType.definedType != null) {
                DataType existingType = (DataType)this.findElementOfType(eType.definedType.typeName, tdlPackage.Literals.DATA_TYPE);
                generatedType = existingType != null ? existingType : this.getStructuredDataTypeFor(eType.definedType.typeName);
            } else if (eType.typeReference != null) {
                if (eType.typeReference.name.isEmpty() && (eType.typeReference instanceof AsnSequenceSet || eType.typeReference instanceof AsnChoice || eType.typeReference instanceof AsnSequenceOf)) {
                    eType.typeReference.name = String.valueOf(prefix) + eType.name;
                }
                generatedType = this.translateType(eType.typeReference, "", pass);
            } else {
                generatedType = this.getStructuredDataTypeFor(String.valueOf(prefix) + ASN2TDLTranslator.cleanName((String)type.name));
                System.out.println("  Element type: " + type.name + " : " + type.getClass().getSimpleName() + " not supported yet");
            }
        } else if (type instanceof AsnTaggedType) {
            generatedType = this.translateTagged(type, pass);
        } else if (type instanceof AsnDefinedType) {
            generatedType = this.getSimpleDataTypeFor(type.name);
        } else if (type instanceof AsnEnum && pass != PASS.PROPERTIES) {
            generatedType = this.getEnumDataTypeFor(type.name);
            for (AsnNamedNumber literal : ((AsnEnum)type).namedNumberList.namedNumbers) {
                SimpleDataInstance enumLiteral = tdlFactory.eINSTANCE.createSimpleDataInstance();
                enumLiteral.setName(ASN2TDLTranslator.cleanName((String)literal.name));
                enumLiteral.setDataType((DataType)generatedType);
                ((EnumDataType)generatedType).getValue().add((Object)enumLiteral);
            }
        } else if (type instanceof AsnCharacterString) {
            String typeName = type.name;
            if (typeName.isEmpty()) {
                typeName = ((AsnCharacterString)type).stringtype;
            }
            if (typeName.isEmpty()) {
                typeName = type.getClass().getSimpleName();
            }
            generatedType = this.getSimpleDataTypeFor(typeName);
            if (!type.name.isEmpty()) {
                if (((AsnCharacterString)type).stringtype.isEmpty()) {
                    this.constrainWith((DataType)generatedType, type.getClass().getSimpleName());
                } else {
                    this.constrainWith((DataType)generatedType, ((AsnCharacterString)type).stringtype);
                }
            }
        } else if (type instanceof AsnInteger || type instanceof AsnBitString || type instanceof AsnCharacterString || type instanceof AsnBoolean || type instanceof AsnOctetString || type instanceof AsnObjectIdentifier || type instanceof AsnAny || type instanceof AsnNull) {
            String typeName = type.name;
            if (typeName.isEmpty()) {
                typeName = type.getClass().getSimpleName();
            }
            generatedType = this.getSimpleDataTypeFor(typeName);
            if (!type.name.isEmpty()) {
                this.constrainWith((DataType)generatedType, type.getClass().getSimpleName());
            }
        } else if (type instanceof AsnSelectionType) {
            String typeName = type.name;
            String propertyName = ((AsnSelectionType)type).selectionID;
            if (pass == PASS.SELECTION) {
                if (((AsnSelectionType)type).type instanceof AsnDefinedType) {
                    String selectionType = ((AsnDefinedType)((AsnSelectionType)type).type).typeName;
                    StructuredDataType dataType = this.getStructuredDataTypeFor(selectionType);
                    Member selectedMember = (Member)this.findContentWithName(ASN2TDLTranslator.cleanName((String)propertyName), (NamedElement)dataType, tdlPackage.Literals.MEMBER);
                    if (selectedMember != null) {
                        generatedType = selectedMember.getDataType();
                    } else {
                        System.out.println("  Selection for " + propertyName + " in mapping for type: " + selectionType + " not found");
                        generatedType = this.getSimpleDataTypeFor(typeName);
                    }
                } else {
                    System.out.println("  Selection for " + type.name + " : " + ((AsnSelectionType)type).type.getClass().getSimpleName() + " not supported yet");
                    generatedType = this.getSimpleDataTypeFor(typeName);
                }
            } else {
                System.out.println("  Skipping Selection for " + propertyName + "...");
                generatedType = this.getSimpleDataTypeFor("Selection");
            }
        } else {
            String typeName = type.name;
            if (typeName.isEmpty()) {
                typeName = type.getClass().getSimpleName();
            }
            generatedType = this.getStructuredDataTypeFor(typeName);
            System.out.println("  Type: " + type.name + " : " + type.getClass().getSimpleName() + " not supported yet");
        }
        return generatedType;
    }

    private DataType translateTagged(AsnType type, PASS pass) {
        DataType generatedType;
        AsnTaggedType taggedType = (AsnTaggedType)type;
        if (taggedType.typeReference != null) {
            if (taggedType.typeReference.name.isEmpty()) {
                taggedType.typeReference.name = taggedType.name;
            }
            generatedType = this.translateType(taggedType.typeReference, "", pass);
            this.constrainWith(generatedType, taggedType.tag.clazz);
        } else {
            generatedType = null;
            System.out.println("  Tagged type: " + type.name + " : " + type.getClass().getSimpleName() + " not supported yet");
        }
        return generatedType;
    }

    private void translateMember(StructuredDataType generatedType, AsnElementType c, PASS pass) {
        Member m = (Member)this.getContentWithName(c.name, (NamedElement)generatedType, tdlPackage.Literals.MEMBER);
        String prefix = String.valueOf(generatedType.getName()) + "___";
        DataType dataType = this.translateType((AsnType)c, prefix, pass);
        m.setDataType(dataType);
        if (dataType.getName().isEmpty()) {
            if (generatedType.getName().isEmpty()) {
                System.out.println("EMPTY___");
            }
            dataType.setName(String.valueOf(generatedType.getName()) + "___" + ASN2TDLTranslator.cleanName((String)c.name));
        }
        m.setIsOptional(c.isOptional);
        generatedType.getMember().add((Object)m);
    }

    private void translateValues(AsnModule module) {
        if (module.asnValueAssignmentsByName != null) {
            module.asnValueAssignmentsByName.forEach((name, v) -> {
                String desc = "";
                if (v.type instanceof AsnDefinedType) {
                    desc = ((AsnDefinedType)v.type).typeName;
                }
                System.out.println("   Value: " + name + " : " + desc);
            });
        }
    }

    private AsnModel getAsnModelFromAsn1File(String inputFileName) throws Exception {
        AsnModel model = new AsnModel();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(Paths.get(inputFileName, new String[0]), new OpenOption[0]));){
            ASNLexer lexer = new ASNLexer((InputStream)stream);
            ASNParser parser = new ASNParser((TokenStream)lexer);
            parser.module_definitions(model);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return model;
    }

    public static enum PASS {
        TYPES,
        PROPERTIES,
        SELECTION,
        MAPPINGS;

    }
}

