/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.formatting2;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.formatting2.AbstractJavaFormatter;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.xbase.lib.Extension;
import org.etsi.mts.tdl.Action;
import org.etsi.mts.tdl.Annotation;
import org.etsi.mts.tdl.Behaviour;
import org.etsi.mts.tdl.Block;
import org.etsi.mts.tdl.Comment;
import org.etsi.mts.tdl.Connection;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.ElementImport;
import org.etsi.mts.tdl.ExceptionalBehaviour;
import org.etsi.mts.tdl.FormalParameter;
import org.etsi.mts.tdl.LocalExpression;
import org.etsi.mts.tdl.MemberAssignment;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.PackageableElement;
import org.etsi.mts.tdl.ParameterMapping;
import org.etsi.mts.tdl.PeriodicBehaviour;
import org.etsi.mts.tdl.StructuredDataInstance;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.TestObjective;
import org.etsi.mts.tdl.TimeConstraint;
import org.etsi.mts.tdl.TimeLabel;
import org.etsi.mts.tdl.services.TDLtxGrammarAccess;
import org.etsi.mts.tdl.tdlPackage;

public class TDLtxFormatterRef
extends AbstractJavaFormatter {
    @Inject
    @Extension
    private TDLtxGrammarAccess _grammarAccess;

    protected void formatCustom(Element e, IFormattableDocument doc) {
        doc.prepend((EObject)e, p -> p.setNewLines(1));
        doc.prepend(this.textRegionExtensions.allRegionsFor((EObject)e).keyword(","), r -> r.noSpace());
        List rbs = this.textRegionExtensions.regionFor((EObject)e).ruleCallsTo(new AbstractRule[]{this._grammarAccess.getBEGINRule()});
        List res = this.textRegionExtensions.regionFor((EObject)e).ruleCallsTo(new AbstractRule[]{this._grammarAccess.getENDRule()});
        int i = 0;
        for (ISemanticRegion rs : rbs) {
            ISemanticRegion re = (ISemanticRegion)res.get(res.size() - ++i);
            doc.interior(rs, re, p -> p.indent());
        }
        for (ISemanticRegion r2 : rbs) {
            doc.append(r2, p -> p.setNewLines(1));
        }
        for (ISemanticRegion r2 : res) {
            doc.surround(r2, p -> p.setNewLines(1));
        }
    }

    protected void format(Block e, IFormattableDocument doc) {
        for (EObject m : e.eContents()) {
            if (!(m instanceof Annotation) && !(m instanceof LocalExpression)) {
                doc.prepend(m, p -> p.newLine());
                doc.surround(m, p -> p.indent());
                doc.append(m, p -> p.newLine());
            } else if (m instanceof Annotation) {
                doc.append(m, p -> p.newLine());
            }
            doc.format((Object)m);
        }
    }

    protected void format(Element e, IFormattableDocument doc) {
        List open = this.textRegionExtensions.regionFor((EObject)e).ruleCallsTo(new AbstractRule[]{this._grammarAccess.getBEGINRule()});
        List close = this.textRegionExtensions.regionFor((EObject)e).ruleCallsTo(new AbstractRule[]{this._grammarAccess.getENDRule()});
        if (!open.isEmpty()) {
            doc.append((ISemanticRegion)open.get(0), p -> p.newLine());
            doc.interior((ISemanticRegion)open.get(0), (ISemanticRegion)close.get(0), p -> p.indent());
        }
        if (e instanceof Behaviour) {
            List features = this.textRegionExtensions.regionFor((EObject)e).features(new EStructuralFeature[]{tdlPackage.Literals.BEHAVIOUR__TEST_OBJECTIVE});
            for (ISemanticRegion f : features) {
                doc.prepend(f.getPreviousSemanticRegion(), p -> p.newLine());
                doc.surround(f.getPreviousSemanticRegion(), p -> p.indent());
                doc.append(f, p -> p.newLine());
            }
        }
        if (e instanceof Connection) {
            doc.prepend((EObject)e, p -> p.newLine());
        }
        for (EObject m : e.eContents()) {
            if (m instanceof TimeLabel || m instanceof TimeConstraint) {
                doc.append(m, p -> p.newLine());
            } else if (m instanceof Comment || m instanceof TestObjective || m instanceof ExceptionalBehaviour || m instanceof PeriodicBehaviour) {
                doc.prepend(m, p -> p.newLine());
                doc.surround(m, p -> p.indent());
                doc.append(m, p -> p.newLine());
            }
            doc.format((Object)m);
        }
    }

    protected void format(NamedElement e, IFormattableDocument doc) {
        boolean cfr_ignored_0 = e instanceof FormalParameter;
        for (Comment comment : e.getComment()) {
            doc.surround((EObject)comment, p -> p.setNewLines(1));
            doc.format((Object)comment);
        }
        for (Annotation _annotation : e.getAnnotation()) {
            doc.append((EObject)_annotation, p -> p.setNewLines(1));
            doc.format((Object)_annotation);
        }
        for (EObject c : e.eContents()) {
            if (!(c instanceof NamedElement) && !(c instanceof MemberAssignment) && !(c instanceof ParameterMapping) && !(c instanceof Comment) && !(c instanceof Connection)) continue;
            doc.prepend(this.textRegionExtensions.allRegionsFor((EObject)e).keyword(","), r -> r.noSpace());
            this.formatCustom((Element)c, doc);
            doc.format((Object)c);
        }
        if (e instanceof TestObjective) {
            for (ISemanticRegion rs : this.textRegionExtensions.regionFor((EObject)e).ruleCallsTo(new AbstractRule[]{this._grammarAccess.getEStringRule()})) {
                doc.append(rs, p -> p.setNewLines(1));
            }
        }
        if (e instanceof Action) {
            int size = ((Action)e).getFormalParameter().size();
            int i = 0;
            for (FormalParameter m : ((Action)e).getFormalParameter()) {
                doc.prepend((EObject)m, r -> r.newLine());
                doc.surround((EObject)m, p -> p.indent());
                if (++i == size) {
                    doc.append((EObject)m, p -> p.newLine());
                }
                doc.format((Object)m);
            }
        }
        if (e instanceof StructuredDataType) {
            if (!((StructuredDataType)e).getMember().isEmpty()) {
                doc.interior(doc.append(this.textRegionExtensions.regionFor((EObject)e).keyword("("), r -> r.newLine()), doc.prepend(this.textRegionExtensions.regionFor((EObject)e).keyword(")"), r -> r.newLine()), r -> r.indent());
            }
            int size = ((StructuredDataType)e).getMember().size();
            int i = 0;
            for (FormalParameter m : ((StructuredDataType)e).getMember()) {
                doc.prepend((EObject)m, r -> r.newLine());
                doc.surround((EObject)m, p -> p.indent());
                if (++i == size) {
                    doc.append((EObject)m, p -> p.newLine());
                }
                doc.format((Object)m);
            }
        }
        if (e instanceof StructuredDataInstance) {
            int size = ((StructuredDataInstance)e).getMemberAssignment().size();
            int i = 0;
            for (FormalParameter m : ((StructuredDataInstance)e).getMemberAssignment()) {
                doc.prepend((EObject)m, p -> p.newLine());
                doc.surround((EObject)m, p -> p.indent());
                if (++i == size) {
                    doc.append((EObject)m, p -> p.newLine());
                }
                doc.format((Object)m);
            }
        }
    }

    protected void format(Package _package, IFormattableDocument doc) {
        if (this.getPreferences() instanceof MapBasedPreferenceValues) {
            MapBasedPreferenceValues preferences = (MapBasedPreferenceValues)this.getPreferences();
            preferences.put((TypedPreferenceKey)FormatterPreferenceKeys.indentation, (Object)"    ");
        }
        doc.interior((EObject)_package, p -> p.indent());
        Package e = _package;
        this.formatCustom((Element)e, doc);
        List dots = this.textRegionExtensions.allRegionsFor((EObject)e).keywords(new String[]{".", "@", ",", "::"});
        for (ISemanticRegion dot : dots) {
            doc.surround(dot, p -> p.noSpace());
        }
        for (Comment comment : _package.getComment()) {
            doc.surround((EObject)comment, p -> p.setNewLines(1));
            doc.format((Object)comment);
        }
        for (Annotation _annotation : _package.getAnnotation()) {
            doc.surround((EObject)_annotation, p -> p.setNewLines(1));
            doc.format((Object)_annotation);
        }
        for (PackageableElement packageableElement : _package.getPackagedElement()) {
            doc.surround((EObject)packageableElement, p -> p.setNewLines(1));
            doc.format((Object)packageableElement);
        }
        for (ElementImport elementImport : _package.getImport()) {
            doc.surround((EObject)elementImport, p -> p.setNewLines(1));
            doc.format((Object)elementImport);
        }
        for (Package __package : _package.getNestedPackage()) {
            doc.format((Object)__package);
        }
    }

    protected void format(Comment comment, IFormattableDocument doc) {
        doc.surround((EObject)comment, p -> p.setNewLines(1));
    }
}

