/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.helper;

import com.google.inject.Injector;
import java.util.Collections;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.ocl.pivot.internal.delegate.OCLInvocationDelegateFactory;
import org.eclipse.ocl.pivot.internal.delegate.OCLSettingDelegateFactory;
import org.eclipse.ocl.pivot.internal.delegate.OCLValidationDelegateFactory;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLStandaloneSetup;
import org.eclipse.ocl.xtext.essentialocl.EssentialOCLStandaloneSetup;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.serializer.impl.Serializer;
import org.etsi.mts.tdl.TDLan2StandaloneSetup;
import org.etsi.mts.tdl.TDLtxStandaloneSetup;
import org.etsi.mts.tdl.TDLtxiStandaloneSetup;
import org.etsi.mts.tdl.TPLan2StandaloneSetup;
import org.etsi.mts.tdl.impl.tdlPackageImpl;
import org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl;

public class TDLHelper {
    public static Injector injector;
    private static XtextResourceSet resourceSet;

    static {
        TDLHelper.init();
    }

    public static void init() {
        Logger.getRootLogger().setLevel(Level.OFF);
        tdlPackageImpl.init();
        StructuredObjectivesPackageImpl.init();
        EssentialOCLStandaloneSetup.doSetup();
        CompleteOCLStandaloneSetup.doSetup();
        TDLHelper.initializeValidator();
        resourceSet = TDLHelper.getNewResourceSet();
    }

    public static Resource load(String filename) {
        Resource resource = resourceSet.getResource(URI.createURI((String)filename), true);
        return resource;
    }

    public static void link() {
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
    }

    public static void check() {
        resourceSet.getResources().forEach(TDLHelper::check);
    }

    public static void check(String filename) {
        Resource r = TDLHelper.load(filename);
        TDLHelper.check(r);
    }

    private static void check(Resource r) {
        r.getErrors().forEach(e -> System.out.println("Error: " + r.getURI().lastSegment() + ": " + e.getLine() + ": " + e.getMessage()));
        r.getWarnings().forEach(e -> System.out.println("Warning: " + r.getURI().lastSegment() + ": " + e.getLine() + ": " + e.getMessage()));
    }

    public static Resource create(String filename) throws Exception {
        Resource existing = resourceSet.getResource(URI.createFileURI((String)filename), false);
        if (existing != null) {
            existing.delete(Collections.emptyMap());
        }
        Resource resource = resourceSet.createResource(URI.createFileURI((String)filename));
        return resource;
    }

    public static void store(Resource resource) throws Exception {
        resource.save(Collections.emptyMap());
    }

    public static String getText(Resource resource) throws Exception {
        Serializer serializer = (Serializer)injector.getInstance(Serializer.class);
        return serializer.serialize((EObject)resource.getContents().get(0));
    }

    public static XtextResourceSet getNewResourceSet() {
        if (!Platform.isRunning()) {
            new StandaloneSetup().setPlatformUri("./");
            injector = new TDLan2StandaloneSetup().createInjectorAndDoEMFRegistration();
            injector = new TPLan2StandaloneSetup().createInjectorAndDoEMFRegistration();
            injector = new TDLtxiStandaloneSetup().createInjectorAndDoEMFRegistration();
            injector = new TDLtxStandaloneSetup().createInjectorAndDoEMFRegistration();
        } else {
            injector = (Injector)IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createFileURI((String)"t.tdltx")).get(Injector.class);
        }
        XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        return resourceSet;
    }

    public static void resetResourceSet() {
        resourceSet = TDLHelper.getNewResourceSet();
    }

    public static void initializeValidator() {
        String oclDelegateURI = "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot";
        EOperation.Internal.InvocationDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLInvocationDelegateFactory(oclDelegateURI));
        EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLSettingDelegateFactory(oclDelegateURI));
        EValidator.ValidationDelegate.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLValidationDelegateFactory(oclDelegateURI));
    }

    public static XtextResourceSet getResourceSet() {
        return resourceSet;
    }
}

