/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.openapi2tdl.next.doc;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import org.etsi.mts.tdl.openapi2tdl.next.doc.OpenAPIVisitor;

public class RQ
extends OpenAPIVisitor {
    int ri = 0;

    @Override
    public void preamble(OpenAPI model) {
        this.content.append(String.format("\n## Requirements\n", new Object[0]));
        this.content.append(String.format("\n### API: %s\n\n", model.getInfo().getTitle()));
        String header = "| Identifier | Reference  | Type | Applicability | Requirement  | Context |\n| ---------- | ---------- | ---- | ------------- | ------------ | ------- |\n";
        this.content.append(header);
    }

    @Override
    public void path(String path) {
        this.ri = 0;
    }

    @Override
    public void operation(String path, String method, Operation op) {
        String cleanPath = path.toUpperCase().replaceAll("/", "").replaceAll("[\\{\\}]", "_").replaceAll("_$", "");
        ++this.ri;
        String id = "RQ_" + cleanPath + "_" + method + "_" + String.format("%03d", this.ri);
        String reference = "Path: " + path;
        String type = "M";
        String applicability = cleanPath;
        String requirement = "";
        if (op.getSummary() != null) {
            requirement = String.valueOf(requirement) + op.getSummary() + "; ";
        }
        if (op.getDescription() != null) {
            requirement = String.valueOf(requirement) + op.getDescription();
        }
        String context = op.getOperationId();
        this.content.append("| " + id + " | " + reference + " | " + type + " | " + applicability + " | " + requirement + " | " + context + " |\n");
    }

    @Override
    public void postamble(OpenAPI model) {
        String footer = "\n[Table X.Y: Extracted requirements]{custom-style=\"FL\"}\n";
        this.content.append(footer);
    }
}

