/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.openapi2tdl.next;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.util.InlineModelResolver;
import java.io.File;
import org.etsi.mts.tdl.CollectionDataType;
import org.etsi.mts.tdl.DataElementMapping;
import org.etsi.mts.tdl.DataResourceMapping;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.Member;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Parameter;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.tdlPackage;
import org.etsi.mts.tdl.transform.AbstractTranslator;
import org.openapitools.codegen.utils.ModelUtils;

public class OpenAPI2TDLTranslatorNext
extends AbstractTranslator {
    private OpenAPI model;

    public void translate(String filename) throws Exception {
        this.translate(filename, this.sourceMappingTag, this.targetMappingTag);
    }

    public void translate(String filename, String sourceMappingTag, String targetMappingTag) throws Exception {
        this.translate(filename, sourceMappingTag, targetMappingTag, false);
    }

    public void translate(String filename, String sourceMappingTag, String targetMappingTag, boolean inline) throws Exception {
        this.model = OpenAPI2TDLTranslatorNext.parseSpec(filename, inline);
        this.drm = (DataResourceMapping)this.getTypeFor(sourceMappingTag, tdlPackage.Literals.DATA_RESOURCE_MAPPING);
        this.drm.setResourceURI(new File(filename).getName());
        this.drmTarget = (DataResourceMapping)this.getTypeFor(targetMappingTag, tdlPackage.Literals.DATA_RESOURCE_MAPPING);
        this.drmTarget.setResourceURI("generated/java");
        for (String schemaName : this.model.getComponents().getSchemas().keySet()) {
            Schema schema = (Schema)this.model.getComponents().getSchemas().get(schemaName);
            schema.setName(schemaName);
            DataType dataType = this.translate(schema, "");
            this.addMapping(schema, dataType, sourceMappingTag, targetMappingTag);
        }
    }

    private void addMapping(Schema<?> schema, DataType dataType, String sourceMappingTag, String targetMappingTag) {
        DataElementMapping sourceMapping = this.addDataElementMapping("#/components/schemas/" + schema.getName(), dataType, sourceMappingTag);
        DataElementMapping targetMapping = this.addDataElementMapping(schema.getName(), dataType, targetMappingTag);
        targetMapping.setDataResourceMapping(this.drmTarget);
        if (dataType instanceof StructuredDataType) {
            for (Member m : ((StructuredDataType)dataType).getMember()) {
                this.addParameterMapping(sourceMapping, (Parameter)m, m.getName());
                this.addParameterMapping(targetMapping, (Parameter)m, m.getName());
            }
        }
    }

    private DataType translate(Schema<?> schema, String prefix) {
        if (schema.getType() == null && (schema.getProperties() == null || schema.getProperties().isEmpty())) {
            if (schema.getName() == null) {
                System.out.println("Why?");
            }
            return this.getSimpleDataTypeFor(schema.getName());
        }
        String name = String.valueOf(prefix) + schema.getName();
        if (schema.getName() == null) {
            name = String.valueOf(prefix) + "___item";
        }
        if (schema.getProperties() != null && !schema.getProperties().isEmpty() || schema.getType().equals("object")) {
            return this.translateObject(schema, name);
        }
        if (schema.getType().equals("array")) {
            return this.translateArray(schema, name);
        }
        return this.getSimpleDataTypeFor(schema.getType());
    }

    private DataType translateObject(Schema<?> schema, String name) {
        StructuredDataType dataType = this.getStructuredDataTypeFor(name);
        if (schema.getProperties() == null) {
            return dataType;
        }
        for (Object propertyName : schema.getProperties().keySet()) {
            Schema propertySchema = (Schema)schema.getProperties().get(propertyName);
            String reference = propertySchema.get$ref();
            DataType memberType = null;
            if (reference != null) {
                Schema referencedSchema = ModelUtils.getReferencedSchema((OpenAPI)this.model, (Schema)propertySchema);
                referencedSchema.setName(ModelUtils.getSimpleRef((String)reference));
                memberType = this.translate(referencedSchema, "");
            } else {
                memberType = this.translate(propertySchema, String.valueOf(name) + "___");
            }
            Member m = (Member)this.getContentWithName((String)propertyName, (NamedElement)dataType, tdlPackage.Literals.MEMBER);
            m.setDataType(memberType);
            if (m.container() != null) continue;
            dataType.getMember().add((Object)m);
        }
        return dataType;
    }

    private DataType translateArray(Schema<?> schema, String name) {
        Schema itemsSchema = schema.getItems();
        CollectionDataType collectionType = (CollectionDataType)this.getTypeFor(name, tdlPackage.Literals.COLLECTION_DATA_TYPE);
        String reference = itemsSchema.get$ref();
        if (reference != null) {
            Schema referencedSchema = ModelUtils.getReferencedSchema((OpenAPI)this.model, (Schema)itemsSchema);
            DataType itemType = this.translate(referencedSchema, name);
            collectionType.setItemType(itemType);
        } else {
            DataType itemType = this.translate(itemsSchema, name);
            collectionType.setItemType(itemType);
        }
        return collectionType;
    }

    public static OpenAPI parseSpec(String specFilePath, Boolean processInline) {
        OpenAPI openAPI = new OpenAPIParser().readLocation(specFilePath, null, new ParseOptions()).getOpenAPI();
        ModelUtils.getOpenApiVersion((OpenAPI)openAPI, (String)specFilePath, null);
        if (processInline.booleanValue()) {
            InlineModelResolver inlineModelResolver = new InlineModelResolver();
            inlineModelResolver.flatten(openAPI);
        }
        return openAPI;
    }
}

