/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.openapi2tdl.next;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.util.InlineModelResolver;
import java.io.File;
import org.eclipse.emf.ecore.resource.Resource;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.helper.TDLHelper;
import org.etsi.mts.tdl.openapi2tdl.next.OpenAPI2TDLTranslatorNext;
import org.etsi.mts.tdl.transform.AbstractTranslator;
import org.openapitools.codegen.utils.ModelUtils;

public class ConverterNext {
    public static void main(String[] args) throws Exception {
        String filename = args[0];
        ConverterNext.process(filename, String.valueOf(filename) + "-generated-new.tdltx");
    }

    public static String processToString(String inputPath, String outputPath) {
        return ConverterNext.processToString(inputPath, outputPath, "SOURCE_MAPPING", "TARGET_MAPPING");
    }

    public static String processToString(String inputPath, String outputPath, String sourceMapping, String targetMapping) {
        return ConverterNext.processToString(inputPath, outputPath, sourceMapping, targetMapping, false);
    }

    public static String getTargetPackageName(String inputPath) {
        return AbstractTranslator.cleanName((String)new File(inputPath).getName());
    }

    public static String processToString(String inputPath, String outputPath, String sourceMapping, String targetMapping, boolean inline) {
        System.out.println("Exporting: " + outputPath + " : " + new File(outputPath).getAbsolutePath());
        OpenAPI2TDLTranslatorNext translator = new OpenAPI2TDLTranslatorNext();
        String content = "Package imported {}";
        try {
            Resource tr = TDLHelper.create((String)outputPath);
            translator.setTargetResource(tr);
            translator.initTargetResource(ConverterNext.getTargetPackageName(inputPath));
            translator.translate(inputPath, sourceMapping, targetMapping, inline);
            content = TDLHelper.getText((Resource)tr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    public static String process(String inputPath, String outputPath) {
        OpenAPI spec = ConverterNext.parseSpec(inputPath);
        OpenAPI2TDLTranslatorNext translator = new OpenAPI2TDLTranslatorNext();
        String name = "imported";
        try {
            Resource tr = TDLHelper.create((String)outputPath);
            translator.setTargetResource(tr);
            translator.initTargetResource(AbstractTranslator.cleanName((String)new File(inputPath).getName()));
            translator.translate(inputPath);
            name = ((Package)tr.getContents().get(0)).getName();
            TDLHelper.store((Resource)tr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static OpenAPI parseSpec(String specFilePath) {
        OpenAPI openAPI = new OpenAPIParser().readLocation(specFilePath, null, new ParseOptions()).getOpenAPI();
        ModelUtils.getOpenApiVersion((OpenAPI)openAPI, (String)specFilePath, null);
        InlineModelResolver inlineModelResolver = new InlineModelResolver();
        inlineModelResolver.flatten(openAPI);
        return openAPI;
    }
}

