/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.to2tdl;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.etsi.mts.tdl.Behaviour;
import org.etsi.mts.tdl.Comment;
import org.etsi.mts.tdl.ComponentInstance;
import org.etsi.mts.tdl.ComponentInstanceRole;
import org.etsi.mts.tdl.ComponentType;
import org.etsi.mts.tdl.CompoundBehaviour;
import org.etsi.mts.tdl.Connection;
import org.etsi.mts.tdl.DataInstanceUse;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.DataUse;
import org.etsi.mts.tdl.GateInstance;
import org.etsi.mts.tdl.GateReference;
import org.etsi.mts.tdl.GateType;
import org.etsi.mts.tdl.LiteralValueUse;
import org.etsi.mts.tdl.Member;
import org.etsi.mts.tdl.Message;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.Target;
import org.etsi.mts.tdl.TestConfiguration;
import org.etsi.mts.tdl.TestDescription;
import org.etsi.mts.tdl.helper.TDLHelper;
import org.etsi.mts.tdl.structuredobjectives.Content;
import org.etsi.mts.tdl.structuredobjectives.DataReference;
import org.etsi.mts.tdl.structuredobjectives.EntityReference;
import org.etsi.mts.tdl.structuredobjectives.EventOccurrenceSpecification;
import org.etsi.mts.tdl.structuredobjectives.LiteralValue;
import org.etsi.mts.tdl.structuredobjectives.StructuredTestObjective;
import org.etsi.mts.tdl.structuredobjectives.Value;
import org.etsi.mts.tdl.tdlFactory;
import org.etsi.mts.tdl.tdlPackage;
import org.etsi.mts.tdl.transform.AbstractTranslator;

public class TO2TDLTranslator
extends AbstractTranslator {
    public void transform(Package p) {
        List stos = EcoreUtil2.getAllContentsOfType((EObject)p, StructuredTestObjective.class);
        for (StructuredTestObjective sto : stos) {
            this.transformData(sto);
        }
        for (StructuredTestObjective sto : stos) {
            this.transformConfiguration(sto);
            this.transformBehaviour(sto);
        }
    }

    private void transform(StructuredTestObjective sto) {
        System.out.println(sto.getName());
        this.transformData(sto);
        this.transformConfiguration(sto);
        this.transformBehaviour(sto);
    }

    private void transformBehaviour(StructuredTestObjective sto) {
        List ers = EcoreUtil2.getAllContentsOfType((EObject)sto, EntityReference.class);
        String configurationName = this.getConfigurationName(ers);
        TestConfiguration configuration = (TestConfiguration)this.getTypeFor(configurationName, tdlPackage.Literals.TEST_CONFIGURATION);
        TestDescription td = (TestDescription)this.getTypeFor("TD_" + sto.getName(), tdlPackage.Literals.TEST_DESCRIPTION);
        td.setTestConfiguration(configuration);
        td.getTestObjective().add((Object)sto);
        td.setBehaviourDescription(tdlFactory.eINSTANCE.createBehaviourDescription());
        CompoundBehaviour topLevelBehaviour = tdlFactory.eINSTANCE.createCompoundBehaviour();
        topLevelBehaviour.setBlock(tdlFactory.eINSTANCE.createBlock());
        td.getBehaviourDescription().setBehaviour((Behaviour)topLevelBehaviour);
        List eos = EcoreUtil2.getAllContentsOfType((EObject)sto, EventOccurrenceSpecification.class);
        for (EventOccurrenceSpecification eo : eos) {
            Message message = this.transformMessage(eo, configuration);
            topLevelBehaviour.getBlock().getBehaviour().add((Object)message);
        }
    }

    private Message transformMessage(EventOccurrenceSpecification eo, TestConfiguration configuration) {
        GateReference tg;
        GateReference sg;
        Message message = tdlFactory.eINSTANCE.createMessage();
        ComponentInstance source = (ComponentInstance)this.getContentWithName(eo.getEntityReference().getEntity().getName(), (NamedElement)configuration, ComponentInstance.class).get();
        ComponentInstance target = !eo.getOppositeEntityReference().isEmpty() ? (ComponentInstance)this.getContentWithName(((EntityReference)eo.getOppositeEntityReference().get(0)).getEntity().getName(), (NamedElement)configuration, ComponentInstance.class).get() : (ComponentInstance)this.getContentWithName(String.valueOf(source.getName()) + "_Tester", (NamedElement)configuration, ComponentInstance.class).get();
        Connection connection = this.getConnectionBetween(source, target, configuration).get();
        System.out.println("Connection between: " + source.getName() + " and " + target.getName());
        if (((GateReference)connection.getEndPoint().get(0)).getComponent() == source) {
            sg = (GateReference)connection.getEndPoint().get(0);
            tg = (GateReference)connection.getEndPoint().get(1);
        } else {
            sg = (GateReference)connection.getEndPoint().get(1);
            tg = (GateReference)connection.getEndPoint().get(0);
        }
        System.out.println("  -> Interaction between: " + sg.getComponent().getName() + " and " + tg.getComponent().getName());
        System.out.println("     For event: " + NodeModelUtils.getNode((EObject)eo).getText());
        message.setSourceGate(sg);
        Target targets = tdlFactory.eINSTANCE.createTarget();
        message.getTarget().add((Object)targets);
        targets.setTargetGate(tg);
        if (eo.getEventReference().getEvent().getName().contains("receiv")) {
            message.setSourceGate(tg);
            targets.setTargetGate(sg);
        }
        LiteralValueUse du = tdlFactory.eINSTANCE.createLiteralValueUse();
        if (eo.getEventArgument() != null) {
            du.setValue("\"" + NodeModelUtils.getNode((EObject)eo.getEventArgument()).getText().replaceAll("\"", "\\\\\"") + "\"");
        } else {
            du.setValue("\"TODO: Empty argument?\"");
        }
        message.setArgument((DataUse)du);
        Comment debug = tdlFactory.eINSTANCE.createComment();
        debug.setBody("\"Event: " + NodeModelUtils.getNode((EObject)eo).getText().replaceAll("\"", "\\\\\"") + "\"");
        message.getComment().add((Object)debug);
        return message;
    }

    private void transformData(StructuredTestObjective sto) {
        List eos = EcoreUtil2.getAllContentsOfType((EObject)sto, EventOccurrenceSpecification.class);
        for (EventOccurrenceSpecification eo : eos) {
            if (!(eo.getEventArgument() instanceof LiteralValue)) continue;
            this.transform((LiteralValue)eo.getEventArgument());
        }
    }

    private void transformConfiguration(StructuredTestObjective sto) {
        List eos = EcoreUtil2.getAllContentsOfType((EObject)sto, EventOccurrenceSpecification.class);
        boolean oldWay = false;
        if (oldWay) {
            for (EventOccurrenceSpecification eo : eos) {
                this.transform(eo.getEntityReference());
                if (!eo.getOppositeEntityReference().isEmpty()) {
                    for (EntityReference oe : eo.getOppositeEntityReference()) {
                        this.transform(oe);
                    }
                } else {
                    this.transform(eo.getEntityReference(), "_Tester");
                }
                this.transformConfiguration(eo);
            }
        }
        List ers = EcoreUtil2.getAllContentsOfType((EObject)sto, EntityReference.class);
        for (EntityReference er : ers) {
            this.transform(er);
        }
        String configurationName = this.getConfigurationName(ers);
        TestConfiguration configuration = (TestConfiguration)this.getTypeFor(configurationName, tdlPackage.Literals.TEST_CONFIGURATION);
        for (EntityReference er : ers) {
            this.transformComponentInstance(configuration, er);
        }
        for (EventOccurrenceSpecification eo : eos) {
            ComponentInstance i = (ComponentInstance)this.getContentWithName(eo.getEntityReference().getEntity().getName(), (NamedElement)configuration, ComponentInstance.class).get();
            if (!eo.getOppositeEntityReference().isEmpty()) {
                for (EntityReference oe : eo.getOppositeEntityReference()) {
                    ComponentInstance opposite = (ComponentInstance)this.getContentWithName(oe.getEntity().getName(), (NamedElement)configuration, ComponentInstance.class).get();
                    this.transformConnection(configuration, i, opposite);
                }
                continue;
            }
            this.transformComponentInstance(configuration, eo.getEntityReference(), "_Tester");
            ComponentInstance opposite = (ComponentInstance)this.getContentWithName(String.valueOf(eo.getEntityReference().getEntity().getName()) + "_Tester", (NamedElement)configuration, ComponentInstance.class).get();
            this.transformConnection(configuration, i, opposite);
        }
        String body = "\"See " + sto.getName() + "\"";
        Comment source = tdlFactory.eINSTANCE.createComment();
        source.setBody(body);
        configuration.getComment().add((Object)source);
    }

    private String getConfigurationName(List<EntityReference> ers) {
        Set participatingEntityNames = ers.stream().map(e -> e.getEntity().getName()).sorted().collect(Collectors.toSet());
        String configurationName = "TC_" + String.join((CharSequence)"_", participatingEntityNames);
        return configurationName;
    }

    private void transformComponentInstance(TestConfiguration configuration, EntityReference er) {
        this.transformComponentInstance(configuration, er, "");
    }

    private void transformComponentInstance(TestConfiguration configuration, EntityReference er, String suffix) {
        String componentTypeName = String.valueOf(er.getEntity().getName()) + "_Type";
        String instanceName = String.valueOf(er.getEntity().getName()) + suffix;
        ComponentType componentType = (ComponentType)this.getTypeFor(componentTypeName, tdlPackage.Literals.COMPONENT_TYPE);
        Optional optional = this.getContentWithName(instanceName, (NamedElement)configuration, ComponentInstance.class);
        if (optional.isPresent()) {
            ComponentInstance i = (ComponentInstance)optional.get();
        } else {
            ComponentInstance i = (ComponentInstance)tdlFactory.eINSTANCE.create(tdlPackage.Literals.COMPONENT_INSTANCE);
            i.setName(instanceName);
            i.setType(componentType);
            if (instanceName.equals("IUT") || instanceName.equals("SUT")) {
                i.setRole(ComponentInstanceRole.SUT);
            } else {
                i.setRole(ComponentInstanceRole.TESTER);
            }
            if (instanceName.contains("Tester")) {
                i.setRole(ComponentInstanceRole.TESTER);
            }
            configuration.getComponentInstance().add((Object)i);
        }
    }

    private void transformConfiguration(EventOccurrenceSpecification eo) {
        String componentTypeName = String.valueOf(eo.getEntityReference().getEntity().getName()) + "_Type";
        if (!eo.getOppositeEntityReference().isEmpty()) {
            Iterator iterator = eo.getOppositeEntityReference().iterator();
            while (iterator.hasNext()) {
                EntityReference cfr_ignored_0 = (EntityReference)iterator.next();
            }
        } else {
            String configurationName = String.valueOf(componentTypeName) + "_" + componentTypeName + "_Tester";
            TestConfiguration configuration = (TestConfiguration)this.getTypeFor(configurationName, tdlPackage.Literals.TEST_CONFIGURATION);
            this.transformComponentInstance(configuration, eo.getEntityReference());
            this.transformComponentInstance(configuration, eo.getEntityReference(), "_Tester");
            ComponentInstance i = (ComponentInstance)this.getContentWithName(eo.getEntityReference().getEntity().getName(), (NamedElement)configuration, ComponentInstance.class).get();
            ComponentInstance tester = (ComponentInstance)this.getContentWithName(String.valueOf(eo.getEntityReference().getEntity().getName()) + "_Tester", (NamedElement)configuration, ComponentInstance.class).get();
            tester.setRole(ComponentInstanceRole.TESTER);
            this.transformConnection(configuration, i, tester);
        }
    }

    private void transformConnection(TestConfiguration configuration, ComponentInstance i, ComponentInstance ti) {
        Optional<Connection> optionalConnection = this.getConnectionBetween(i, ti, configuration);
        if (optionalConnection.isPresent()) {
            Connection c = optionalConnection.get();
        } else {
            Connection c = (Connection)tdlFactory.eINSTANCE.create(tdlPackage.Literals.CONNECTION);
            GateReference gr1 = (GateReference)tdlFactory.eINSTANCE.create(tdlPackage.Literals.GATE_REFERENCE);
            gr1.setComponent(i);
            gr1.setGate((GateInstance)i.getType().getGateInstance().get(0));
            GateReference gr2 = (GateReference)tdlFactory.eINSTANCE.create(tdlPackage.Literals.GATE_REFERENCE);
            gr2.setComponent(ti);
            gr2.setGate((GateInstance)ti.getType().getGateInstance().get(0));
            c.getEndPoint().add((Object)gr1);
            c.getEndPoint().add((Object)gr2);
            configuration.getConnection().add((Object)c);
        }
    }

    private Optional<Connection> getConnectionBetween(ComponentInstance i, ComponentInstance ti, TestConfiguration configuration) {
        Optional optionalConnection = this.getContentWithPredicate(e -> ((GateReference)e.getEndPoint().get(0)).getComponent().equals(i) && ((GateReference)e.getEndPoint().get(1)).getComponent().equals(ti) || ((GateReference)e.getEndPoint().get(1)).getComponent().equals(i) && ((GateReference)e.getEndPoint().get(0)).getComponent().equals(ti), (NamedElement)configuration, Connection.class);
        return optionalConnection;
    }

    private void transform(EntityReference entityReference) {
        this.transform(entityReference, "");
    }

    private void transform(EntityReference entityReference, String suffix) {
        String componentTypeName = String.valueOf(entityReference.getEntity().getName()) + "_Type" + suffix;
        String gateTypeName = String.valueOf(entityReference.getEntity().getName()) + "_GateType";
        GateType gateType = (GateType)this.getTypeFor(gateTypeName, tdlPackage.Literals.GATE_TYPE);
        EventOccurrenceSpecification eo = (EventOccurrenceSpecification)entityReference.container();
        Value a = eo.getEventArgument();
        if (a instanceof LiteralValue) {
            String name = this.getQualifiedName((LiteralValue)a);
            StructuredDataType generatedType = this.getStructuredDataTypeFor(name);
            gateType.getDataType().add((Object)generatedType);
        }
        ComponentType componentType = (ComponentType)this.getTypeFor(componentTypeName, tdlPackage.Literals.COMPONENT_TYPE);
        String gateName = "g";
        Optional<GateInstance> optional = componentType.getGateInstance().stream().filter(e -> e.getName().equals(gateName)).findFirst();
        if (optional.isPresent()) {
            GateInstance generatedGate = optional.get();
        } else {
            GateInstance generatedGate = tdlFactory.eINSTANCE.createGateInstance();
            generatedGate.setName(gateName);
            generatedGate.setType(gateType);
            componentType.getGateInstance().add((Object)generatedGate);
        }
    }

    private void transform(LiteralValue lv) {
        System.out.println("    " + NodeModelUtils.findActualNodeFor((EObject)lv).getText());
        String name = this.getQualifiedName(lv);
        StructuredDataType generatedType = this.getStructuredDataTypeFor(name);
        this.transformMembers(generatedType, (EList<Content>)lv.getContent());
    }

    private String getQualifiedName(LiteralValue lv) {
        List bodies;
        String name = lv.getName();
        if (this.useQualifiers && !(bodies = lv.getComment().stream().map(e -> e.getBody()).filter(e -> !e.equals("the") && !e.equals("a")).collect(Collectors.toList())).isEmpty()) {
            name = String.valueOf(String.join((CharSequence)"_", bodies)) + "_" + name;
        }
        return name;
    }

    private void transformMembers(StructuredDataType generatedType, EList<Content> allContent) {
        List memberNames = generatedType.getMember().stream().map(e -> e.getName()).collect(Collectors.toList());
        List content = allContent.stream().filter(e -> !e.getName().equals("omit")).collect(Collectors.toList());
        for (Content c : content) {
            Member m;
            if (memberNames.contains(c.getName())) {
                m = (Member)generatedType.getMember().get(memberNames.indexOf(c.getName()));
            } else {
                m = tdlFactory.eINSTANCE.createMember();
                m.setName(c.getName());
            }
            if (!c.getContent().isEmpty()) {
                m.setDataType((DataType)this.transform(generatedType, c));
            } else if (c.getValue() instanceof LiteralValue) {
                if (((LiteralValue)c.getValue()).getName().equals("B")) {
                    m.setDataType((DataType)this.getSimpleDataTypeFor("BITSTRING"));
                } else {
                    m.setDataType((DataType)this.stringType);
                }
            } else if (c.getValue() instanceof DataReference) {
                if (((DataReference)c.getValue()).getContent() instanceof DataInstanceUse) {
                    DataInstanceUse dataInstanceUse = (DataInstanceUse)((DataReference)c.getValue()).getContent();
                    m.setDataType(dataInstanceUse.getDataInstance().getDataType());
                } else {
                    m.setDataType((DataType)this.referencedType);
                }
            } else {
                m.setDataType((DataType)this.stringType);
            }
            generatedType.getMember().add((Object)m);
        }
    }

    private StructuredDataType transform(StructuredDataType containerType, Content c) {
        StructuredDataType generatedType = this.getStructuredDataTypeFor(String.valueOf(containerType.getName()) + "_" + c.getName());
        this.transformMembers(generatedType, (EList<Content>)c.getContent());
        return generatedType;
    }

    public void translate(String filename) throws Exception {
        Resource sr = TDLHelper.load((String)filename);
        Resource tr = TDLHelper.create((String)(String.valueOf(filename) + "_generated.tdltx"));
        Package p = (Package)sr.getContents().get(0);
        this.setTargetResource(tr);
        this.initTargetResource("generated_from_" + p.getName());
        this.addImports(p);
        this.transform(p);
        TDLHelper.store((Resource)tr);
    }
}

