/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.constraints.ui.handlers;

import java.net.URI;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.epsilon.evl.emf.validation.CompositeEValidator;
import org.eclipse.epsilon.evl.emf.validation.EvlValidator;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.etsi.mts.tdl.tdlPackage;

public class ToggleValidationHandler
extends AbstractHandler {
    private static boolean initialised;
    private static EvlValidator evlValidator;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ScopedPreferenceStore s = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.etsi.mts.tdl.constraints.ui.autoValidation");
        boolean enabled = s.getBoolean("enabled");
        if (!enabled) {
            try {
                ToggleValidationHandler.init();
                ToggleValidationHandler.registerValidator((EPackage)tdlPackage.eINSTANCE);
                enabled = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ToggleValidationHandler.stop();
            enabled = false;
        }
        s.setValue("enabled", enabled);
        return null;
    }

    public static void stop() {
        tdlPackage ePackage = tdlPackage.eINSTANCE;
        EValidator existingValidator = EValidator.Registry.INSTANCE.getEValidator((EPackage)ePackage);
        if (existingValidator instanceof CompositeEValidator) {
            ((CompositeEValidator)existingValidator).getDelegates().remove(evlValidator);
            Collection delegates = ((CompositeEValidator)existingValidator).getDelegates();
            delegates.removeIf(d -> d instanceof EvlValidator);
        } else {
            if (existingValidator == null) {
                existingValidator = EObjectValidator.INSTANCE;
            }
            CompositeEValidator newValidator = new CompositeEValidator();
            newValidator.getDelegates().add(existingValidator);
            newValidator.getDelegates().add(evlValidator);
            EValidator.Registry.INSTANCE.put((Object)ePackage, (Object)newValidator);
        }
    }

    public static void init() throws Exception {
        if (initialised) {
            return;
        }
        System.out.println("Init EVL validator..");
        tdlPackage ePackage = tdlPackage.eINSTANCE;
        String modelName = "TDL";
        String bundleId = "org.etsi.mts.tdl.constraints";
        URI evlScriptURI = new URI("platform:/plugin/" + bundleId + "/constraints/tdl-generated-ETSI-ES-203-119-1-V1.5.1-fixed.evl");
        evlValidator = new EvlValidator(evlScriptURI, modelName, ePackage.getNsURI(), bundleId);
        evlValidator.setShowErrorDialog(false);
        initialised = true;
    }

    private static void registerValidator(EPackage ePackage) {
        EValidator existingValidator = EValidator.Registry.INSTANCE.getEValidator(ePackage);
        if (existingValidator instanceof CompositeEValidator) {
            ((CompositeEValidator)existingValidator).getDelegates().add(evlValidator);
        } else {
            if (existingValidator == null) {
                existingValidator = EObjectValidator.INSTANCE;
            }
            CompositeEValidator newValidator = new CompositeEValidator();
            newValidator.getDelegates().add(existingValidator);
            newValidator.getDelegates().add(evlValidator);
            EValidator.Registry.INSTANCE.put((Object)ePackage, (Object)newValidator);
        }
    }
}

