/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.json2tdl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import org.etsi.mts.tdl.CollectionDataInstance;
import org.etsi.mts.tdl.CollectionDataType;
import org.etsi.mts.tdl.DataElementMapping;
import org.etsi.mts.tdl.DataElementUse;
import org.etsi.mts.tdl.DataResourceMapping;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.DataUse;
import org.etsi.mts.tdl.LiteralValueUse;
import org.etsi.mts.tdl.Member;
import org.etsi.mts.tdl.MemberAssignment;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Parameter;
import org.etsi.mts.tdl.ParameterBinding;
import org.etsi.mts.tdl.SimpleDataType;
import org.etsi.mts.tdl.StructuredDataInstance;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.tdlFactory;
import org.etsi.mts.tdl.tdlPackage;
import org.etsi.mts.tdl.transform.AbstractTranslator;

public class JSON2TDLTranslator
extends AbstractTranslator {
    private static final String JSON_STRING = "JSON_String";

    private void dumpJson(String prefix, Map.Entry<String, JsonElement> e) {
        System.out.println();
        System.out.print(String.valueOf(prefix) + "\t" + e.getKey() + ":");
        this.dumpJson(String.valueOf(prefix) + "\t", e.getValue());
    }

    private void dumpJson(String prefix, JsonElement e) {
        if (e.isJsonArray()) {
            ((JsonArray)e).forEach(a -> this.dumpJson(String.valueOf(prefix) + "\t", (JsonElement)a));
        } else if (e.isJsonObject()) {
            ((JsonObject)e).entrySet().forEach(a -> this.dumpJson(String.valueOf(prefix) + "\t", (Map.Entry<String, JsonElement>)a));
        } else if (e.isJsonPrimitive()) {
            System.out.print("  " + e);
        }
    }

    public boolean isValid(String json) {
        try {
            JsonParser.parseString((String)json);
        }
        catch (JsonSyntaxException e) {
            return false;
        }
        return true;
    }

    public void translate(String targetFilename) throws Exception {
        String sourceMappingTag = "SOURCE_MAPPING";
        this.drm = (DataResourceMapping)this.getTypeFor(sourceMappingTag, tdlPackage.Literals.DATA_RESOURCE_MAPPING);
        this.drm.setResourceURI(new File(targetFilename).getName());
        try {
            JsonElement jsonElement = JsonParser.parseReader((Reader)new FileReader(targetFilename));
            this.dumpJson("", jsonElement);
            System.out.println();
            String prefix = "JSON";
            this.getSimpleDataTypeFor(JSON_STRING);
            this.translate(prefix, jsonElement);
            this.translateInstance(prefix, jsonElement);
            this.drm = (DataResourceMapping)this.getTypeFor(sourceMappingTag, tdlPackage.Literals.DATA_RESOURCE_MAPPING);
            this.drm.setResourceURI(new File(targetFilename).getName());
            this.addMappings(prefix, jsonElement);
            DataType root = this.getDataTypeFor(prefix);
            root.setName(String.valueOf(prefix) + "_" + JSON2TDLTranslator.cleanName((String)this.drm.getResourceURI()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void translate(String prefix, JsonElement e) {
        if (e.isJsonArray()) {
            String iPrefix = String.valueOf(prefix) + "_item";
            CollectionDataType collectionType = (CollectionDataType)this.getTypeFor(prefix, tdlPackage.Literals.COLLECTION_DATA_TYPE);
            ((JsonArray)e).forEach(a -> this.translate(iPrefix, (JsonElement)a));
            DataType itemType = this.getDataTypeFor(JSON_STRING);
            if (!e.getAsJsonArray().isEmpty() && !e.getAsJsonArray().get(0).isJsonPrimitive()) {
                itemType = this.getDataTypeFor(iPrefix);
            }
            collectionType.setItemType(itemType);
        } else if (e.isJsonObject()) {
            StructuredDataType dataType = this.getStructuredDataTypeFor(prefix);
            ((JsonObject)e).entrySet().forEach(a -> this.translate(prefix, (Map.Entry<String, JsonElement>)a));
        } else {
            e.isJsonPrimitive();
        }
    }

    private void translate(String prefix, Map.Entry<String, JsonElement> e) {
        String iPrefix = "JSON_" + e.getKey();
        if (this.fullPrefix) {
            iPrefix = String.valueOf(prefix) + "_" + e.getKey();
        }
        this.translate(iPrefix, e.getValue());
        StructuredDataType dataType = this.getStructuredDataTypeFor(prefix);
        Member m = (Member)this.getContentWithName(e.getKey(), (NamedElement)dataType, tdlPackage.Literals.MEMBER);
        SimpleDataType memberType = this.getSimpleDataTypeFor(JSON_STRING);
        if (!e.getValue().isJsonPrimitive()) {
            memberType = this.getDataTypeFor(iPrefix);
        }
        m.setDataType((DataType)memberType);
        dataType.getMember().add((Object)m);
    }

    private void addMappings(String prefix, JsonElement e) {
        if (e.isJsonArray()) {
            String iPrefix = String.valueOf(prefix) + "_item";
            CollectionDataType collectionType = (CollectionDataType)this.getTypeFor(prefix, tdlPackage.Literals.COLLECTION_DATA_TYPE);
            ((JsonArray)e).forEach(a -> this.addMappings(iPrefix, (JsonElement)a));
        } else if (e.isJsonObject()) {
            StructuredDataType dataType = this.getStructuredDataTypeFor(prefix);
            DataElementMapping addDataElementMapping = this.addDataElementMapping(prefix.replaceAll("_", "."), (DataType)dataType, this.sourceMappingTag);
            ((JsonObject)e).entrySet().forEach(a -> this.addMappings(prefix, (Map.Entry<String, JsonElement>)a));
        } else {
            e.isJsonPrimitive();
        }
    }

    private void addMappings(String prefix, Map.Entry<String, JsonElement> e) {
        String iPrefix = "JSON_" + e.getKey();
        if (this.fullPrefix) {
            iPrefix = String.valueOf(prefix) + "_" + e.getKey();
        }
        StructuredDataType dataType = this.getStructuredDataTypeFor(prefix);
        Member m = (Member)this.getContentWithName(e.getKey(), (NamedElement)dataType, tdlPackage.Literals.MEMBER);
        DataElementMapping sourceMapping = (DataElementMapping)this.getTypeFor(String.valueOf(prefix) + "_" + this.sourceMappingTag, tdlPackage.Literals.DATA_ELEMENT_MAPPING);
        this.addParameterMapping(sourceMapping, (Parameter)m, e.getKey());
        this.addMappings(iPrefix, e.getValue());
    }

    private void translateInstance(String prefix, JsonElement e) {
        if (e.isJsonArray()) {
            String iPrefix = String.valueOf(prefix) + "_item";
            CollectionDataType collectionType = (CollectionDataType)this.getTypeFor(prefix, tdlPackage.Literals.COLLECTION_DATA_TYPE);
            CollectionDataInstance cInstance = (CollectionDataInstance)this.getTypeFor(String.valueOf(prefix) + "_instance", tdlPackage.Literals.COLLECTION_DATA_INSTANCE);
            cInstance.setDataType((DataType)collectionType);
            ((JsonArray)e).forEach(a -> {
                boolean bl = cInstance.getItem().add((Object)this.translateDataUse(iPrefix, (JsonElement)a));
            });
        } else if (e.isJsonObject()) {
            StructuredDataType dataType = this.getStructuredDataTypeFor(prefix);
            StructuredDataInstance eInstance = (StructuredDataInstance)this.getTypeFor(String.valueOf(prefix) + "_instance", tdlPackage.Literals.STRUCTURED_DATA_INSTANCE);
            eInstance.setDataType((DataType)dataType);
            ((JsonObject)e).entrySet().forEach(a -> {
                boolean bl = eInstance.getMemberAssignment().add((Object)this.translateMemberAssignment(prefix, (Map.Entry<String, JsonElement>)a));
            });
        } else if (e.isJsonPrimitive()) {
            System.out.print("  " + e);
        }
    }

    private MemberAssignment translateMemberAssignment(String prefix, Map.Entry<String, JsonElement> e) {
        StructuredDataType dataType = this.getStructuredDataTypeFor(prefix);
        Member m = (Member)this.getContentWithName(e.getKey(), (NamedElement)dataType, tdlPackage.Literals.MEMBER);
        DataUse du = this.translateDataUse(m.getDataType().getName(), e.getValue());
        MemberAssignment ma = (MemberAssignment)tdlFactory.eINSTANCE.create(tdlPackage.Literals.MEMBER_ASSIGNMENT);
        ma.setMember(m);
        ma.setMemberSpec(du);
        return ma;
    }

    private DataUse translateDataUse(String prefix, JsonElement e) {
        if (e.isJsonArray()) {
            String iPrefix = String.valueOf(prefix) + "_item";
            DataElementUse du = (DataElementUse)tdlFactory.eINSTANCE.create(tdlPackage.Literals.DATA_ELEMENT_USE);
            ((JsonArray)e).forEach(a -> {
                boolean bl = du.getItem().add((Object)this.translateDataUse(iPrefix, (JsonElement)a));
            });
            return du;
        }
        if (e.isJsonObject()) {
            DataElementUse du = (DataElementUse)tdlFactory.eINSTANCE.create(tdlPackage.Literals.DATA_ELEMENT_USE);
            ((JsonObject)e).entrySet().forEach(a -> {
                boolean bl = du.getArgument().add((Object)this.translateParameterBindings(prefix, (Map.Entry<String, JsonElement>)a));
            });
            return du;
        }
        if (e.isJsonPrimitive()) {
            LiteralValueUse lvu = (LiteralValueUse)tdlFactory.eINSTANCE.create(tdlPackage.Literals.LITERAL_VALUE_USE);
            lvu.setValue(e.getAsString());
            return lvu;
        }
        return null;
    }

    private ParameterBinding translateParameterBindings(String prefix, Map.Entry<String, JsonElement> a) {
        StructuredDataType dataType = this.getStructuredDataTypeFor(prefix);
        Member m = (Member)this.getContentWithName(a.getKey(), (NamedElement)dataType, tdlPackage.Literals.MEMBER);
        ParameterBinding pb = (ParameterBinding)tdlFactory.eINSTANCE.create(tdlPackage.Literals.PARAMETER_BINDING);
        pb.setParameter((Parameter)m);
        pb.setDataUse(this.translateDataUse(m.getDataType().getName(), a.getValue()));
        return pb;
    }
}

