/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.graphical.labels.scoping;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.etsi.mts.tdl.DataInstanceUse;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.DataUse;
import org.etsi.mts.tdl.FormalParameterUse;
import org.etsi.mts.tdl.FunctionCall;
import org.etsi.mts.tdl.Member;
import org.etsi.mts.tdl.MemberReference;
import org.etsi.mts.tdl.ParameterBinding;
import org.etsi.mts.tdl.PredefinedFunctionCall;
import org.etsi.mts.tdl.SpecialValueUse;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.VariableUse;

public class DataScopeProvider
extends AbstractDeclarativeScopeProvider {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    public IScope scope_ParameterBinding_parameter(ParameterBinding parameterBinding, EReference ref) {
        DataUse dataUse = (DataUse)parameterBinding.eContainer();
        return this.getDataUseMembers(dataUse);
    }

    public IScope scope_MemberReference_member(MemberReference memberRef, EReference ref) {
        DataUse dataUse = (DataUse)memberRef.eContainer();
        return this.getDataUseMembers(dataUse);
    }

    private IScope getDataUseMembers(DataUse dataUse) {
        ArrayList<IEObjectDescription> descriptions;
        DataType type = this.getDataUseType(dataUse);
        if (type instanceof StructuredDataType) {
            descriptions = new ArrayList<IEObjectDescription>();
            this.gatherMembers((StructuredDataType)type, descriptions);
        } else {
            descriptions = Collections.EMPTY_LIST;
        }
        QNameShadowingScope scope = new QNameShadowingScope(descriptions);
        return scope;
    }

    private DataType getDataUseType(DataUse dataUse) {
        if (dataUse instanceof DataInstanceUse) {
            return ((DataInstanceUse)dataUse).getDataInstance().getDataType();
        }
        if (dataUse instanceof VariableUse) {
            return ((VariableUse)dataUse).getVariable().getDataType();
        }
        if (dataUse instanceof SpecialValueUse) {
            return null;
        }
        if (dataUse instanceof FormalParameterUse) {
            ((FormalParameterUse)dataUse).getParameter().getDataType();
        } else if (dataUse instanceof FunctionCall) {
            ((FunctionCall)dataUse).getFunction().getReturnType();
        } else if (dataUse instanceof PredefinedFunctionCall) {
            ((PredefinedFunctionCall)dataUse).getFunction().getReturnType();
        }
        return null;
    }

    private void gatherMembers(StructuredDataType type, List<IEObjectDescription> descriptions) {
        block0: for (Member m : type.getMember()) {
            DifferringQNameEObjectDescription desc = new DifferringQNameEObjectDescription(this.qualifiedNameProvider.getFullyQualifiedName((EObject)m), (EObject)m);
            QualifiedName qName = desc.getQualifiedName();
            for (IEObjectDescription d : descriptions) {
                if (((DifferringQNameEObjectDescription)d).getQualifiedName().equals((Object)qName)) continue block0;
            }
            descriptions.add((IEObjectDescription)desc);
        }
    }

    class DifferringQNameEObjectDescription
    extends EObjectDescription {
        private QualifiedName name;

        public DifferringQNameEObjectDescription(QualifiedName qualifiedName, EObject element) {
            super(qualifiedName, element, Collections.emptyMap());
            this.name = QualifiedName.create((String)qualifiedName.getLastSegment());
        }

        public QualifiedName getName() {
            return this.name;
        }
    }

    class QNameShadowingScope
    extends SimpleScope {
        public QNameShadowingScope(Iterable<IEObjectDescription> descriptions) {
            super(descriptions);
        }

        protected Object getShadowingKey(IEObjectDescription description) {
            return description.getQualifiedName();
        }
    }
}

