/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.openapi2tdl.next.doc;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import java.util.List;
import java.util.stream.Collectors;
import org.etsi.mts.tdl.openapi2tdl.next.doc.OpenAPIVisitor;

public class ICSPath
extends OpenAPIVisitor {
    int ri = 0;
    private String level = "Path";

    @Override
    public void preamble(OpenAPI model) {
        this.content.append(String.format("\n#### %s\n\n", this.level));
        String header = "| ID | Resource  | Reference | Method | Type  | Request | Response |\n| -- | --------- | --------- | ------ | ----- | ------- | -------- |\n";
        this.content.append(header);
    }

    @Override
    public void path(String path) {
        path.replaceAll("/", "").replaceAll("[\\{\\}]", "_").replaceAll("_$", "");
        ++this.ri;
        String pid = "P" + this.ri;
        String type = "M";
        String resource = path;
        String request = "(fill in request)";
        PathItem pathItem = (PathItem)this.model.getPaths().get((Object)path);
        List ops = pathItem.readOperationsMap().keySet().stream().map(e -> e.name()).collect(Collectors.toList());
        List opIds = pathItem.readOperationsMap().values().stream().map(e -> e.getOperationId()).collect(Collectors.toList());
        List allResponses = pathItem.readOperationsMap().values().stream().flatMap(e -> e.getResponses().keySet().stream()).collect(Collectors.toList());
        String id = pid;
        String methods = String.join((CharSequence)",", ops);
        String pathReference = "Path: " + path + " : " + String.join((CharSequence)",", opIds);
        this.content.append(String.format("| " + id + " | " + resource + " | " + pathReference + " | " + methods + " | " + type + " | " + request + " | " + String.join((CharSequence)",", allResponses) + " |\n", new Object[0]));
    }

    @Override
    public void postamble(OpenAPI model) {
        String footer = "\n[Table X.Y: Extracted ICS (" + this.level + ")]{custom-style=\"FL\"}\n";
        this.content.append(footer);
    }
}

