/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ParameterKind implements Enumerator
{
    IN(0, "In", "In"),
    OUT(1, "Out", "Out"),
    EXCEPTION(2, "Exception", "Exception");

    public static final int IN_VALUE = 0;
    public static final int OUT_VALUE = 1;
    public static final int EXCEPTION_VALUE = 2;
    private static final ParameterKind[] VALUES_ARRAY;
    public static final List<ParameterKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParameterKind[]{IN, OUT, EXCEPTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParameterKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterKind get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return OUT;
            }
            case 2: {
                return EXCEPTION;
            }
        }
        return null;
    }

    private ParameterKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

