/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.xtext.completeocl.validation.CompleteOCLEObjectValidator;
import org.etsi.mts.tdl.extendedconfigurations.ExtendedConfigurationsPackage;
import org.etsi.mts.tdl.structuredobjectives.StructuredObjectivesPackage;
import org.etsi.mts.tdl.tdlPackage;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public void start(BundleContext context) throws Exception {
        this.registerValidator("model/tdl-constraints.ocl", tdlPackage.eINSTANCE, context);
    }

    void registerValidator(String path, EPackage ePakcage, BundleContext context) {
        Path oclPath = new Path(path);
        URL oclURL = FileLocator.find((Bundle)context.getBundle(), (IPath)oclPath);
        try {
            URI oclURI = URI.createURI((String)oclURL.toURI().toString());
            CompleteOCLEObjectValidator validator = new CompleteOCLEObjectValidator(ePakcage, oclURI){

                public boolean initialize(@NonNull EnvironmentFactoryInternal environmentFactory) {
                    boolean success = super.initialize(environmentFactory);
                    if (success) {
                        ResourceSet resourceSet = environmentFactory.getResourceSet();
                        CSResource xtextResource = (CSResource)resourceSet.getResource(this.oclURI, true);
                        EList errors = xtextResource.getErrors();
                        if (!$assertionsDisabled && errors == null) {
                            throw new AssertionError();
                        }
                        String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
                        if (message != null) {
                            System.err.println("Failed to load '" + this.oclURI + message);
                            return false;
                        }
                    }
                    return success;
                }

                protected boolean validatePivot(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable DiagnosticChain diagnostics, Map<Object, Object> validationContext) {
                    if (object instanceof EObject) {
                        URI uri = ((EObject)object).eResource().getURI();
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
                        if (file != null && file.isDerived()) {
                            return true;
                        }
                    }
                    return super.validatePivot(eClassifier, object, diagnostics, validationContext);
                }
            };
            EValidator.Registry.INSTANCE.put((Object)tdlPackage.eINSTANCE, (Object)validator);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        EValidator.Registry.INSTANCE.remove((Object)StructuredObjectivesPackage.eINSTANCE);
        EValidator.Registry.INSTANCE.remove((Object)ExtendedConfigurationsPackage.eINSTANCE);
        EValidator.Registry.INSTANCE.remove((Object)tdlPackage.eINSTANCE);
    }
}

