/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.graphical.sirius.part;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramListEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.OneLineMarginBorder;
import org.etsi.mts.tdl.graphical.sirius.EditPartConfiguration;
import org.etsi.mts.tdl.graphical.sirius.figure.TwoLineMarginBorder;
import org.etsi.mts.tdl.graphical.sirius.part.Util;

public class NodeListWithHeaderEditPart
extends AbstractDiagramListEditPart {
    public NodeListWithHeaderEditPart(View view) {
        super(view);
    }

    protected void addDropShadow(NodeFigure figure, IFigure shape) {
    }

    protected boolean removeBorders() {
        return true;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.removeBorders()) {
            Util.disableOutlines((IFigure)this.getPrimaryShape());
        }
    }

    public void refresh() {
        super.refresh();
        this.replaceBorders();
    }

    protected List getModelChildren() {
        return Util.getModelChildren(this.getModel());
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        super.addChildVisual(childEditPart, index);
        if (childEditPart instanceof GraphicalEditPart) {
            this.replaceBorder((GraphicalEditPart)childEditPart, index);
        }
    }

    private void replaceBorders() {
        int index = 0;
        for (Object childEditPart : this.getChildren()) {
            if (!(childEditPart instanceof GraphicalEditPart)) continue;
            this.replaceBorder((GraphicalEditPart)childEditPart, index);
            ++index;
        }
    }

    protected boolean needsBottomSeparator(GraphicalEditPart editPart) {
        return EditPartConfiguration.needsBottomSeparator((IGraphicalEditPart)editPart);
    }

    private void replaceBorder(GraphicalEditPart childEditPart, int index) {
        IFigure f = childEditPart.getFigure();
        String mappingName = Util.getMappingId((IGraphicalEditPart)childEditPart);
        if (mappingName.equals("gateTypeGateType")) {
            CompoundBorder marginLineBorder = new CompoundBorder((Border)new MarginBorder(3), (Border)new LineBorder(1));
            CompoundBorder border = new CompoundBorder((Border)new LineBorder(1), (Border)marginLineBorder);
            f.setBorder((Border)border);
        } else if (childEditPart instanceof IDiagramNameEditPart) {
            f.setBorder((Border)new MarginBorder(index == 0 ? 5 : 0, 5, index == 0 ? 0 : 5, 5));
        } else if (!this.needsBottomSeparator(childEditPart)) {
            f.setBorder(null);
        } else if (EditPartConfiguration.needsTopSeparator((IGraphicalEditPart)childEditPart)) {
            f.setBorder(null);
            TwoLineMarginBorder border = new TwoLineMarginBorder(8, 32);
            border.setMargin(0, 0, 5, 0);
            f.getParent().setBorder((Border)border);
        } else {
            OneLineMarginBorder border = new OneLineMarginBorder(32);
            border.setMargin(0, 0, 5, 0);
            f.setBorder((Border)border);
        }
    }

    public DragTracker getDragTracker(Request request) {
        DragTracker dt = this.getCustomDragTracker(request);
        if (dt != null) {
            return dt;
        }
        return super.getDragTracker(request);
    }

    protected DragTracker getCustomDragTracker(Request request) {
        EditPart p = this.getParent();
        while (!(p.getParent() instanceof DiagramEditPart)) {
            p = p.getParent();
        }
        return p.getDragTracker(request);
    }
}

