/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.graphical.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.etsi.mts.tdl.AtomicBehaviour;
import org.etsi.mts.tdl.Behaviour;
import org.etsi.mts.tdl.Block;
import org.etsi.mts.tdl.CombinedBehaviour;
import org.etsi.mts.tdl.Connection;
import org.etsi.mts.tdl.ExceptionalBehaviour;
import org.etsi.mts.tdl.GateReference;
import org.etsi.mts.tdl.MultipleCombinedBehaviour;
import org.etsi.mts.tdl.PeriodicBehaviour;
import org.etsi.mts.tdl.SingleCombinedBehaviour;
import org.etsi.mts.tdl.TestDescription;

public class BehaviourProvider {
    private static final String EXTENSION_URI = "http://www.etsi.org/spec/TDL/1.2.1/viewer";
    private static final String END_CLASS = "End";
    private static final String END_BEGIN_FEATURE = "begin";

    public EObject owner(EObject e) {
        return e.eContainer();
    }

    public AtomicBehaviour getAtomicBehaviour(EObject e) {
        while (!(e instanceof AtomicBehaviour)) {
            e = e.eContainer();
        }
        if (e instanceof AtomicBehaviour) {
            return (AtomicBehaviour)e;
        }
        return null;
    }

    public List<EObject> getOccurrences(TestDescription td) {
        ArrayList<EObject> items = new ArrayList<EObject>();
        this.addBehavior(td.getBehaviourDescription().getBehaviour(), items);
        for (Connection c : td.getTestConfiguration().getConnection()) {
            for (GateReference ref : c.getEndPoint()) {
                if (items.contains(ref)) continue;
                items.add((EObject)ref);
            }
        }
        return items;
    }

    private void addBehavior(Behaviour behaviour, List<EObject> items) {
        int classifier = behaviour.eClass().getClassifierID();
        switch (classifier) {
            case 65: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: {
                items.add((EObject)behaviour);
                Object blocks = behaviour instanceof SingleCombinedBehaviour ? Collections.singletonList(((SingleCombinedBehaviour)behaviour).getBlock()) : ((MultipleCombinedBehaviour)behaviour).getBlock();
                this.addBlocks(items, (List<Block>)blocks);
                for (PeriodicBehaviour inner : ((CombinedBehaviour)behaviour).getPeriodic()) {
                    this.addBehavior((Behaviour)inner, items);
                }
                for (PeriodicBehaviour inner : ((CombinedBehaviour)behaviour).getExceptional()) {
                    this.addBehavior((Behaviour)inner, items);
                }
                items.add(this.getEnd((EObject)behaviour));
                break;
            }
            case 74: 
            case 75: {
                items.add((EObject)behaviour);
                List<Block> blocks = Collections.singletonList(((ExceptionalBehaviour)behaviour).getBlock());
                this.addBlocks(items, blocks);
                items.add(this.getEnd((EObject)behaviour));
                break;
            }
            case 63: {
                items.add((EObject)behaviour);
                List<Block> blocks = Collections.singletonList(((PeriodicBehaviour)behaviour).getBlock());
                this.addBlocks(items, blocks);
                items.add(this.getEnd((EObject)behaviour));
                break;
            }
            default: {
                items.add((EObject)behaviour);
                if (!(behaviour instanceof AtomicBehaviour)) break;
                items.add(this.getEnd((EObject)behaviour));
            }
        }
    }

    private void addBlocks(List<EObject> items, List<Block> blocks) {
        for (Block block : blocks) {
            items.add((EObject)block);
            for (Behaviour bBehaviour : block.getBehaviour()) {
                this.addBehavior(bBehaviour, items);
            }
            items.add(this.getEnd((EObject)block));
        }
    }

    public EObject getEnd(EObject e) {
        Resource extResource = this.getExtensionResource(e);
        EPackage extPackage = EPackageRegistryImpl.INSTANCE.getEPackage(EXTENSION_URI);
        EClass endClass = (EClass)extPackage.getEClassifier(END_CLASS);
        EStructuralFeature beginFeature = endClass.getEStructuralFeature(END_BEGIN_FEATURE);
        for (EObject o : extResource.getContents()) {
            if (!endClass.isInstance((Object)o) || !e.equals(o.eGet(beginFeature, true))) continue;
            return o;
        }
        return this.createEnd(e);
    }

    private EObject createEnd(EObject e) {
        Resource extResource = this.getExtensionResource(e);
        EPackage extPackage = BehaviourProvider.getExtensionPackage();
        EClass endClass = BehaviourProvider.getEndClass();
        EObject end = extPackage.getEFactoryInstance().create(endClass);
        end.eSet(endClass.getEStructuralFeature(END_BEGIN_FEATURE), (Object)e);
        extResource.getContents().add((Object)end);
        return end;
    }

    private static EPackage getExtensionPackage() {
        return EPackageRegistryImpl.INSTANCE.getEPackage(EXTENSION_URI);
    }

    private static EClass getEndClass() {
        return (EClass)BehaviourProvider.getExtensionPackage().getEClassifier(END_CLASS);
    }

    public static EObject getBegin(EObject end) {
        return (EObject)end.eGet(BehaviourProvider.getEndClass().getEStructuralFeature(END_BEGIN_FEATURE));
    }

    private Resource getExtensionResource(EObject e) {
        URI extUri;
        Resource mResource = e.eResource();
        ResourceSet rs = mResource.getResourceSet();
        Resource extResource = rs.getResource(extUri = mResource.getURI().appendFileExtension("viewerextension"), false);
        if (extResource == null) {
            extResource = rs.createResource(extUri);
        }
        return extResource;
    }

    public List<EObject> getBlocks(Behaviour b) {
        ArrayList<EObject> blocks = new ArrayList<EObject>();
        if (b instanceof SingleCombinedBehaviour) {
            blocks.add((EObject)((SingleCombinedBehaviour)b).getBlock());
        } else if (b instanceof MultipleCombinedBehaviour) {
            blocks.addAll((Collection<EObject>)((MultipleCombinedBehaviour)b).getBlock());
        } else if (b instanceof ExceptionalBehaviour) {
            blocks.add((EObject)((ExceptionalBehaviour)b).getBlock());
        } else if (b instanceof PeriodicBehaviour) {
            blocks.add((EObject)((PeriodicBehaviour)b).getBlock());
        }
        return blocks;
    }
}

