/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.openapi.generator.ui.handlers;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConfigLoader;
import org.openapitools.codegen.OpenAPIGenerator;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.utils.ModelUtils;

public class OpenAPIGeneratorLauncher {
    public static void main(String[] args) {
        OpenAPIGeneratorLauncher.listGenerators();
    }

    public static List<String> listGenerators() {
        ArrayList<CodegenConfig> generators = new ArrayList<CodegenConfig>();
        ArrayList<String> generatorNames = new ArrayList<String>();
        for (CodegenConfig codegenConfig : CodegenConfigLoader.getAll()) {
            GeneratorMetadata meta = codegenConfig.getGeneratorMetadata();
            if (meta == null) continue;
            generators.add(codegenConfig);
            generatorNames.add(codegenConfig.getName());
        }
        return generatorNames;
    }

    public static void launch(String input, String target) {
        OpenAPIGeneratorLauncher.launch(input, null, target, null, true);
    }

    public static void launch(File input, File config, String target) {
        OpenAPIGeneratorLauncher.launch(input.getAbsolutePath(), config.getAbsolutePath(), target, null, true);
    }

    public static void launch(String input, String config, String target, String output, boolean skipValidation) {
        if (output == null) {
            String inputFolder = new File(input).getParentFile().getAbsolutePath();
            output = String.valueOf(inputFolder) + "/generated/" + target + "/";
            new File(output).mkdirs();
        }
        input = input.replaceAll("\\\\", "/");
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("generate", "-g", target, "-i", input, "-o", output));
        if (config != null) {
            args.add("-c");
            args.add(config);
        }
        if (skipValidation) {
            args.add("--skip-validate-spec");
        }
        OpenAPIGenerator.main((String[])args.toArray(new String[args.size()]));
    }

    public static void validate(String input) {
        OpenAPIGenerator.main((String[])new String[]{"validate", "-i", input});
    }

    public static void parse(String input) {
        System.out.println("Parsing " + input);
        OpenAPI openAPI = new OpenAPIParser().readLocation(input, null, new ParseOptions()).getOpenAPI();
        Components components = openAPI.getComponents();
        Map schemas = components.getSchemas();
        ArraySchema object = (ArraySchema)((Schema)schemas.get("Library")).getProperties().get("books");
        System.out.println(object.getItems().get$ref());
        System.out.println("MU:" + ModelUtils.getReferencedSchema((OpenAPI)openAPI, (Schema)object.getItems()));
        schemas.forEach((k, v) -> System.out.println((String)k));
        ModelUtils.getOpenApiVersion((OpenAPI)openAPI, (String)input, null);
    }
}

