/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.openapi.generator.ui.handlers;

import java.util.Arrays;
import java.util.LinkedHashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.etsi.mts.tdl.openapi.generator.ui.handlers.OpenAPIGeneratorLauncher;

public class GeneratorHandler
extends AbstractHandler {
    LinkedHashMap<String, String> targetFormats = new LinkedHashMap();
    public static String translationTarget = "java";
    private IWorkbenchWindow window;

    public GeneratorHandler() {
        this.init();
    }

    private void init() {
        if (!this.targetFormats.isEmpty()) {
            return;
        }
        this.targetFormats.clear();
        for (String gen : OpenAPIGeneratorLauncher.listGenerators()) {
            this.targetFormats.put(gen, gen);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Object firstElement;
        this.init();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEditorInput input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        IFile file = null;
        if (input != null && input instanceof FileEditorInput && ((FileEditorInput)input).getFile().getName().endsWith("yaml")) {
            file = ((FileEditorInput)input).getFile();
        } else if (selection != null && selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            file = (IFile)firstElement;
        }
        if (file != null && file.getName().endsWith("yaml")) {
            String selectedTarget = null;
            IFile javaConfig = file.getProject().getFile("openapi-codegen-config-impl.json");
            if (javaConfig.exists()) {
                selectedTarget = "java";
            }
            if (selectedTarget == null) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new LabelProvider());
                dialog.setTitle("OpenAPI Generator Target Selection");
                dialog.setMessage("Generating assets from " + file.getName() + "\n\nSelect the target format");
                dialog.setElements(this.targetFormats.keySet().toArray());
                dialog.setInitialElementSelections(Arrays.asList(translationTarget));
                if (dialog.open() != 0) {
                    return false;
                }
                Object[] result = dialog.getResult();
                selectedTarget = (String)result[0];
            }
            if (selectedTarget != null) {
                translationTarget = selectedTarget;
                if (javaConfig.exists()) {
                    OpenAPIGeneratorLauncher.launch(file.getLocation().toFile(), javaConfig.getLocation().toFile(), selectedTarget);
                } else {
                    OpenAPIGeneratorLauncher.launch(file.getLocation().toFile().getAbsolutePath(), selectedTarget);
                }
            }
        }
        return null;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public boolean isEnabled() {
        return true;
    }
}

