/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.helper;

import com.google.inject.Injector;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.ocl.pivot.internal.delegate.OCLInvocationDelegateFactory;
import org.eclipse.ocl.pivot.internal.delegate.OCLSettingDelegateFactory;
import org.eclipse.ocl.pivot.internal.delegate.OCLValidationDelegateFactory;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLStandaloneSetup;
import org.eclipse.ocl.xtext.essentialocl.EssentialOCLStandaloneSetup;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.serializer.impl.Serializer;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.TDLan2StandaloneSetup;
import org.etsi.mts.tdl.TDLtxStandaloneSetup;
import org.etsi.mts.tdl.TDLtxiStandaloneSetup;
import org.etsi.mts.tdl.TPLan2StandaloneSetup;
import org.etsi.mts.tdl.impl.tdlPackageImpl;
import org.etsi.mts.tdl.structuredobjectives.impl.StructuredObjectivesPackageImpl;
import org.osgi.framework.Bundle;

public class TDLHelper {
    public static Injector injector;
    private static XtextResourceSet resourceSet;
    private static final String TDL_MODEL_NAME = "tdl";
    private static final String HTTP_MODEL_NAME = "http";
    private static final String JAVA_MODEL_NAME = "java";
    private static final String[] MODEL_FILE_EXTENSIONS;

    static {
        TDLHelper.init();
        MODEL_FILE_EXTENSIONS = new String[]{TDL_MODEL_NAME, "tdlan2", "tdltx", "tdltxi"};
    }

    public static void init() {
        Logger.getRootLogger().setLevel(Level.OFF);
        tdlPackageImpl.init();
        StructuredObjectivesPackageImpl.init();
        EssentialOCLStandaloneSetup.doSetup();
        CompleteOCLStandaloneSetup.doSetup();
        TDLHelper.initializeValidator();
        resourceSet = TDLHelper.getNewResourceSet();
    }

    public static Resource load(String filename) {
        Resource resource = resourceSet.getResource(URI.createURI((String)filename), true);
        return resource;
    }

    public static void link() {
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
    }

    public static void check() {
        resourceSet.getResources().forEach(TDLHelper::check);
    }

    public static void check(String filename) {
        Resource r = TDLHelper.load(filename);
        TDLHelper.check(r);
    }

    private static void check(Resource r) {
        r.getErrors().forEach(e -> System.out.println("Error: " + r.getURI().lastSegment() + ": " + e.getLine() + ": " + e.getMessage()));
        r.getWarnings().forEach(e -> System.out.println("Warning: " + r.getURI().lastSegment() + ": " + e.getLine() + ": " + e.getMessage()));
    }

    public static Resource create(String filename) throws Exception {
        Resource existing = resourceSet.getResource(URI.createFileURI((String)filename), false);
        if (existing != null) {
            existing.delete(Collections.emptyMap());
        }
        Resource resource = resourceSet.createResource(URI.createFileURI((String)filename));
        return resource;
    }

    public static void store(Resource resource, boolean derived) throws Exception {
        IFile file;
        if (derived && (file = TDLHelper.resourceToFile(resource)) != null) {
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
            }
            file.setDerived(derived, (IProgressMonitor)new NullProgressMonitor());
        }
        resource.save(Collections.emptyMap());
    }

    public static IFile resourceToFile(Resource resource) {
        URI uri = resource.getURI();
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
    }

    public static String getText(Resource resource) throws Exception {
        Serializer serializer = (Serializer)injector.getInstance(Serializer.class);
        return serializer.serialize((EObject)resource.getContents().get(0));
    }

    public static XtextResourceSet getNewResourceSet() {
        if (!Platform.isRunning()) {
            new StandaloneSetup().setPlatformUri("./");
            injector = new TDLan2StandaloneSetup().createInjectorAndDoEMFRegistration();
            injector = new TPLan2StandaloneSetup().createInjectorAndDoEMFRegistration();
            injector = new TDLtxiStandaloneSetup().createInjectorAndDoEMFRegistration();
            injector = new TDLtxStandaloneSetup().createInjectorAndDoEMFRegistration();
        } else {
            injector = (Injector)IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createFileURI((String)"t.tdltx")).get(Injector.class);
        }
        XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        return resourceSet;
    }

    public static Set<String> getTdlGrammarKeywords() {
        injector = new TDLtxStandaloneSetup().createInjectorAndDoEMFRegistration();
        IGrammarAccess grammarAccess = (IGrammarAccess)injector.getInstance(IGrammarAccess.class);
        if (grammarAccess != null) {
            return GrammarUtil.getAllKeywords((Grammar)grammarAccess.getGrammar());
        }
        return Collections.EMPTY_SET;
    }

    public static IProject getProjectForResource(Resource resource) {
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        URI resourceUri = resource.getURI();
        IFile modelFile = null;
        if (resourceUri.isPlatformResource()) {
            modelFile = ws.getFile((IPath)new Path(resourceUri.toPlatformString(true)));
        } else if (resourceUri.isFile()) {
            modelFile = ws.getFile((IPath)new Path(resourceUri.toFileString()));
        }
        if (modelFile != null) {
            return modelFile.getProject();
        }
        return null;
    }

    public static Package getTdlPackage(Resource resource) {
        return TDLHelper.getKnownPackage(resource, TDL_MODEL_NAME);
    }

    public static Package getHttpPackage(Resource resource) {
        return TDLHelper.getKnownPackage(resource, HTTP_MODEL_NAME);
    }

    public static Package getJavaPackage(Resource resource) {
        return TDLHelper.getKnownPackage(resource, JAVA_MODEL_NAME);
    }

    private static Package getKnownPackage(Resource resource, String packageName) {
        try {
            IProject prj = TDLHelper.getProjectForResource(resource);
            if (prj != null) {
                final HashSet<String> names = new HashSet<String>();
                String[] stringArray = MODEL_FILE_EXTENSIONS;
                int n = MODEL_FILE_EXTENSIONS.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    names.add(String.valueOf(packageName) + "." + ext);
                    ++n2;
                }
                FileFinder finder = new FileFinder(){

                    @Override
                    protected boolean mathces(IFile file) {
                        return names.contains(file.getName().toLowerCase());
                    }
                };
                prj.accept((IResourceVisitor)finder);
                if (finder.file != null) {
                    URI uri = URI.createPlatformResourceURI((String)finder.file.getFullPath().toString(), (boolean)true);
                    Resource tdlResource = resource.getResourceSet().getResource(uri, true);
                    return (Package)tdlResource.getContents().get(0);
                }
                if (Platform.isRunning()) {
                    Bundle bundle = Platform.getBundle((String)"org.etsi.mts.tdl.library");
                    ArrayList packages = new ArrayList();
                    bundle.findEntries("/", "*.tdltx", true).asIterator().forEachRemaining(e -> {
                        URI pURI = URI.createURI((String)e.toString());
                        if (names.contains(pURI.lastSegment().toLowerCase())) {
                            Resource tdlResource = resource.getResourceSet().getResource(pURI, true);
                            packages.add((Package)tdlResource.getContents().get(0));
                        }
                    });
                    return (Package)packages.get(0);
                }
            }
        }
        catch (CoreException e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
        return null;
    }

    public static void resetResourceSet() {
        resourceSet = TDLHelper.getNewResourceSet();
    }

    public static void initializeValidator() {
        String oclDelegateURI = "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot";
        EOperation.Internal.InvocationDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLInvocationDelegateFactory(oclDelegateURI));
        EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLSettingDelegateFactory(oclDelegateURI));
        EValidator.ValidationDelegate.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLValidationDelegateFactory(oclDelegateURI));
    }

    public static XtextResourceSet getResourceSet() {
        return resourceSet;
    }

    static abstract class FileFinder
    implements IResourceVisitor {
        public IFile file;

        FileFinder() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.file != null) {
                return false;
            }
            if (resource.getType() != 1) {
                return true;
            }
            if (this.mathces((IFile)resource)) {
                this.file = (IFile)resource;
            }
            return this.file == null;
        }

        protected abstract boolean mathces(IFile var1);
    }
}

