/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.graphical.sirius.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ZOrderRequest;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.DefaultLayoutProvider;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.etsi.mts.tdl.ComponentInstance;
import org.etsi.mts.tdl.Connection;
import org.etsi.mts.tdl.GateReference;
import org.etsi.mts.tdl.TestConfiguration;
import org.etsi.mts.tdl.graphical.sirius.layout.SequenceDiagramFreeformLayoutProvider;
import org.etsi.mts.tdl.graphical.sirius.layout.TdlAbstractLayoutEditPartProvider;
import org.etsi.mts.tdl.graphical.sirius.part.Util;

class SequenceFreeformLayoutEditPartProvider
extends TdlAbstractLayoutEditPartProvider {
    private static final int MARGIN = 20;
    private boolean defaultLayout = false;

    SequenceFreeformLayoutEditPartProvider() {
    }

    public boolean provides(IGraphicalEditPart container) {
        DDiagram d;
        DiagramDescription dDesc;
        Viewpoint vp;
        Option diagram;
        if (this.defaultLayout) {
            return false;
        }
        return container instanceof IDDiagramEditPart && (diagram = ((IDDiagramEditPart)container).resolveDDiagram()).some() && "org.etsi.mts.tdl".equals((vp = (Viewpoint)(dDesc = (d = (DDiagram)diagram.get()).getDescription()).eContainer()).getName()) && "TestDescriptionDiagram".equals(dDesc.getName());
    }

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        Command defaultCommand = null;
        if (!this.defaultLayout) {
            try {
                this.defaultLayout = true;
                EditPart editPart = (EditPart)selectedObjects.get(0);
                while (!(editPart instanceof IDDiagramEditPart)) {
                    editPart = editPart.getParent();
                }
                DefaultLayoutProvider defaultProvider = new DefaultLayoutProvider();
                defaultCommand = defaultProvider.layoutEditParts((GraphicalEditPart)((IGraphicalEditPart)editPart), layoutHint);
            }
            finally {
                this.defaultLayout = false;
            }
        }
        CompoundCommand cc = new CompoundCommand();
        if (defaultCommand != null) {
            cc.add(defaultCommand);
        }
        Hashtable attachmentLocations = new Hashtable();
        double scale = 0.0;
        for (Object object : selectedObjects) {
            EObject dElement;
            IGraphicalEditPart editPart = (IGraphicalEditPart)object;
            if (scale == 0.0) {
                scale = 1.0;
                if (editPart.getRoot() instanceof DiagramRootEditPart) {
                    ZoomManager zoomManager = ((DiagramRootEditPart)editPart.getRoot()).getZoomManager();
                    scale = zoomManager.getZoom();
                }
            }
            if (!((dElement = editPart.resolveSemanticElement()) instanceof DMappingBased)) continue;
            RepresentationElementMapping mapping = ((DMappingBased)dElement).getMapping();
            if (mapping.getName().equals("timeConstraint") || mapping.getName().equals("timeLabel")) {
                IGraphicalEditPart anchorEditPart = (IGraphicalEditPart)((ConnectionEditPart)editPart.getTargetConnections().get(0)).getSource();
                Rectangle bounds = editPart.getFigure().getBounds();
                Rectangle anchorBounds = anchorEditPart.getFigure().getBounds();
                Point location = new Point();
                location.x = anchorBounds.x + anchorBounds.width + 20;
                location.y = anchorBounds.y + Math.abs(anchorBounds.height - bounds.height) / 2;
                Iterator newBounds = bounds.getCopy();
                ((Rectangle)newBounds).x = location.x;
                ((Rectangle)newBounds).y = location.y;
                ArrayList<Iterator> existingLocations = (ArrayList<Iterator>)attachmentLocations.get(anchorEditPart);
                if (existingLocations == null) {
                    existingLocations = new ArrayList<Iterator>();
                    attachmentLocations.put(anchorEditPart, existingLocations);
                }
                for (Rectangle rectangle : existingLocations) {
                    if (!rectangle.intersects((Rectangle)newBounds)) continue;
                    location.x = ((Rectangle)newBounds).x = rectangle.x + rectangle.width + 20;
                }
                existingLocations.add(newBounds);
                Point point = location.translate(-bounds.x, -bounds.y);
                point.x = (int)((double)point.x * scale);
                point.y = (int)((double)point.y * scale);
                ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
                request.setMoveDelta(point);
                Command c = editPart.getCommand((Request)request);
                cc.add(c);
                continue;
            }
            if (mapping.getName().equals("componentInstance")) {
                ComponentInstance ci = (ComponentInstance)((DSemanticDecorator)dElement).getTarget();
                TestConfiguration conf = (TestConfiguration)ci.eContainer();
                ArrayList<GateReference> gates = new ArrayList<GateReference>();
                for (Connection c : conf.getConnection()) {
                    for (GateReference ep : c.getEndPoint()) {
                        if (ep.getComponent() != ci) continue;
                        gates.add(ep);
                    }
                }
                Map registry = editPart.getViewer().getEditPartRegistry();
                ArrayList<IGraphicalEditPart> gParts = new ArrayList<IGraphicalEditPart>();
                for (GateReference g : gates) {
                    gParts.addAll(this.findEditParts(registry, (EObject)g, "gateReference"));
                }
                Point location = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
                Point point = new Point(0, 0);
                for (IGraphicalEditPart p : gParts) {
                    Rectangle bounds = p.getFigure().getBounds();
                    Point curLocation = new Point();
                    curLocation.x = bounds.x - 10;
                    curLocation.y = bounds.y - 40;
                    location.x = Math.min(location.x, curLocation.x);
                    location.y = Math.min(location.y, curLocation.y);
                    point.x = Math.max(point.x, bounds.x + bounds.width + 10);
                    point.y = bounds.height + 20;
                }
                Dimension size = new Dimension(point.x - location.x, point.y - location.y);
                Rectangle bounds = editPart.getFigure().getBounds();
                Dimension resizeDelta = size.getExpanded(-bounds.width, -bounds.height);
                Point moveDelta = location.translate(-bounds.x, -bounds.y);
                Point NO_MOVE = new Point();
                Dimension NO_RES = new Dimension();
                if (!NO_MOVE.equals((Object)moveDelta) || !NO_RES.equals((Object)resizeDelta)) {
                    this.addSetBoundsCommand(resizeDelta, moveDelta, scale, (EditPart)editPart, cc);
                }
                ZOrderRequest sendToBackRequest = new ZOrderRequest("sendToBackAction");
                sendToBackRequest.setPartsToOrder(Collections.singletonList(editPart));
                cc.add(editPart.getCommand((Request)sendToBackRequest));
                continue;
            }
            if (!SequenceDiagramFreeformLayoutProvider.isCustomizedInteractionUse((EditPart)editPart)) continue;
            IFigure f = editPart.getFigure();
            Dimension size = f.getPreferredSize().getCopy();
            Rectangle bounds = f.getBounds();
            Dimension resizeDelta = size.getExpanded(-bounds.width, -bounds.height);
            resizeDelta.width = 0;
            resizeDelta.height = Math.max(resizeDelta.height, 0);
            resizeDelta.width = (int)((double)resizeDelta.width * scale);
            resizeDelta.height = (int)((double)resizeDelta.height * scale);
            ChangeBoundsRequest resRequest = new ChangeBoundsRequest((Object)"resize");
            resRequest.setSizeDelta(resizeDelta);
            resRequest.setResizeDirection(4);
            resRequest.setEditParts((EditPart)editPart);
            Command cmd = editPart.getCommand((Request)resRequest);
            if (cmd instanceof CompoundCommand) {
                ListIterator listIterator = ((CompoundCommand)cmd).getCommands().listIterator();
                while (listIterator.hasNext()) {
                    if (((Command)listIterator.next()).canExecute()) continue;
                    listIterator.remove();
                }
            }
            cc.add(cmd);
            editPart.getFigure().invalidateTree();
        }
        return cc;
    }

    private List<IGraphicalEditPart> findEditParts(Map registry, EObject target, String mappingId) {
        ArrayList<IGraphicalEditPart> gParts = new ArrayList<IGraphicalEditPart>();
        for (Object d : registry.keySet()) {
            IGraphicalEditPart part;
            if (!(d instanceof DSemanticDecorator) || ((DSemanticDecorator)d).getTarget() != target || !mappingId.equals(Util.getMappingId(part = (IGraphicalEditPart)registry.get(d)))) continue;
            gParts.add(part);
        }
        return gParts;
    }
}

