/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.graphical.sirius.actions;

import com.google.inject.Injector;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.etsi.mts.tdl.Assertion;
import org.etsi.mts.tdl.Assignment;
import org.etsi.mts.tdl.Block;
import org.etsi.mts.tdl.BoundedLoopBehaviour;
import org.etsi.mts.tdl.DataUse;
import org.etsi.mts.tdl.LocalExpression;
import org.etsi.mts.tdl.MemberAssignment;
import org.etsi.mts.tdl.Message;
import org.etsi.mts.tdl.PeriodicBehaviour;
import org.etsi.mts.tdl.StaticDataUse;
import org.etsi.mts.tdl.TimeConstraint;
import org.etsi.mts.tdl.TimeOperation;
import org.etsi.mts.tdl.TimerStart;
import org.etsi.mts.tdl.graphical.labels.DataStandaloneSetup;
import org.etsi.mts.tdl.graphical.labels.parser.RuleBasedDataParser;
import org.etsi.mts.tdl.tdlFactory;

public class ParseAction
implements IExternalJavaAction {
    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        EObject element = (EObject)parameters.get("element");
        String newValue = (String)parameters.get("newValue");
        try {
            DataUse value = (DataUse)this.parse(element.eResource().getURI(), newValue, "DataUse");
            if (value != null) {
                EClass type = element.eClass();
                EList localExpressions = null;
                switch (type.getClassifierID()) {
                    case 21: {
                        ((MemberAssignment)element).setMemberSpec((DataUse)((StaticDataUse)value));
                        break;
                    }
                    case 88: {
                        ((Message)element).setArgument(value);
                        break;
                    }
                    case 61: {
                        localExpressions = ((Block)element).getGuard();
                    }
                    case 68: {
                        if (element instanceof BoundedLoopBehaviour) {
                            localExpressions = ((BoundedLoopBehaviour)element).getNumIteration();
                        }
                    }
                    case 63: {
                        LocalExpression localExp;
                        if (element instanceof PeriodicBehaviour) {
                            localExpressions = ((PeriodicBehaviour)element).getPeriod();
                        }
                        if (localExpressions.isEmpty()) {
                            localExp = tdlFactory.eINSTANCE.createLocalExpression();
                            localExpressions.add(localExp);
                        } else {
                            localExp = (LocalExpression)localExpressions.get(0);
                        }
                        localExp.setExpression(value);
                        break;
                    }
                    case 53: 
                    case 54: {
                        ((TimeOperation)element).setPeriod(value);
                        break;
                    }
                    case 49: {
                        ((TimerStart)element).setPeriod(value);
                        break;
                    }
                    case 48: {
                        ((TimeConstraint)element).setTimeConstraintExpression(value);
                        break;
                    }
                    case 81: {
                        ((Assignment)element).setExpression(value);
                        break;
                    }
                    case 78: {
                        ((Assertion)element).setCondition(value);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.etsi.mts.tdl.graphical.viewpoint", e.getMessage()));
        }
    }

    public boolean canExecute(Collection<? extends EObject> selections) {
        return true;
    }

    private EObject parse(URI uri, String text, String rule) throws IOException {
        Injector xtextInjector = new DataStandaloneSetup().createInjectorAndDoEMFRegistration();
        IResourceFactory resourceFactory = (IResourceFactory)xtextInjector.getInstance(IResourceFactory.class);
        XtextResourceSet rs = (XtextResourceSet)xtextInjector.getInstance(XtextResourceSet.class);
        rs.setClasspathURIContext(this.getClass());
        XtextResource xr = (XtextResource)resourceFactory.createResource(URI.createURI((String)uri.toString()));
        rs.getResources().add((Object)xr);
        RuleBasedDataParser parser = (RuleBasedDataParser)xr.getParser();
        parser.setDefaultRuleName(rule);
        xr.reparse(text);
        EList contents = xr.getContents();
        if (contents.isEmpty()) {
            IParseResult result = xr.getParseResult();
            StringBuilder errorMessage = new StringBuilder();
            for (INode err : result.getSyntaxErrors()) {
                errorMessage.append(err.getSyntaxErrorMessage().getMessage());
                errorMessage.append(System.getProperty("line.separator"));
            }
            StatusManager.getManager().handle((IStatus)new Status(4, "org.etsi.mts.tdl.graphical.viewpoint", errorMessage.toString()), 2);
            return null;
        }
        EObject element = (EObject)contents.get(0);
        EcoreUtil.resolveAll((Resource)xr);
        EObject resolved = (EObject)contents.get(0);
        if (!resolved.eClass().isInstance((Object)element)) {
            EcoreUtil.resolveAll((Resource)xr);
        }
        return resolved;
    }
}

