/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.graphical.extensions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.etsi.mts.tdl.Action;
import org.etsi.mts.tdl.AnnotationType;
import org.etsi.mts.tdl.Behaviour;
import org.etsi.mts.tdl.BehaviourDescription;
import org.etsi.mts.tdl.ComponentInstance;
import org.etsi.mts.tdl.ComponentType;
import org.etsi.mts.tdl.DataInstance;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.ElementImport;
import org.etsi.mts.tdl.Function;
import org.etsi.mts.tdl.GateType;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.SimpleDataInstance;
import org.etsi.mts.tdl.SimpleDataType;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.Target;
import org.etsi.mts.tdl.TestConfiguration;
import org.etsi.mts.tdl.TestDescription;
import org.etsi.mts.tdl.Timer;
import org.etsi.mts.tdl.Variable;
import org.etsi.mts.tdl.tdlPackage;

public class ModelHelper {
    public String className(EObject element) {
        return element.eClass().getName();
    }

    public EObject owner(EObject element) {
        return element.eContainer();
    }

    public TestDescription getTestDescription(EObject behaviourContent) {
        EObject c = behaviourContent;
        while (c != null) {
            if (c instanceof TestDescription) {
                return (TestDescription)c;
            }
            c = c.eContainer();
        }
        return null;
    }

    public ComponentInstance getContainingTestComponent(DDiagramElement configurationDiagramElement) {
        while (configurationDiagramElement != null) {
            EObject t = configurationDiagramElement.getTarget();
            if (t instanceof ComponentInstance) {
                return (ComponentInstance)t;
            }
            if (!(configurationDiagramElement.eContainer() instanceof DDiagramElement)) {
                return null;
            }
            configurationDiagramElement = (DDiagramElement)configurationDiagramElement.eContainer();
        }
        return null;
    }

    public TestConfiguration getTestConfiguration(EObject behaviourContent) {
        TestDescription td = this.getTestDescription(behaviourContent);
        return td != null ? td.getTestConfiguration() : null;
    }

    public List<TestDescription> getTestDescriptions(EObject context) {
        List<? extends Element> tdList = this.getOf(context, (EClassifier)tdlPackage.eINSTANCE.getTestDescription());
        TestDescription td = this.getTestDescription(context);
        tdList.remove(td);
        return tdList;
    }

    public List<Function> getFunctions(EObject context) {
        return this.getOf(context, (EClassifier)tdlPackage.eINSTANCE.getFunction());
    }

    public List<Action> getActions(EObject context) {
        return this.getOf(context, (EClassifier)tdlPackage.eINSTANCE.getAction());
    }

    public List<SimpleDataType> getSimpleDataTypes(EObject context) {
        return this.getOf(context, (EClassifier)tdlPackage.eINSTANCE.getSimpleDataType());
    }

    public List<StructuredDataType> getStructuredDataTypes(EObject context) {
        return this.getOf(context, (EClassifier)tdlPackage.eINSTANCE.getStructuredDataType());
    }

    public List<DataType> getDataTypes(EObject context) {
        return this.getOf(context, (EClassifier)tdlPackage.eINSTANCE.getDataType());
    }

    public List<DataInstance> getDataInstances(EObject context) {
        return this.getOf(context, (EClassifier)tdlPackage.eINSTANCE.getDataInstance());
    }

    public List<TestConfiguration> getTestConfigurations(EObject context) {
        return this.getOf(context, (EClassifier)tdlPackage.eINSTANCE.getTestConfiguration());
    }

    public List<ComponentType> getComponentTypes(EObject context) {
        return this.getOf(context, (EClassifier)tdlPackage.eINSTANCE.getComponentType());
    }

    public List<AnnotationType> getAnnotationTypes(EObject context) {
        return this.getOf(context, (EClassifier)tdlPackage.eINSTANCE.getAnnotationType());
    }

    public List<GateType> getGateTypes(EObject context) {
        return this.getOf(context, (EClassifier)tdlPackage.eINSTANCE.getGateType());
    }

    public List<Variable> getVariables(EObject context) {
        LinkedList<Variable> vars = new LinkedList<Variable>();
        TestDescription td = this.getTestDescription(context);
        for (ComponentInstance c : td.getTestConfiguration().getComponentInstance()) {
            vars.addAll((Collection<Variable>)c.getType().getVariable());
        }
        return vars;
    }

    public List<Timer> getTimers(EObject context) {
        LinkedList<Timer> timers = new LinkedList<Timer>();
        TestDescription td = this.getTestDescription(context);
        for (ComponentInstance c : td.getTestConfiguration().getComponentInstance()) {
            timers.addAll((Collection<Timer>)c.getType().getTimer());
        }
        return timers;
    }

    private List<? extends Element> getOf(EObject context, EClassifier eClass) {
        LinkedList<Element> list = new LinkedList<Element>();
        for (Element e : this.visibleElements(context)) {
            if (!eClass.isInstance((Object)e)) continue;
            list.add(e);
        }
        return list;
    }

    public List<SimpleDataInstance> getVerdicts(EObject context) {
        LinkedList<SimpleDataInstance> verdicts = new LinkedList<SimpleDataInstance>();
        for (Element e : this.visibleElements(context)) {
            DataType type;
            if (!(e instanceof SimpleDataInstance) || !(type = ((SimpleDataInstance)e).getDataType()).getName().equalsIgnoreCase("Verdict")) continue;
            verdicts.add((SimpleDataInstance)e);
        }
        return verdicts;
    }

    private List<Element> visibleElements(EObject context) {
        LinkedList<Element> elements = new LinkedList<Element>();
        while (!(context instanceof Package)) {
            context = context.eContainer();
        }
        Package p = (Package)context;
        elements.addAll((Collection<Element>)p.getPackagedElement());
        for (ElementImport imp : p.getImport()) {
            if (imp.getImportedElement().isEmpty()) {
                elements.addAll((Collection<Element>)imp.getImportedPackage().getPackagedElement());
                continue;
            }
            elements.addAll((Collection<Element>)imp.getImportedElement());
        }
        return elements;
    }

    public List<EObject> allBehaviours(TestDescription e) {
        LinkedList<EObject> behaviours = new LinkedList<EObject>();
        TreeIterator iter = e.eAllContents();
        while (iter.hasNext()) {
            EObject c = (EObject)iter.next();
            if (c.eContainer() instanceof BehaviourDescription) continue;
            if (c instanceof Behaviour) {
                behaviours.add(c);
                continue;
            }
            if (!(c instanceof Target)) continue;
            behaviours.add(c);
        }
        return behaviours;
    }
}

