/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.execution.java.codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.etsi.mts.tdl.DataElementMapping;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.MappableDataElement;
import org.etsi.mts.tdl.Package;

public abstract class Renderer {
    private static final String LF = System.getProperty("line.separator");
    private File generationDir;
    private String rootPackageName;
    protected Map<Element, String> elementNames = new Hashtable<Element, String>();
    private CharBuffer buf;
    private String indent = "";

    public Renderer(File generationDir, String packageName) {
        this.generationDir = generationDir;
        this.rootPackageName = packageName;
    }

    protected String getRootPackageName() {
        return this.rootPackageName;
    }

    protected void setRootPackageName(String rootPackageName) {
        this.rootPackageName = rootPackageName;
    }

    final void writeClassFile(String packageName, String className, ContentRenderer r) throws IOException {
        ByteBuffer bytes;
        File packageDir = this.generationDir;
        Object object = packageName.split("\\.");
        int n = ((String[])object).length;
        int n2 = 0;
        while (n2 < n) {
            String p = object[n2];
            packageDir = new File(packageDir, p);
            ++n2;
        }
        packageDir.mkdirs();
        File classFile = new File(packageDir, String.valueOf(className) + ".java");
        this.buf = CharBuffer.allocate(0x100000);
        r.doRender();
        this.buf.flip();
        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        try {
            bytes = encoder.encode(this.buf);
            encoder.flush(bytes);
            bytes.rewind();
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        classFile.createNewFile();
        object = null;
        Object var9_13 = null;
        try (FileChannel out = new FileOutputStream(classFile).getChannel();){
            out.write(bytes);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    protected void writeImports(Set<String> imports) {
        for (String i : imports) {
            this.line("import " + i + ";");
        }
        this.newLine();
    }

    protected String getPackageName(Package p) {
        if (p.getName().startsWith("java.")) {
            return p.getName();
        }
        return this.getElementName((Element)p);
    }

    protected String getElementName(Element e) {
        DataElementMapping mapping;
        if (e instanceof MappableDataElement && (mapping = this.getMapping((MappableDataElement)e)) != null) {
            return mapping.getElementURI();
        }
        String name = this.elementNames.get(e);
        if (name != null) {
            return name;
        }
        name = e.getName();
        if (name == null) {
            name = e.eClass().getName();
        }
        String identifier = this.getIdentifier(name);
        int i = 1;
        name = identifier;
        while (this.elementNames.containsValue(name)) {
            name = String.valueOf(identifier) + "_" + i++;
        }
        this.elementNames.put(e, name);
        return name;
    }

    protected abstract DataElementMapping getMapping(MappableDataElement var1);

    protected void append(String text) {
        this.buf.append(text);
    }

    protected void blockOpen() {
        this.append(" {");
        this.indent = String.valueOf(this.indent) + "\t";
        this.newLine();
    }

    protected void blockClose() {
        this.indent = this.indent.substring(1);
        this.buf.position(this.buf.position() - 1);
        this.line("}");
    }

    protected void blockCloseArrow() {
        this.indent = this.indent.substring(1);
        this.buf.position(this.buf.position() - 1);
        this.line("});");
    }

    protected void blockCloseMethod() {
        this.indent = this.indent.substring(1);
        this.buf.position(this.buf.position() - 1);
        this.line("};");
    }

    protected void blockOpenParen() {
        this.append(" (");
        this.indent = String.valueOf(this.indent) + "\t";
        this.newLine();
    }

    protected void blockCloseParen() {
        this.indent = this.indent.substring(1);
        this.buf.position(this.buf.position() - 1);
        this.line(")");
    }

    protected void callOpen() {
        this.append("(");
        this.indent = String.valueOf(this.indent) + "\t\t";
        this.newLine();
    }

    protected void callClose() {
        this.indent = this.indent.substring(2);
        this.line(");");
    }

    protected void newLine() {
        this.append(LF);
        this.append(this.indent);
    }

    protected void line(String text) {
        this.append(text);
        this.newLine();
    }

    protected void lineInc(String text) {
        this.append("\t");
        this.append(text);
        this.newLine();
    }

    protected void lineComment(String text) {
        this.line("// " + text);
    }

    private String getIdentifier(String name) {
        if (name == null) {
            return null;
        }
        if (SourceVersion.isKeyword(name)) {
            name = String.valueOf(name) + "_";
        }
        char[] chars = name.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (i == 0) {
                if (!Character.isJavaIdentifierStart(chars[i])) {
                    chars[i] = 95;
                }
            } else if (!Character.isJavaIdentifierPart(chars[i])) {
                chars[i] = 95;
            }
            ++i;
        }
        return String.valueOf(chars);
    }

    @FunctionalInterface
    static interface ContentRenderer {
        public void doRender();
    }
}

