/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TdlNature
implements IProjectNature {
    public static final String NATURE_ID = "org.etsi.mts.tdl.nature";

    public static void setTdlProjectNature(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        String[] ids = desc.getNatureIds();
        String[] newIds = new String[ids.length + 1];
        System.arraycopy(ids, 0, newIds, 1, ids.length);
        newIds[0] = NATURE_ID;
        desc.setNatureIds(newIds);
        project.setDescription(desc, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTdl(IProject prj) throws CoreException {
        if (!prj.exists()) return false;
        if (!prj.isOpen()) {
            return false;
        }
        try {
            String[] stringArray = prj.getDescription().getNatureIds();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String nature = stringArray[n2];
                if (NATURE_ID.equals(nature)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) throw new CoreException((IStatus)Status.warning((String)("Failed to detect natures of project " + prj), (Throwable)e));
            if (msg.endsWith("does not exist.")) throw new CoreException((IStatus)Status.warning((String)msg, (Throwable)e));
            throw new CoreException((IStatus)Status.warning((String)("Failed to detect natures of project " + prj), (Throwable)e));
        }
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return null;
    }

    public void setProject(IProject project) {
    }
}

