/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.project;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    public static final String PREFERENCE_SCOPE = "org.etsi.mts.tdl.project";
    private static final List<String> REQUIRED_SETTINGS = Arrays.asList(new String[0]);
    protected IAdaptable element;
    protected Map<FieldEditor, String> fields = new Hashtable<FieldEditor, String>();

    public PropertyPage() {
        super(1);
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        ProjectScope ps = new ProjectScope((IProject)this.element);
        return new ScopedPreferenceStore((IScopeContext)ps, PREFERENCE_SCOPE);
    }

    protected void initialize() {
        for (FieldEditor e : this.fields.keySet()) {
            String value = this.getPreferenceStore().getString(e.getPreferenceName());
            this.fields.put(e, value);
            this.initialize(e.getPreferenceName(), value, e);
        }
        super.initialize();
    }

    protected void initialize(String name, String value, FieldEditor e) {
    }

    protected void addField(FieldEditor editor) {
        super.addField(editor);
        this.fields.put(editor, "");
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value")) {
            FieldEditor e = (FieldEditor)event.getSource();
            String name = e.getPreferenceName();
            String value = (String)event.getNewValue();
            this.fields.put(e, value);
            this.initialize(name, value, e);
            this.checkState();
        }
    }

    protected void checkState() {
        this.setErrorMessage(null);
        super.checkState();
    }

    protected void createFieldEditors() {
    }

    private boolean isValid(FieldEditor e) {
        String name = e.getPreferenceName();
        String value = this.fields.get(e);
        if (REQUIRED_SETTINGS.contains(name) && value.isEmpty()) {
            this.setErrorMessage(String.format("%s must be selected!", e.getLabelText()));
            return false;
        }
        return true;
    }
}

