/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.tools.rt.ui.handlers;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.etsi.mts.tdl.Annotation;
import org.etsi.mts.tdl.AnnotationType;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.structuredobjectives.ExpectedBehaviour;
import org.etsi.mts.tdl.structuredobjectives.FinalConditions;
import org.etsi.mts.tdl.structuredobjectives.InitialConditions;
import org.etsi.mts.tdl.tdlFactory;

public class TranslationHandler
extends AbstractHandler {
    LinkedHashMap<String, String> targetFormats = new LinkedHashMap();
    public static String translationTarget = "TDL XF (Part 3, XMI)";
    private IWorkbenchWindow window;

    public TranslationHandler() {
        this.init();
    }

    private void init() {
        this.targetFormats.isEmpty();
        this.targetFormats.clear();
        this.targetFormats.put("TDL XF (Part 3, XMI)", "tdl");
        this.loadTargetFormat("org.etsi.mts.tdl.tx", "TDL TX (Part 8, Braces)", "tdltx");
        this.loadTargetFormat("org.etsi.mts.tdl.txi", "TDL TX (Part 8, Indentation)", "tdltxi");
        this.loadTargetFormat("org.etsi.mts.tdl.TDLan2", "TDLan2 (Part 1, Annex B)", "tdlan2");
        this.loadTargetFormat("org.etsi.mts.tdl.TPLan2", "TPLan2 (Part 4, Annex B)", "tplan2");
    }

    private void loadTargetFormat(String bundleName, String label, String extension) {
        if (Platform.getBundle((String)bundleName) != null) {
            this.targetFormats.put(label, extension);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Object firstElement;
        this.init();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEditorInput input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        IFile file = null;
        if (input != null && input instanceof FileEditorInput) {
            file = ((FileEditorInput)input).getFile();
        } else if (selection != null && selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            file = (IFile)firstElement;
        }
        if (file != null) {
            String selected;
            XtextResourceSet resourceSet;
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Injector injector = Guice.createInjector((Module[])new Module[0]);
            XtextResourceSet rs = resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
            Resource r = rs.getResource(uri, true);
            EcoreUtil.resolveAll((Resource)r);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new LabelProvider());
            dialog.setTitle("Translation Configuration");
            dialog.setMessage("Translating " + file.getName() + "\n\nSelect the target format");
            dialog.setElements(this.targetFormats.keySet().toArray());
            dialog.setInitialElementSelections(Arrays.asList(translationTarget));
            if (dialog.open() != 0) {
                return false;
            }
            Object[] result = dialog.getResult();
            translationTarget = selected = (String)result[0];
            String extension = this.targetFormats.get(selected);
            URI targetURI = URI.createURI((String)(String.valueOf(uri.toString()) + "." + extension));
            Resource tr = resourceSet.createResource(targetURI);
            tr.getContents().addAll(EcoreUtil.copyAll((Collection)r.getContents()));
            if (file.getName().endsWith("tplan2") && extension.startsWith("tdltx")) {
                List elements = EcoreUtil2.eAllOfType((EObject)((EObject)tr.getContents().get(0)), NamedElement.class);
                for (NamedElement e : elements) {
                    e.setName(e.getName().replaceAll("\"", "").replaceAll("\\s", "_").replaceAll("[,\\.-]", "_").replaceAll("^(\\d)", "_$1"));
                }
                this.processElements("Initial conditions", tr, InitialConditions.class);
                this.processElements("Expected behaviour", tr, ExpectedBehaviour.class);
                this.processElements("Final conditions", tr, FinalConditions.class);
            }
            try {
                EcoreUtil.resolveAll((Resource)tr);
                tr.save(null);
            }
            catch (Exception e1) {
                System.err.println("  Translation: " + e1.getMessage());
                e1.printStackTrace();
            }
        }
        return null;
    }

    private <T extends Element> void processElements(String annotationType, Resource tr, Class<T> type) {
        AnnotationType at = this.getAnnotationType(tr, annotationType);
        List elements = EcoreUtil2.eAllOfType((EObject)((EObject)tr.getContents().get(0)), type);
        for (Element e : elements) {
            Annotation a = tdlFactory.eINSTANCE.createAnnotation();
            a.setKey(at);
            e.getAnnotation().add((Object)a);
            e.setName(null);
        }
    }

    private AnnotationType getAnnotationType(Resource tr, String annotationType) {
        Optional<AnnotationType> optional = EcoreUtil2.eAllOfType((EObject)((EObject)tr.getContents().get(0)), AnnotationType.class).stream().filter(at -> at.getName().equals(annotationType)).findFirst();
        AnnotationType aType = optional.isEmpty() ? this.createAnnotationType(tr, annotationType) : optional.get();
        return aType;
    }

    private AnnotationType createAnnotationType(Resource tr, String annotationType) {
        AnnotationType at = tdlFactory.eINSTANCE.createAnnotationType();
        at.setName(annotationType);
        ((Package)tr.getContents().get(0)).getPackagedElement().add(0, (Object)at);
        return at;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public boolean isEnabled() {
        return true;
    }
}

