/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.openapi2tdl.next;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    public static final String PROCEDURE_BASED = "ProcedureBased";
    public static final String GENERATE_JAVA_MAPPING = "GenerateJavaMapping";
    public static final String JAVA_GENERATOR = "JavaMappingGenerator";
    public static final String JAVA_API_PACKAGE = "JavaApiPackage";
    public static final String PREFERENCE_SCOPE = "org.etsi.mts.tdl.openapi2tdl";
    private static final List<String> REQUIRED_SETTINGS = Arrays.asList(new String[0]);
    protected IAdaptable element;
    protected Map<FieldEditor, String> fields = new Hashtable<FieldEditor, String>();
    private StringFieldEditor javaApiPackage;

    public PropertyPage() {
        super(1);
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        ProjectScope ps = new ProjectScope((IProject)this.element);
        ScopedPreferenceStore scopedStore = new ScopedPreferenceStore((IScopeContext)ps, PREFERENCE_SCOPE);
        scopedStore.setDefault(JAVA_GENERATOR, "java");
        return scopedStore;
    }

    protected void initialize() {
        for (FieldEditor e : this.fields.keySet()) {
            String value = this.getPreferenceStore().getString(e.getPreferenceName());
            this.fields.put(e, value);
            this.initialize(e.getPreferenceName(), value, e);
        }
        super.initialize();
    }

    protected void initialize(String name, String value, FieldEditor e) {
        if (name.equals(GENERATE_JAVA_MAPPING)) {
            this.javaApiPackage.setEnabled(Boolean.valueOf(value).booleanValue(), this.getFieldEditorParent());
        }
    }

    protected void addField(FieldEditor editor) {
        super.addField(editor);
        this.fields.put(editor, "");
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value")) {
            FieldEditor e = (FieldEditor)event.getSource();
            String name = e.getPreferenceName();
            Object valueObj = event.getNewValue();
            String value = valueObj.toString();
            this.fields.put(e, value);
            this.initialize(name, value, e);
            this.checkState();
        }
    }

    protected void checkState() {
        this.setErrorMessage(null);
        super.checkState();
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        BooleanFieldEditor procBased = new BooleanFieldEditor(PROCEDURE_BASED, "Procedure-based API", parent);
        this.addField((FieldEditor)procBased);
        parent = this.getFieldEditorParent();
        BooleanFieldEditor genJavaMappings = new BooleanFieldEditor(GENERATE_JAVA_MAPPING, "Generate type mappings for Java", parent);
        this.addField((FieldEditor)genJavaMappings);
        parent = this.getFieldEditorParent();
        StringFieldEditor javaGenerator = new StringFieldEditor(JAVA_GENERATOR, "Code generator for mappings", parent);
        javaGenerator.setEnabled(false, parent);
        this.addField((FieldEditor)javaGenerator);
        parent = this.getFieldEditorParent();
        this.javaApiPackage = new StringFieldEditor(JAVA_API_PACKAGE, "Java API package", parent);
        this.addField((FieldEditor)this.javaApiPackage);
    }

    private boolean isValid(FieldEditor e) {
        String name = e.getPreferenceName();
        String value = this.fields.get(e);
        if (REQUIRED_SETTINGS.contains(name) && value.isEmpty()) {
            this.setErrorMessage(String.format("%s must be selected!", e.getLabelText()));
            return false;
        }
        return true;
    }
}

