/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.openapi2tdl.next;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.util.InlineModelResolver;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.ecore.resource.Resource;
import org.etsi.mts.tdl.Annotation;
import org.etsi.mts.tdl.AnnotationType;
import org.etsi.mts.tdl.CollectionDataType;
import org.etsi.mts.tdl.DataElementMapping;
import org.etsi.mts.tdl.DataElementUse;
import org.etsi.mts.tdl.DataInstance;
import org.etsi.mts.tdl.DataResourceMapping;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.DataUse;
import org.etsi.mts.tdl.ElementImport;
import org.etsi.mts.tdl.EnumDataType;
import org.etsi.mts.tdl.LiteralValueUse;
import org.etsi.mts.tdl.MappableDataElement;
import org.etsi.mts.tdl.Member;
import org.etsi.mts.tdl.MemberAssignment;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.PackageableElement;
import org.etsi.mts.tdl.Parameter;
import org.etsi.mts.tdl.ParameterBinding;
import org.etsi.mts.tdl.ParameterMapping;
import org.etsi.mts.tdl.SimpleDataInstance;
import org.etsi.mts.tdl.StructuredDataInstance;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.helper.TDLHelper;
import org.etsi.mts.tdl.tdlFactory;
import org.etsi.mts.tdl.tdlPackage;
import org.etsi.mts.tdl.transform.AbstractTranslator;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.config.CodegenConfigurator;
import org.openapitools.codegen.languages.JavaClientCodegen;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.utils.ModelUtils;

public class OpenAPI2TDLTranslatorNext
extends AbstractTranslator {
    private OpenAPI model;
    private boolean isXtext = false;
    private Set<String> xtextKyewords;
    private Package theTdlPackage;

    public void translate(String filename) throws Exception {
        this.translate(filename, this.sourceMappingTag, this.targetMappingTag);
    }

    public void translate(String filename, String sourceMappingTag, String targetMappingTag) throws Exception {
        this.translate(filename, sourceMappingTag, targetMappingTag, false);
    }

    public void translate(String filename, String sourceMappingTag, String targetMappingTag, boolean inline) throws Exception {
        Schema schema;
        sourceMappingTag = "OpenAPISpecification";
        targetMappingTag = "JavaTypesPackage";
        this.model = OpenAPI2TDLTranslatorNext.parseSpec(filename, inline);
        if (this.model.getInfo().getTitle() != null) {
            this.getGeneratedPackage().setName(this.getCleanName(this.model.getInfo().getTitle()));
        }
        this.drm = (DataResourceMapping)this.getTypeFor(sourceMappingTag, tdlPackage.Literals.DATA_RESOURCE_MAPPING);
        this.drm.setResourceURI(new File(filename).getName());
        this.theTdlPackage = TDLHelper.getTdlPackage((Resource)this.getTargetResource());
        if (this.theTdlPackage != null) {
            ElementImport importTdl = tdlFactory.eINSTANCE.createElementImport();
            importTdl.setImportedPackage(this.theTdlPackage);
            this.getGeneratedPackage().getImport().add((Object)importTdl);
            this.getGeneratedPackage().getPackagedElement().remove((Object)this.stringType);
        }
        IProject project = TDLHelper.getProjectForResource((Resource)this.getTargetResource());
        IEclipsePreferences preferences = null;
        if (project != null) {
            ProjectScope ps = new ProjectScope(project);
            preferences = ps.getNode("org.etsi.mts.tdl.openapi2tdl");
        }
        Package httpPackage = TDLHelper.getHttpPackage((Resource)this.getTargetResource());
        Package httpMessageBasedPackage = null;
        boolean useMessageBasedApi = true;
        if (preferences != null) {
            useMessageBasedApi = !preferences.getBoolean("ProcedureBased", false);
        }
        StructuredDataType messageBody = null;
        if (useMessageBasedApi && httpPackage != null) {
            block0: for (Package p : httpPackage.getNestedPackage()) {
                for (PackageableElement e : p.getPackagedElement()) {
                    if (!e.eClass().equals(tdlPackage.eINSTANCE.getStructuredDataType()) || !e.getName().equals("Body")) continue;
                    messageBody = (StructuredDataType)e;
                    httpMessageBasedPackage = p;
                    break block0;
                }
            }
            if (httpMessageBasedPackage != null) {
                ElementImport importHttp = tdlFactory.eINSTANCE.createElementImport();
                importHttp.setImportedPackage(httpMessageBasedPackage);
                this.getGeneratedPackage().getImport().add((Object)importHttp);
            }
        }
        Package mappingsPackage = null;
        Package javaPackage = null;
        AnnotationType mappingNameAnnot = null;
        boolean generateJavaMappings = true;
        if (preferences != null) {
            generateJavaMappings = preferences.getBoolean("GenerateJavaMapping", false);
        }
        if (generateJavaMappings && this.theTdlPackage != null) {
            Annotation annot;
            mappingsPackage = tdlFactory.eINSTANCE.createPackage();
            mappingsPackage.setName("JavaMapping");
            this.getGeneratedPackage().getNestedPackage().add((Object)mappingsPackage);
            ElementImport typesImport = tdlFactory.eINSTANCE.createElementImport();
            typesImport.setImportedPackage(this.getGeneratedPackage());
            mappingsPackage.getImport().add((Object)typesImport);
            if (this.theTdlPackage != null) {
                ElementImport tdlImport = tdlFactory.eINSTANCE.createElementImport();
                tdlImport.setImportedPackage(this.theTdlPackage);
                mappingsPackage.getImport().add((Object)tdlImport);
            }
            if ((javaPackage = TDLHelper.getJavaPackage((Resource)this.getTargetResource())) != null) {
                ElementImport javaImport = tdlFactory.eINSTANCE.createElementImport();
                javaImport.setImportedPackage(javaPackage);
                mappingsPackage.getImport().add((Object)javaImport);
            }
            this.drmTarget = (DataResourceMapping)this.getTypeFor(targetMappingTag, tdlPackage.Literals.DATA_RESOURCE_MAPPING);
            mappingsPackage.getPackagedElement().add((Object)this.drmTarget);
            this.drmTarget.setResourceURI(preferences.get("JavaApiPackage", "generated.java"));
            if (javaPackage != null) {
                for (PackageableElement e : javaPackage.getPackagedElement()) {
                    if (!e.eClass().equals(tdlPackage.eINSTANCE.getAnnotationType()) || !e.getName().equals("JavaPackage")) continue;
                    annot = tdlFactory.eINSTANCE.createAnnotation();
                    annot.setKey((AnnotationType)e);
                    this.drmTarget.getAnnotation().add((Object)annot);
                    break;
                }
            }
            for (PackageableElement e : this.theTdlPackage.getPackagedElement()) {
                if (!e.eClass().equals(tdlPackage.eINSTANCE.getAnnotationType()) || !e.getName().equals("MappingName")) continue;
                mappingNameAnnot = (AnnotationType)e;
                annot = tdlFactory.eINSTANCE.createAnnotation();
                annot.setKey(mappingNameAnnot);
                annot.setValue("Java");
                this.drmTarget.getAnnotation().add((Object)annot);
                break;
            }
        }
        Hashtable<String, HashSet<PathOperation>> schemaOperations = new Hashtable<String, HashSet<PathOperation>>();
        HashSet<PathOperation> inlineSchemaOperations = new HashSet<PathOperation>();
        HashSet<PathOperation> noContentOperations = new HashSet<PathOperation>();
        Paths paths = this.model.getPaths();
        for (String pathUri : paths.keySet()) {
            PathItem path = (PathItem)paths.get((Object)pathUri);
            Map ops = path.readOperationsMap();
            for (PathItem.HttpMethod method : ops.keySet()) {
                Operation op = (Operation)ops.get(method);
                RequestBody req = op.getRequestBody();
                if (req != null) {
                    String schemaName;
                    MediaType jsonContent = (MediaType)req.getContent().get((Object)"application/json");
                    if (jsonContent == null) continue;
                    Schema schema2 = jsonContent.getSchema();
                    boolean array = false;
                    if (this.getSchemaType(schema2) != null && this.getSchemaType(schema2).equals("array")) {
                        schema2 = schema2.getItems();
                        array = true;
                    }
                    if ((schemaName = schema2.get$ref()) == null) {
                        inlineSchemaOperations.add(new PathOperation(pathUri, method, op, array, schema2));
                        continue;
                    }
                    HashSet<PathOperation> set = (HashSet<PathOperation>)schemaOperations.get(schemaName = schemaName.replace("#/components/schemas/", ""));
                    if (set == null) {
                        set = new HashSet<PathOperation>();
                        schemaOperations.put(schemaName, set);
                    }
                    set.add(new PathOperation(pathUri, method, op, array, null));
                    continue;
                }
                noContentOperations.add(new PathOperation(pathUri, method, op, false, null));
            }
        }
        StructuredDataType httpRequest = null;
        CollectionDataType httpRequestParameters = null;
        EnumDataType httpParameterLocationEnum = null;
        EnumDataType httpMethodEnum = null;
        if (httpMessageBasedPackage != null) {
            for (PackageableElement e : httpMessageBasedPackage.getPackagedElement()) {
                if (e.eClass().equals(tdlPackage.eINSTANCE.getStructuredDataType())) {
                    if (!e.getName().equals("Request")) continue;
                    httpRequest = (StructuredDataType)e;
                    continue;
                }
                if (e.eClass().equals(tdlPackage.eINSTANCE.getEnumDataType())) {
                    if (e.getName().equals("Method")) {
                        httpMethodEnum = (EnumDataType)e;
                        continue;
                    }
                    if (!e.getName().equals("Location")) continue;
                    httpParameterLocationEnum = (EnumDataType)e;
                    continue;
                }
                if (!e.eClass().equals(tdlPackage.eINSTANCE.getCollectionDataType()) || !e.getName().equals("Parameters")) continue;
                httpRequestParameters = (CollectionDataType)e;
            }
        }
        if (useMessageBasedApi) {
            this.createOperationWrapper(noContentOperations, httpRequest, httpMethodEnum, httpRequestParameters, httpParameterLocationEnum);
        }
        for (PathOperation op : inlineSchemaOperations) {
            schema = op.inlineSchema;
            schema.setName(String.valueOf(op.path.substring(1)) + "_body");
            this.translate(schema, "", (DataType)messageBody);
            if (!useMessageBasedApi) continue;
            this.createOperationWrapper(Collections.singleton(op), httpRequest, httpMethodEnum, httpRequestParameters, httpParameterLocationEnum);
        }
        for (String schemaName : this.model.getComponents().getSchemas().keySet()) {
            Set ops;
            schema = (Schema)this.model.getComponents().getSchemas().get(schemaName);
            schema.setName(schemaName);
            this.translate(schema, "", (DataType)messageBody);
            if (!useMessageBasedApi || (ops = (Set)schemaOperations.get(schemaName)) == null) continue;
            this.createOperationWrapper(ops, httpRequest, httpMethodEnum, httpRequestParameters, httpParameterLocationEnum);
        }
        if (generateJavaMappings && mappingsPackage != null) {
            this.addMappings(filename, mappingsPackage, this.drmTarget, javaPackage, mappingNameAnnot);
        }
        this.ensureUniqueNames(this.getGeneratedPackage());
    }

    private String getSchemaType(Schema<?> schema) {
        Set types;
        String type = schema.getType();
        if (type == null && (types = schema.getTypes()) != null && !types.isEmpty()) {
            type = (String)types.iterator().next();
        }
        return type;
    }

    private void createOperationWrapper(Set<PathOperation> ops, StructuredDataType httpRequest, EnumDataType httpMethodEnum, CollectionDataType httpRequestParameters, EnumDataType httpParameterLocationEnum) {
        for (PathOperation pathOperation : ops) {
            Operation op = pathOperation.operation;
            String name = op.getOperationId();
            if (name == null) {
                name = pathOperation.path;
            }
            StructuredDataInstance requestData = this.getStructuredDataInstanceFor(name);
            requestData.setDataType((DataType)httpRequest);
            this.setMemberValue(requestData, "uri", pathOperation.path);
            SimpleDataInstance methodValue = (SimpleDataInstance)this.findContentWithName(pathOperation.method.name(), (NamedElement)httpMethodEnum, tdlPackage.eINSTANCE.getSimpleDataInstance());
            this.setMemberValue(requestData, "method", methodValue);
            List opParams = op.getParameters();
            if (opParams == null || opParams.size() <= 0) continue;
            Map params = this.model.getComponents().getParameters();
            for (io.swagger.v3.oas.models.parameters.Parameter par : op.getParameters()) {
                String in;
                if (par.get$ref() != null) {
                    String paraName = par.get$ref();
                    io.swagger.v3.oas.models.parameters.Parameter p = (io.swagger.v3.oas.models.parameters.Parameter)params.get(paraName = paraName.replace("#/components/parameters/", ""));
                    if (p == null) {
                        System.err.println("Invalid parameter reference at " + par.get$ref());
                    }
                    par = p;
                }
                if ((in = par.getIn()).equals("query") || in.equals("path")) {
                    String parameterName = par.getName();
                    DataType parameterType = httpRequestParameters.getItemType();
                    StructuredDataInstance parameter = this.getStructuredDataInstanceFor(String.valueOf(name) + "__" + parameterName);
                    parameter.setDataType(parameterType);
                    SimpleDataInstance queryValue = (SimpleDataInstance)this.findContentWithName(in, (NamedElement)httpParameterLocationEnum, tdlPackage.eINSTANCE.getSimpleDataInstance());
                    this.setMemberValue(parameter, "location", queryValue);
                    this.setMemberValue(parameter, "name", parameterName);
                    continue;
                }
                System.err.println("Unsupported parameter type: " + in + " at " + par.get$ref());
            }
        }
    }

    private void setMemberValue(StructuredDataInstance data, String memberName, Object value) {
        Member member = (Member)this.findContentWithName(memberName, (NamedElement)data.getDataType(), tdlPackage.eINSTANCE.getMember());
        MemberAssignment assignment = tdlFactory.eINSTANCE.createMemberAssignment();
        assignment.setMember(member);
        if (value instanceof String) {
            LiteralValueUse dataUse = tdlFactory.eINSTANCE.createLiteralValueUse();
            dataUse.setValue((String)value);
            assignment.setMemberSpec((DataUse)dataUse);
        } else if (value instanceof DataInstance) {
            DataElementUse dataUse = tdlFactory.eINSTANCE.createDataElementUse();
            dataUse.setDataElement((NamedElement)((DataInstance)value));
            assignment.setMemberSpec((DataUse)dataUse);
        } else if (value instanceof DataUse) {
            assignment.setMemberSpec((DataUse)value);
        }
        data.getMemberAssignment().add((Object)assignment);
    }

    private void setParameterValue(DataElementUse data, DataType type, String parameterName, Object value) {
        Parameter parameter = (Parameter)this.findContentWithName(parameterName, (NamedElement)type, tdlPackage.eINSTANCE.getParameter());
        ParameterBinding binding = tdlFactory.eINSTANCE.createParameterBinding();
        binding.setParameter(parameter);
        if (value instanceof String) {
            LiteralValueUse dataUse = tdlFactory.eINSTANCE.createLiteralValueUse();
            dataUse.setValue((String)value);
            binding.setDataUse((DataUse)dataUse);
        } else if (value instanceof DataInstance) {
            DataElementUse dataUse = tdlFactory.eINSTANCE.createDataElementUse();
            dataUse.setDataElement((NamedElement)((DataInstance)value));
            binding.setDataUse((DataUse)dataUse);
        } else if (value instanceof DataUse) {
            binding.setDataUse((DataUse)value);
        }
        data.getArgument().add((Object)binding);
    }

    public void setTargetResource(Resource targetResource) {
        super.setTargetResource(targetResource);
        Class<?> resourceClass = targetResource.getClass();
        do {
            if (!resourceClass.getSimpleName().equals("XtextResource")) continue;
            this.isXtext = true;
            break;
        } while ((resourceClass = resourceClass.getSuperclass()) != null);
        if (this.isXtext) {
            this.xtextKyewords = TDLHelper.getTdlGrammarKeywords();
        }
    }

    private void addMapping(Schema<?> schema, DataType dataType, String sourceMappingTag, String targetMappingTag) {
        DataElementMapping sourceMapping = this.addDataElementMapping("#/components/schemas/" + schema.getName(), dataType, sourceMappingTag, this.drm);
        DataElementMapping targetMapping = this.addDataElementMapping(schema.getName(), dataType, targetMappingTag, this.drmTarget);
        if (dataType instanceof StructuredDataType) {
            for (Member m : ((StructuredDataType)dataType).getMember()) {
                this.addParameterMapping(sourceMapping, (Parameter)m, m.getName());
                this.addParameterMapping(targetMapping, (Parameter)m, m.getName());
            }
        }
    }

    private void getAllProperties(Schema<?> schema, Map<String, Schema> properties) {
        List xOf;
        String reference = schema.get$ref();
        if (reference != null) {
            schema = ModelUtils.getReferencedSchema((OpenAPI)this.model, schema);
        }
        if ((xOf = schema.getAllOf()) == null) {
            xOf = schema.getAnyOf();
        }
        if (xOf == null) {
            xOf = schema.getOneOf();
        }
        if (xOf != null) {
            for (Schema ofSchema : xOf) {
                this.getAllProperties(ofSchema, properties);
            }
        }
        if (schema.getProperties() != null) {
            properties.putAll(schema.getProperties());
        }
    }

    private DataType translate(Schema<?> schema, String prefix, DataType superType) {
        Hashtable<String, Schema> properties = new Hashtable<String, Schema>();
        this.getAllProperties(schema, properties);
        if (this.getSchemaType(schema) == null && properties.isEmpty()) {
            if (schema.getName() == null) {
                System.out.println("Why?");
            }
            return this.translateSimpleType(schema, superType);
        }
        String name = String.valueOf(prefix) + schema.getName();
        if (schema.getName() == null) {
            name = String.valueOf(prefix) + "___item";
        }
        if (!properties.isEmpty() || this.getSchemaType(schema).equals("object")) {
            DataType t = this.translateObject(schema, name);
            this.addSuperType(t, superType);
            return t;
        }
        if (this.getSchemaType(schema).equals("array")) {
            return this.translateArray(schema, name);
        }
        return this.translateSimpleType(schema, superType);
    }

    private DataType translateSimpleType(Schema<?> schema, DataType superType) {
        EnumDataType t;
        String name = schema.getName();
        if (name == null) {
            name = this.getSchemaType(schema);
        }
        if (this.theTdlPackage != null && (name.equals("string") || name.equals("integer") || name.equals("boolean"))) {
            name = name.replaceFirst(Character.toString(name.charAt(0)), Character.toString(name.charAt(0)).toUpperCase());
            for (PackageableElement pe : this.theTdlPackage.getPackagedElement()) {
                if (!pe.eClass().equals(tdlPackage.eINSTANCE.getSimpleDataType()) || !pe.getName().equals(name)) continue;
                return (DataType)pe;
            }
        }
        if (schema.getEnum() != null) {
            t = this.getEnumDataTypeFor(name);
            if (t.getValue().isEmpty()) {
                for (Object literal : schema.getEnum()) {
                    String literalName;
                    if (literal instanceof String) {
                        literalName = (String)literal;
                    } else {
                        if (!(literal instanceof Integer)) continue;
                        literalName = String.valueOf(name) + "_" + ((Integer)literal).toString();
                    }
                    SimpleDataInstance literalData = tdlFactory.eINSTANCE.createSimpleDataInstance();
                    literalData.setName(this.getCleanName(literalName));
                    literalData.setDataType((DataType)t);
                    t.getValue().add((Object)literalData);
                }
            }
            return t;
        }
        t = this.getSimpleDataTypeFor(name);
        this.addSuperType((DataType)t, superType);
        return t;
    }

    private DataType translateObject(Schema<?> schema, String name) {
        Hashtable<String, Schema> properties = new Hashtable<String, Schema>();
        this.getAllProperties(schema, properties);
        StructuredDataType dataType = this.getStructuredDataTypeFor(name);
        if (properties.isEmpty() || !dataType.getMember().isEmpty()) {
            return dataType;
        }
        for (Object propertyName : properties.keySet()) {
            Schema propertySchema = (Schema)properties.get(propertyName);
            String reference = propertySchema.get$ref();
            DataType memberType = null;
            if (reference != null) {
                Schema referencedSchema = ModelUtils.getReferencedSchema((OpenAPI)this.model, (Schema)propertySchema);
                referencedSchema.setName(ModelUtils.getSimpleRef((String)reference));
                memberType = this.translate(referencedSchema, "", null);
            } else {
                memberType = this.translate(propertySchema, String.valueOf(name) + "___", null);
            }
            Member m = (Member)this.getContentWithName((String)propertyName, (NamedElement)dataType, tdlPackage.Literals.MEMBER);
            m.setDataType(memberType);
            if (m.container() != null) continue;
            dataType.getMember().add((Object)m);
        }
        return dataType;
    }

    private DataType translateArray(Schema<?> schema, String name) {
        DataType itemType;
        Schema itemsSchema = schema.getItems();
        String reference = itemsSchema.get$ref();
        if (reference != null) {
            Schema referencedSchema = ModelUtils.getReferencedSchema((OpenAPI)this.model, (Schema)itemsSchema);
            referencedSchema.setName(ModelUtils.getSimpleRef((String)reference));
            itemType = this.translate(referencedSchema, "", null);
        } else {
            itemType = this.translate(itemsSchema, name, null);
        }
        CollectionDataType collectionType = (CollectionDataType)this.getTypeFor(String.valueOf(itemType.getName()) + "_collection", tdlPackage.Literals.COLLECTION_DATA_TYPE);
        collectionType.setItemType(itemType);
        return collectionType;
    }

    public String getCleanName(String name) {
        String replacement = name;
        if (this.isXtext) {
            if (replacement.matches(this.idStartDigitRegex)) {
                replacement = "_" + replacement;
            }
            replacement = replacement.replaceAll(this.idInvalidCharRegex, "_");
        }
        return replacement;
    }

    public static OpenAPI parseSpec(String specFilePath, Boolean processInline) throws Exception {
        OpenAPI openAPI = new OpenAPIParser().readLocation(specFilePath, null, new ParseOptions()).getOpenAPI();
        if (openAPI == null) {
            throw new Exception("Failed to parse '" + specFilePath + "', make sure it's valid ");
        }
        ModelUtils.getOpenApiVersion((OpenAPI)openAPI, (String)specFilePath, null);
        if (processInline.booleanValue()) {
            InlineModelResolver inlineModelResolver = new InlineModelResolver();
            inlineModelResolver.flatten(openAPI);
        }
        return openAPI;
    }

    public void addMappings(String filename, final Package mappingsPackage, final DataResourceMapping resourceMapping, final Package javaPackage, final AnnotationType mappingNameAnnot) {
        CodegenConfigurator configurator = new CodegenConfigurator();
        configurator.setGeneratorName("java");
        configurator.setInputSpec(filename.replaceAll("\\\\", "/"));
        JavaClientCodegen config = new JavaClientCodegen(){

            public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
                AnnotationType getterAnnotation = null;
                AnnotationType setterAnnotation = null;
                AnnotationType classAnnotation = null;
                if (javaPackage != null) {
                    for (PackageableElement e : javaPackage.getPackagedElement()) {
                        if (!e.eClass().equals(tdlPackage.eINSTANCE.getAnnotationType())) continue;
                        if (e.getName().equals("JavaGetter")) {
                            getterAnnotation = (AnnotationType)e;
                        }
                        if (e.getName().equals("JavaSetter")) {
                            setterAnnotation = (AnnotationType)e;
                        }
                        if (!e.getName().equals("JavaClass")) continue;
                        classAnnotation = (AnnotationType)e;
                    }
                }
                List allModels = (List)objs.get("models");
                for (ModelMap modelMap : allModels) {
                    CodegenModel codeGen = modelMap.getModel();
                    String name = codeGen.getName();
                    Object type = null;
                    type = codeGen.isEnum ? OpenAPI2TDLTranslatorNext.this.getEnumDataTypeFor(name) : OpenAPI2TDLTranslatorNext.this.getStructuredDataTypeFor(name);
                    DataElementMapping eMapping = tdlFactory.eINSTANCE.createDataElementMapping();
                    mappingsPackage.getPackagedElement().add((Object)eMapping);
                    eMapping.setName(String.valueOf(OpenAPI2TDLTranslatorNext.this.getCleanName(name)) + "_Mapping");
                    eMapping.setMappableDataElement((MappableDataElement)type);
                    eMapping.setElementURI(codeGen.getClassname());
                    eMapping.setDataResourceMapping(resourceMapping);
                    Annotation ca = tdlFactory.eINSTANCE.createAnnotation();
                    ca.setKey(classAnnotation);
                    eMapping.getAnnotation().add((Object)ca);
                    if (type instanceof EnumDataType) {
                        DataResourceMapping eResourceMapping = tdlFactory.eINSTANCE.createDataResourceMapping();
                        mappingsPackage.getPackagedElement().add((Object)eResourceMapping);
                        eResourceMapping.setName(String.valueOf(OpenAPI2TDLTranslatorNext.this.getCleanName(name)) + "_ResourceMapping");
                        eResourceMapping.setResourceURI(String.valueOf(resourceMapping.getResourceURI()) + "." + codeGen.getClassname());
                        ca = tdlFactory.eINSTANCE.createAnnotation();
                        ca.setKey(classAnnotation);
                        eResourceMapping.getAnnotation().add((Object)ca);
                        Annotation mna = tdlFactory.eINSTANCE.createAnnotation();
                        mna.setKey(mappingNameAnnot);
                        mna.setValue("Java");
                        eResourceMapping.getAnnotation().add((Object)mna);
                        List enumVars = (List)codeGen.getAllowableValues().get("enumVars");
                        for (Map enumVar : enumVars) {
                            String javaName = (String)enumVar.get("name");
                            String modelName = (String)enumVar.get("value");
                            modelName = modelName.startsWith("\"") ? modelName.substring(1, modelName.length() - 1) : String.valueOf(name) + "_" + modelName;
                            SimpleDataInstance literal = null;
                            for (SimpleDataInstance l : type.getValue()) {
                                if (!l.getName().equals(OpenAPI2TDLTranslatorNext.this.getCleanName(modelName))) continue;
                                literal = l;
                                break;
                            }
                            if (literal == null) continue;
                            DataElementMapping lMapping = tdlFactory.eINSTANCE.createDataElementMapping();
                            mappingsPackage.getPackagedElement().add((Object)lMapping);
                            lMapping.setName(String.valueOf(OpenAPI2TDLTranslatorNext.this.getCleanName(name)) + "_" + OpenAPI2TDLTranslatorNext.this.getCleanName(modelName) + "_Mapping");
                            lMapping.setMappableDataElement((MappableDataElement)literal);
                            lMapping.setElementURI(javaName);
                            lMapping.setDataResourceMapping(eResourceMapping);
                        }
                        continue;
                    }
                    if (!(type instanceof StructuredDataType)) continue;
                    for (CodegenProperty var : codeGen.getAllVars()) {
                        String vName = var.getBaseName();
                        Member member = null;
                        for (Member m : ((StructuredDataType)type).allMembers()) {
                            if (!m.getName().equals(OpenAPI2TDLTranslatorNext.this.getCleanName(vName))) continue;
                            member = m;
                            break;
                        }
                        if (member == null) continue;
                        ParameterMapping pMapping = tdlFactory.eINSTANCE.createParameterMapping();
                        eMapping.getParameterMapping().add((Object)pMapping);
                        pMapping.setParameter(member);
                        pMapping.setParameterURI(var.getName());
                        if (getterAnnotation == null || setterAnnotation == null) continue;
                        Annotation ga = tdlFactory.eINSTANCE.createAnnotation();
                        ga.setKey(getterAnnotation);
                        ga.setValue(var.getGetter());
                        pMapping.getAnnotation().add((Object)ga);
                        Annotation sa = tdlFactory.eINSTANCE.createAnnotation();
                        sa.setKey(setterAnnotation);
                        sa.setValue(var.getSetter());
                        pMapping.getAnnotation().add((Object)sa);
                    }
                }
                return objs;
            }
        };
        ClientOptInput input = new ClientOptInput().config((CodegenConfig)config);
        input.openAPI((OpenAPI)configurator.toContext().getSpecDocument());
        DefaultGenerator generator = new DefaultGenerator(Boolean.valueOf(true));
        generator.opts(input);
        generator.generate();
    }

    class PathOperation {
        String path;
        PathItem.HttpMethod method;
        Operation operation;
        Schema<?> inlineSchema;
        boolean array;

        public PathOperation(String path, PathItem.HttpMethod method, Operation operation, boolean array, Schema<?> inlineSchema) {
            this.path = path;
            this.method = method;
            this.operation = operation;
            this.inlineSchema = inlineSchema;
            this.array = array;
        }
    }
}

