/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.importers.ui.handlers;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.asn2tdl.ASN2TDLTranslator;
import org.etsi.mts.tdl.helper.TDLHelper;
import org.etsi.mts.tdl.json2tdl.JSON2TDLTranslator;
import org.etsi.mts.tdl.openapi2tdl.next.OpenAPI2TDLTranslatorNext;
import org.etsi.mts.tdl.to2tdl.TO2TDLTranslator;
import org.etsi.mts.tdl.yang2tdl.Yang2TDLTranslator;

public class TranslationHandler
extends AbstractHandler {
    @Inject
    Injector injector;
    @Inject
    Provider<ResourceSet> rsp;
    @Inject
    Provider<XtextResourceSet> xrsp;
    @Inject
    IResourceSetProvider resourceSetProvider;
    LinkedHashMap<String, String> targetFormats = new LinkedHashMap();
    public static String translationTarget = "TDL XF (Part 3, XMI)";
    private IWorkbenchWindow window;

    public TranslationHandler() {
        this.init();
    }

    private void init() {
        this.targetFormats.isEmpty();
        this.targetFormats.clear();
        this.targetFormats.put("TDL XF (Part 3, XMI)", "tdl");
        this.loadTargetFormat("org.etsi.mts.tdl.tx", "TDL TX (Part 8, Braces)", "tdltx");
        this.loadTargetFormat("org.etsi.mts.tdl.txi", "TDL TX (Part 8, Indentation)", "tdltxi");
        this.loadTargetFormat("org.etsi.mts.tdl.TDLan2", "TDLan2 (Part 1, Annex B)", "tdlan2");
        this.loadTargetFormat("org.etsi.mts.tdl.TPLan2", "TPLan2 (Part 4, Annex B)", "tplan2");
    }

    private void loadTargetFormat(String bundleName, String label, String extension) {
        if (Platform.getBundle((String)bundleName) != null) {
            this.targetFormats.put(label, extension);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.init();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEditorInput input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        IFile file = null;
        IContainer container = null;
        if (input != null && input instanceof FileEditorInput) {
            file = ((FileEditorInput)input).getFile();
        } else if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof IFile) {
                file = (IFile)firstElement;
            }
            if (firstElement instanceof IContainer) {
                container = (IContainer)firstElement;
            }
        }
        if (file != null || container != null) {
            String selected;
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            ResourceSetImpl rs = new ResourceSetImpl();
            String filepath = file.getLocation().toFile().getAbsolutePath();
            String type = file.getFileExtension();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new LabelProvider());
            dialog.setTitle("Import configuration");
            dialog.setMessage("Importing " + type + " from " + file.getName() + "\n\nSelect the target format");
            dialog.setElements(this.targetFormats.keySet().toArray());
            dialog.setInitialElementSelections(Arrays.asList(translationTarget));
            if (dialog.open() != 0) {
                return false;
            }
            this.injector = Guice.createInjector((Module[])new Module[0]);
            Object[] result = dialog.getResult();
            translationTarget = selected = (String)result[0];
            String extension = this.targetFormats.get(selected);
            URI targetURI = URI.createURI((String)(String.valueOf(uri.toString()) + "-generated." + extension));
            XtextResourceSet resourceSet = (XtextResourceSet)this.injector.getInstance(XtextResourceSet.class);
            Resource tr = resourceSet.createResource(targetURI);
            ASN2TDLTranslator translator = null;
            if (type.contains("asn")) {
                translator = new ASN2TDLTranslator();
            }
            if (type.contains("json")) {
                translator = new JSON2TDLTranslator();
            }
            if (type.contains("yaml")) {
                translator = new OpenAPI2TDLTranslatorNext();
            }
            if (type.contains("yang")) {
                translator = new Yang2TDLTranslator();
                if (container == null) {
                    container = file.getParent();
                }
                while (container.getParent() != null && !container.isLinked() && container.getType() == 2) {
                    container = container.getParent();
                }
                String limit = container.getLocation().toFile().getAbsolutePath();
                ((Yang2TDLTranslator)translator).setLimit(limit);
            }
            if (translator != null) {
                translator.setTargetResource(tr);
                translator.initTargetResource(translator.getCleanName(file.getName()));
                try {
                    translator.translate(filepath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.etsi.mts.tdl.importers.ui", "Failed to translate", (Throwable)e), 3);
                }
            }
            if (type.contains("tplan2")) {
                Resource r = rs.getResource(uri, true);
                Package p = (Package)r.getContents().get(0);
                translator = new TO2TDLTranslator();
                translator.setTargetResource(tr);
                translator.initTargetResource("generated_from_" + p.getName());
                translator.addImports(p);
                ((TO2TDLTranslator)translator).transform(p);
            }
            try {
                TDLHelper.store((Resource)tr, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showErrorDialog(e);
            }
        }
        return null;
    }

    private void showErrorDialog(Exception e) {
        String message = e.getMessage();
        Throwable cause = e;
        while ((cause = cause.getCause()) != null) {
            message = String.valueOf(message) + "\nCaused by: \n\t" + cause.getMessage();
        }
        MessageDialog errorDialog = new MessageDialog(Display.getDefault().getActiveShell(), "Translation error...", null, "An error occurred during the translation. It may be due to problems occurring while processing the input, e.g if the input could not be processed. See details for a more technical description:\n\n" + message, 1, 0, new String[]{"OK"});
        errorDialog.open();
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public boolean isEnabled() {
        return true;
    }
}

