/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.ttcn3;

import de.ugoe.cs.swe.tTCN3.TTCN3Package;
import java.net.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.emc.emf.InMemoryEmfModel;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.etl.EtlModule;
import org.etsi.mts.tdl.resources.ResourceHandler;
import org.etsi.mts.tdl.tdlPackage;

public class Transform {
    public void transform(Resource r, Resource tr) {
        try {
            String source = "epsilon/ttcn3/ttcn3mapping.etl";
            URI uri = ResourceHandler.getSourceUri(this.getClass(), (String)"org.etsi.mts.tdl.ttcn3", (String)source);
            EtlModule module = new EtlModule();
            module.parse(uri);
            if (module.getParseProblems().size() > 0) {
                System.err.println("Parse errors occured...");
                for (ParseProblem problem : module.getParseProblems()) {
                    System.err.println("  ETL: " + problem.toString());
                }
            }
            IModel tdlModel = this.getTDLModel(r, true, false);
            IModel ttcnModel = this.getTTCNModel(tr, false, true);
            tdlModel.load();
            ttcnModel.load();
            module.getContext().getModelRepository().addModel(tdlModel);
            module.getContext().getModelRepository().addModel(ttcnModel);
            module.execute();
            tdlModel.dispose();
            ttcnModel.dispose();
        }
        catch (EolRuntimeException e) {
            System.err.println("  EOL: " + e.getAst().getModule().getSourceUri().getPath() + " : " + e.getLine() + " : " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("  Transformation: " + e.getMessage());
        }
    }

    public IModel getTDLModel(Resource resource, boolean read, boolean write) throws Exception {
        InMemoryEmfModel model = new InMemoryEmfModel("TDL", resource, new EPackage[]{tdlPackage.eINSTANCE});
        model.setStoredOnDisposal(write);
        model.setReadOnLoad(read);
        model.setCachingEnabled(true);
        return model;
    }

    public IModel getTTCNModel(Resource resource, boolean read, boolean write) throws Exception {
        InMemoryEmfModel model = new InMemoryEmfModel("TTCN", resource, new EPackage[]{TTCN3Package.eINSTANCE});
        model.setStoredOnDisposal(write);
        model.setReadOnLoad(read);
        model.setCachingEnabled(true);
        return model;
    }
}

