/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.execution.java.eclipse.commands;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.execution.java.codegen.JUnitTestGenerator;
import org.etsi.mts.tdl.execution.java.codegen.Settings;

public class RenderHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String ext;
        Object element;
        IFile tdl = null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile && (ext = ((IFile)element).getFileExtension()).toLowerCase().contains("tdl")) {
            tdl = (IFile)element;
        }
        if (tdl == null) {
            return null;
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        URI uri = URI.createPlatformResourceURI((String)tdl.getFullPath().toString(), (boolean)true);
        Resource resource = rs.getResource(uri, true);
        EcoreUtil.resolveAll((Resource)resource);
        Package model = (Package)resource.getContents().get(0);
        ProjectScope ps = new ProjectScope(tdl.getProject());
        IEclipsePreferences preferences = ps.getNode("org.etsi.mts.tdl.execution");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        final IFolder generationDir = root.getFolder((IPath)new Path(preferences.get("JavaRendering.OutputDir", "")));
        Settings settings = new Settings(preferences.get("JavaRendering.OutputDir", ""), generationDir.getLocation().toFile(), preferences.get("JavaRendering.Package", ""), preferences.get("JavaRendering.Injector", ""), preferences.get("JavaRendering.DateFormat", ""), preferences.get("JavaRendering.UseMapping", ""), preferences.getBoolean("JavaRendering.UnmappedData", false));
        final JUnitTestGenerator generator = new JUnitTestGenerator(model, settings);
        Job j = new Job("Render JUnit"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    generator.generate();
                }
                catch (IOException e) {
                    return new Status(4, ((Object)((Object)this)).getClass(), "Render JUnit failed", (Throwable)e);
                }
                try {
                    generationDir.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.setPriority(10);
        j.schedule();
        return null;
    }
}

