/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.json2tdl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.Files;
import org.etsi.mts.tdl.CollectionDataType;
import org.etsi.mts.tdl.DataElementMapping;
import org.etsi.mts.tdl.DataElementUse;
import org.etsi.mts.tdl.DataUse;
import org.etsi.mts.tdl.LiteralValueUse;
import org.etsi.mts.tdl.MappableDataElement;
import org.etsi.mts.tdl.MemberAssignment;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.Parameter;
import org.etsi.mts.tdl.ParameterBinding;
import org.etsi.mts.tdl.SimpleDataType;
import org.etsi.mts.tdl.StructuredDataInstance;
import org.etsi.mts.tdl.StructuredDataType;

public class TDL2JSONTranslator {
    private Map<MappableDataElement, DataElementMapping> dataMappings = new LinkedHashMap<MappableDataElement, DataElementMapping>();
    private Map<Parameter, String> parameterMappings = new LinkedHashMap<Parameter, String>();

    public void transform(Package p) {
        this.indexMappings(p);
        List instances = EcoreUtil2.getAllContentsOfType((EObject)p, StructuredDataInstance.class);
        instances.forEach(this::translate);
    }

    public void indexMappings(Package p) {
        this.dataMappings = EcoreUtil2.getAllContentsOfType((EObject)p, DataElementMapping.class).stream().filter(e -> e.getName().endsWith("SOURCE_MAPPING")).collect(Collectors.toMap(e -> e.getMappableDataElement(), e -> e));
        this.dataMappings.values().forEach(this::indexParameterMappings);
    }

    private void indexParameterMappings(DataElementMapping dem) {
        dem.getParameterMapping().forEach(pm -> {
            String string = this.parameterMappings.put(pm.getParameter(), pm.getParameterURI());
        });
    }

    public String translate(StructuredDataInstance instance) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        LinkedHashMap map = new LinkedHashMap();
        instance.getMemberAssignment().forEach(ma -> this.transform((MemberAssignment)ma, (LinkedHashMap<String, Object>)map));
        String json = gson.toJson(map);
        System.out.println(json);
        String prefix = "examples/json/";
        String filename = String.valueOf(prefix) + instance.getQualifiedName().replaceAll("::", "_") + ".json";
        Files.writeStringIntoFile((String)filename, (String)json);
        return json;
    }

    public String translate(DataUse du) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this.transform(du));
        return json;
    }

    public Object transform(DataUse du) {
        if (du.resolveDataType() instanceof StructuredDataType) {
            NamedElement de;
            LinkedHashMap map = new LinkedHashMap();
            du.getArgument().forEach(pb -> this.transform((ParameterBinding)pb, (LinkedHashMap<String, Object>)map));
            if (du instanceof DataElementUse && (de = ((DataElementUse)du).getDataElement()) instanceof StructuredDataInstance) {
                ((StructuredDataInstance)de).getMemberAssignment().stream().filter(e -> du.getArgument().stream().noneMatch(a -> a.getParameter() == e.getMember())).forEach(ma -> this.transform((MemberAssignment)ma, (LinkedHashMap<String, Object>)map));
            }
            return map;
        }
        if (du.resolveDataType() instanceof CollectionDataType) {
            if (du instanceof DataElementUse) {
                return ((DataElementUse)du).getItem().stream().map(this::transform).collect(Collectors.toList());
            }
            return null;
        }
        if (du.resolveDataType() instanceof SimpleDataType) {
            if (du instanceof LiteralValueUse) {
                LiteralValueUse lvu = (LiteralValueUse)du;
                if (lvu.getIntValue() != null) {
                    return lvu.getIntValue();
                }
                if (lvu.getBoolValue() != null) {
                    return lvu.getBoolValue();
                }
                return lvu.getValue();
            }
            return null;
        }
        return null;
    }

    private void transform(ParameterBinding pb, LinkedHashMap<String, Object> map) {
        String key = pb.getParameter().getName();
        String mappedKey = this.parameterMappings.get(pb.getParameter());
        if (mappedKey != null) {
            key = mappedKey;
        }
        map.put(key, this.transform(pb.getDataUse()));
    }

    private void transform(MemberAssignment ma, LinkedHashMap<String, Object> map) {
        String key = ma.getMember().getName();
        String mappedKey = this.parameterMappings.get(ma.getMember());
        if (mappedKey != null) {
            key = mappedKey;
        }
        map.put(key, this.transform(ma.getMemberSpec()));
    }
}

