/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.ttcn3.ui.handlers;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.etsi.mts.tdl.ttcn3.Transform;

public class TransformationHandler
extends AbstractHandler {
    @Inject
    Injector injector;
    @Inject
    Provider<ResourceSet> rsp;
    @Inject
    Provider<XtextResourceSet> xrsp;
    @Inject
    IResourceSetProvider resourceSetProvider;
    private IWorkbenchWindow window;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Object firstElement;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEditorInput input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        IFile file = null;
        if (input != null && input instanceof FileEditorInput) {
            file = ((FileEditorInput)input).getFile();
        } else if (selection != null && selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            file = (IFile)firstElement;
        }
        try {
            if (file != null) {
                this.injector = Guice.createInjector((Module[])new Module[0]);
                URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                XtextResourceSet rs = (XtextResourceSet)this.injector.getInstance(XtextResourceSet.class);
                Resource r = rs.getResource(uri, true);
                EcoreUtil.resolveAll((Resource)r);
                if (file.getName().endsWith(".tdl") || file.getName().endsWith(".tdlan2") || file.getName().endsWith(".tdltx") || file.getName().endsWith(".tdltxi")) {
                    Transform transformer = new Transform();
                    URI interimURI = URI.createURI((String)(String.valueOf(uri.toString()) + "-generated.ttcn3m"));
                    Resource ir = rs.createResource(interimURI);
                    transformer.transform(r, ir);
                    ir.unload();
                    URI targetURI = URI.createURI((String)(String.valueOf(uri.toString()) + "-generated.ttcn3"));
                    Resource tr = rs.createResource(targetURI);
                    transformer.transform(r, tr);
                } else if (file.getName().endsWith(".ttcn3")) {
                    URI targetURI = URI.createURI((String)(String.valueOf(uri.toString()) + ".ttcn3m"));
                    Resource tr = rs.createResource(targetURI);
                    tr.getContents().addAll(EcoreUtil.copyAll((Collection)r.getContents()));
                    tr.save(null);
                } else if (file.getName().endsWith(".ttcn3m")) {
                    URI targetURI = URI.createURI((String)(String.valueOf(uri.toString()) + ".ttcn3"));
                    Resource tr = rs.createResource(targetURI);
                    tr.getContents().addAll(EcoreUtil.copyAll((Collection)r.getContents()));
                    tr.save(null);
                }
            }
        }
        catch (Exception e) {
            System.err.println("  Transformation: " + e.getMessage());
        }
        return null;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public boolean isEnabled() {
        return true;
    }
}

