/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.graphical.sirius.layout;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

class RefreshExtension
implements IRefreshExtension {
    RefreshExtension() {
    }

    public void beforeRefresh(DDiagram dDiagram) {
    }

    public void postRefresh(DDiagram dDiagram) {
        IEditingSession uiSession;
        EObject target = ((DSemanticDecorator)dDiagram).getTarget();
        Session session = target == null ? null : SessionManager.INSTANCE.getSession(target);
        IEditingSession iEditingSession = uiSession = session == null ? null : SessionUIManager.INSTANCE.getUISession(session);
        if (uiSession != null) {
            for (final DialectEditor e : uiSession.getEditors()) {
                final IDiagramWorkbenchPart dPart = (IDiagramWorkbenchPart)e;
                final DiagramRootEditPart root = (DiagramRootEditPart)dPart.getDiagramGraphicalViewer().getRootEditPart();
                if (root.getContents() == null) {
                    EditPartListener.Stub l = new EditPartListener.Stub(){

                        public void childAdded(EditPart child, int index) {
                            root.removeEditPartListener((EditPartListener)this);
                            RefreshExtension.this.runArrangeCommand((IEditorPart)e, dPart, root);
                        }
                    };
                    root.addEditPartListener((EditPartListener)l);
                    continue;
                }
                this.runArrangeCommand((IEditorPart)e, dPart, root);
            }
        }
    }

    private void runArrangeCommand(IEditorPart editor, IDiagramWorkbenchPart dPart, DiagramRootEditPart root) {
        EditPart dEditPart = root.getContents();
        ArrangeRequest arrReq = new ArrangeRequest("arrange_deferred");
        arrReq.setViewAdaptersToArrange(dEditPart.getChildren());
        Command command = dEditPart.getCommand((Request)arrReq);
        IWorkbenchPage page = editor.getSite().getPage();
        if (editor.equals(page.getActiveEditor())) {
            dPart.getDiagramEditDomain().getDiagramCommandStack().execute(command);
        }
    }
}

