/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.constraints.ui.handlers;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.etsi.mts.tdl.constraints.evl.Validator;
import org.etsi.mts.tdl.constraints.ui.handlers.ScrollableMessageDialog;

public class ValidationHandler
extends AbstractHandler {
    private IWorkbenchWindow window;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Object firstElement;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEditorInput input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        IFile file = null;
        if (input != null && input instanceof FileEditorInput) {
            file = ((FileEditorInput)input).getFile();
            file.getProject();
        } else if (selection != null && selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            file = (IFile)firstElement;
            file.getProject();
        }
        if (file != null) {
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Injector injector = Guice.createInjector((Module[])new Module[0]);
            XtextResourceSet rs = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
            Resource r = rs.getResource(uri, true);
            Validator validator = new Validator();
            String messages = "";
            try {
                List violations = validator.validate(r);
                for (UnsatisfiedConstraint v : violations) {
                    messages = String.valueOf(messages) + v.getMessage() + "\n";
                    if (!(((EObject)v.getInstance()).eResource() instanceof XtextResource)) continue;
                    ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)((EObject)v.getInstance()));
                    String text = "\tLine " + node.getStartLine() + "-" + node.getEndLine() + ":\n\t" + node.getText().trim();
                    messages = String.valueOf(messages) + "  " + text + "\n\n";
                }
                if (violations.size() == 0) {
                    messages = "No violations!";
                }
            }
            catch (Exception e) {
                messages = "An error occurred:" + e.getMessage().replaceAll("\n.+epsilon/", "\n  at (epsilon/");
            }
            ScrollableMessageDialog sdialog = new ScrollableMessageDialog(Display.getDefault().getActiveShell(), "Validation Results", null, "The following constraint violations occurred while validating '" + uri.lastSegment() + "':", 2, new String[]{"OK"}, 0, messages);
            sdialog.open();
        }
        return null;
    }

    private void addResourcePaths(IProject project, XtextResourceSet xrs) {
        final ArrayList resourcePaths = new ArrayList();
        try {
            final Map extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    System.out.println(resource.getFullPath());
                    if (extensionToFactoryMap.containsKey(resource.getFileExtension())) {
                        resourcePaths.add(resource.getFullPath().toOSString());
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        for (String p : resourcePaths) {
            URI pURI = URI.createPlatformResourceURI((String)p, (boolean)true);
            Resource pr = xrs.getResource(pURI, true);
            try {
                pr.load(Collections.emptyMap());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public boolean isEnabled() {
        return true;
    }
}

