/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.ui.wizard;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.PluginImageHelper;
import org.eclipse.xtext.ui.util.PluginProjectFactory;
import org.eclipse.xtext.ui.util.ProjectFactory;
import org.eclipse.xtext.ui.wizard.template.AbstractProjectTemplate;
import org.eclipse.xtext.ui.wizard.template.BooleanTemplateVariable;
import org.eclipse.xtext.ui.wizard.template.ContainerTemplateVariable;
import org.eclipse.xtext.ui.wizard.template.GroupTemplateVariable;
import org.eclipse.xtext.ui.wizard.template.IProjectGenerator;
import org.eclipse.xtext.ui.wizard.template.ProjectTemplate;
import org.eclipse.xtext.ui.wizard.template.StringTemplateVariable;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.etsi.mts.tdl.ui.wizard.TemplateHelper;

@ProjectTemplate(label="TDLtx with OpenAPI", icon="project_template.png", description="<p><b>TDLtx with OpenAPI</b></p>\n<p>This is a parameterized project for TDLtx with the option to import data definitions from OpenAPI. \nYou can set a parameter to modify the content in the generated file\nand a parameter to set the path the file is created in.</p><p><img href=\"project_template.png\"/></p>")
public final class TDLtxProjectWithOpenAPI
extends AbstractProjectTemplate {
    private final ScopedPreferenceStore s = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.etsi.mts.tdl.tx.ui.template.data.openapi");
    private final String lastUsed = "LAST_USED";
    private final BooleanTemplateVariable advanced = this.check("Advanced:", true);
    private final GroupTemplateVariable advancedGroup = this.group("Properties");
    private final StringTemplateVariable name = this.text("Main Package Name:", "Main", "The name of the main package");
    private final BooleanTemplateVariable importStandard = this.check("Import TDL Library", true, "Import TDL standard library definitions.", (ContainerTemplateVariable)this.advancedGroup);
    private final BooleanTemplateVariable importHTTP = this.check("Import HTTP Library", true, "Import TDL HTTP library definitions.", (ContainerTemplateVariable)this.advancedGroup);
    private final BooleanTemplateVariable importJava = this.check("Import Java mapping libraries", false, "Import TDL Java mappings.", (ContainerTemplateVariable)this.advancedGroup);
    private final BooleanTemplateVariable extendedNature = this.check("Add additional natures", false, "Add Eclipse Plug-in and Java natures", (ContainerTemplateVariable)this.advancedGroup);
    private final StringTemplateVariable path = this.text("Path:", "tdl", "The package path to place the files in", (ContainerTemplateVariable)this.advancedGroup);
    @Inject
    private PluginImageHelper pluginImageHelper;

    protected void updateVariables() {
        boolean _not;
        this.name.setEnabled(this.advanced.getValue());
        this.path.setEnabled(this.advanced.getValue());
        this.importStandard.setEnabled(this.advanced.getValue());
        this.importHTTP.setEnabled(this.advanced.getValue());
        this.extendedNature.setEnabled(this.advanced.getValue());
        boolean _value = this.advanced.getValue();
        boolean bl = _not = !_value;
        if (_not) {
            this.name.setValue("Main");
            this.path.setValue("tdl");
            this.importStandard.setValue(true);
            this.importHTTP.setValue(true);
            this.importJava.setValue(false);
            this.extendedNature.setValue(false);
        }
    }

    protected IStatus validate() {
        Status _xifexpression = null;
        boolean _matches = this.path.getValue().matches("[a-z][a-z0-9_.]*(/[a-z][a-z0-9_.]*)*");
        _xifexpression = _matches ? null : new Status(4, "Wizard", "'" + this.path + "' is not a valid package name");
        return _xifexpression;
    }

    public void generateProjects(IProjectGenerator generator) {
        PluginProjectFactory _pluginProjectFactory = new PluginProjectFactory();
        Procedures.Procedure1 _function = it -> {
            boolean _value_3;
            boolean _value_2;
            it.setProjectName(this.getProjectInfo().getProjectName());
            it.setLocation(this.getProjectInfo().getLocationPath());
            List _projectNatures = it.getProjectNatures();
            Iterables.addAll((Collection)_projectNatures, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.xtext.ui.shared.xtextNature"})));
            List _projectNatures_1 = it.getProjectNatures();
            Iterables.addAll((Collection)_projectNatures_1, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.etsi.mts.tdl.nature"})));
            List _builderIds = it.getBuilderIds();
            Iterables.addAll((Collection)_builderIds, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.xtext.ui.shared.xtextBuilder"})));
            boolean _value = this.extendedNature.getValue();
            if (_value) {
                List _projectNatures_2 = it.getProjectNatures();
                Iterables.addAll((Collection)_projectNatures_2, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"})));
                List _builderIds_1 = it.getBuilderIds();
                Iterables.addAll((Collection)_builderIds_1, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.jdt.core.javabuilder"})));
            }
            List _folders = it.getFolders();
            _folders.add("src");
            it.addRequiredBundles(List.of("org.etsi.mts.tdl.tx.ui"));
            String imports = "";
            boolean _value_1 = this.importStandard.getValue();
            if (_value_1) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("src/");
                _builder.append((Object)this.path);
                _builder.append("/TDL.tdltx");
                this.addFile((ProjectFactory)it, (CharSequence)_builder, TemplateHelper.getLibrary("TDL"));
                String _imports = imports;
                imports = String.valueOf(_imports) + "Import all from TDL\n";
            }
            if (_value_2 = this.importHTTP.getValue()) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("src/");
                _builder_1.append((Object)this.path);
                _builder_1.append("/HTTP.tdltx");
                this.addFile((ProjectFactory)it, (CharSequence)_builder_1, TemplateHelper.getLibrary("HTTP"));
                String _imports_1 = imports;
                String _imports_2 = imports = String.valueOf(_imports_1) + "Import all from HTTP\n";
                imports = String.valueOf(_imports_2) + "Import all from HTTP.MessageBased\n";
            }
            if (_value_3 = this.importJava.getValue()) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("src/");
                _builder_2.append((Object)this.path);
                _builder_2.append("/Java.tdltx");
                this.addFile((ProjectFactory)it, (CharSequence)_builder_2, TemplateHelper.getLibrary("Java"));
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("src/");
                _builder_3.append((Object)this.path);
                _builder_3.append("/TdlRuntime.tdltx");
                this.addFile((ProjectFactory)it, (CharSequence)_builder_3, TemplateHelper.getLibrary("TdlRuntime"));
                boolean _value_4 = this.importHTTP.getValue();
                if (_value_4) {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("src/");
                    _builder_4.append((Object)this.path);
                    _builder_4.append("/HttpJavaMappings.tdltx");
                    this.addFile((ProjectFactory)it, (CharSequence)_builder_4, TemplateHelper.getLibrary("HttpJavaMappings"));
                    String _imports_3 = imports;
                    imports = String.valueOf(_imports_3) + "Import all from HttpJavaMappings\n";
                }
                String _imports_4 = imports;
                imports = String.valueOf(_imports_4) + "Import all from Java\n";
            }
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("src/");
            _builder_5.append((Object)this.path);
            _builder_5.append("/");
            _builder_5.append((Object)this.name);
            _builder_5.append(".tdltx");
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append("/*");
            _builder_6.newLine();
            _builder_6.append(" ");
            _builder_6.append("* This is an example package");
            _builder_6.newLine();
            _builder_6.append(" ");
            _builder_6.append("*/");
            _builder_6.newLine();
            _builder_6.append("Package ");
            _builder_6.append((Object)this.name);
            _builder_6.append(" {");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("\t");
            _builder_6.append(imports, "\t");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("}");
            _builder_6.newLine();
            this.addFile((ProjectFactory)it, (CharSequence)_builder_5, (CharSequence)_builder_6);
        };
        PluginProjectFactory _doubleArrow = (PluginProjectFactory)ObjectExtensions.operator_doubleArrow((Object)_pluginProjectFactory, (Procedures.Procedure1)_function);
        generator.generate((ProjectFactory)_doubleArrow);
        String _projectName = this.getProjectInfo().getProjectName();
        String _plus = String.valueOf(_projectName) + "/src/";
        String _plus_1 = String.valueOf(_plus) + this.path;
        String _plus_2 = String.valueOf(_plus_1) + "/";
        String _plus_3 = String.valueOf(_plus_2) + this.name;
        String _plus_4 = String.valueOf(_plus_3) + ".tdltx";
        this.open(_plus_4);
    }

    private void open(String filePath) {
        Path path = new Path(filePath);
        final IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        final IWorkbenchPage page = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage();
        Display _default = Display.getDefault();
        _default.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)ifile);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        });
    }

    protected List<Pair<String, Image>> getImages() {
        Pair<String, Image> _image = this.image("project_template.png");
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_image}));
    }

    private Pair<String, Image> image(String id) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("platform:/plugin/");
        _builder.append("org.etsi.mts.tdl.tx.ui");
        _builder.append("/");
        _builder.append(id);
        Image _image = this.pluginImageHelper.getImage(_builder.toString());
        return Pair.of((Object)id, (Object)_image);
    }
}

