/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.importers.ui.handlers;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.etsi.mts.tdl.openapi2tdl.next.doc.Doc;

public class DocumentationHandler
extends AbstractHandler {
    private IWorkbenchWindow window;

    public DocumentationHandler() {
        this.init();
    }

    private void init() {
    }

    private void loadTargetFormat(String bundleName, String label, String extension) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Object firstElement;
        this.init();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEditorInput input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        IFile file = null;
        if (input != null && input instanceof FileEditorInput && ((FileEditorInput)input).getFile().getName().endsWith("yaml")) {
            file = ((FileEditorInput)input).getFile();
        } else if (selection != null && selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            file = (IFile)firstElement;
        }
        if (file != null) {
            String filepath = file.getLocation().toFile().getAbsolutePath();
            Doc doc = new Doc();
            try {
                doc.processModel(filepath, true);
                Files.writeString(Path.of(String.valueOf(filepath) + "-RQ-ICS-TSS.md", new String[0]), (CharSequence)doc.getContent(), new OpenOption[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showErrorDialog(e);
            }
        }
        return null;
    }

    private void showErrorDialog(Exception e) {
        MessageDialog errorDialog = new MessageDialog(Display.getDefault().getActiveShell(), "Translation error...", null, "An error occurred during the documentation generation. It may be due to problems occurring while processing the input, e.g if the input could not be processed. See details for a more technical description:\n\n" + e.getMessage(), 1, 0, new String[]{"OK"});
        errorDialog.open();
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public boolean isEnabled() {
        return true;
    }
}

