/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.execution.java.codegen;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.etsi.mts.tdl.Action;
import org.etsi.mts.tdl.ActionBehaviour;
import org.etsi.mts.tdl.ActionReference;
import org.etsi.mts.tdl.AlternativeBehaviour;
import org.etsi.mts.tdl.Annotation;
import org.etsi.mts.tdl.Assertion;
import org.etsi.mts.tdl.Assignment;
import org.etsi.mts.tdl.AtomicBehaviour;
import org.etsi.mts.tdl.Behaviour;
import org.etsi.mts.tdl.Block;
import org.etsi.mts.tdl.BoundedLoopBehaviour;
import org.etsi.mts.tdl.Break;
import org.etsi.mts.tdl.CastDataUse;
import org.etsi.mts.tdl.CollectionDataType;
import org.etsi.mts.tdl.CombinedBehaviour;
import org.etsi.mts.tdl.ComponentInstance;
import org.etsi.mts.tdl.ComponentInstanceRole;
import org.etsi.mts.tdl.ComponentType;
import org.etsi.mts.tdl.CompoundBehaviour;
import org.etsi.mts.tdl.ConditionalBehaviour;
import org.etsi.mts.tdl.DataElementMapping;
import org.etsi.mts.tdl.DataElementUse;
import org.etsi.mts.tdl.DataInstance;
import org.etsi.mts.tdl.DataInstanceUse;
import org.etsi.mts.tdl.DataResourceMapping;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.DataUse;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.ExceptionalBehaviour;
import org.etsi.mts.tdl.FormalParameter;
import org.etsi.mts.tdl.Function;
import org.etsi.mts.tdl.FunctionCall;
import org.etsi.mts.tdl.GateReference;
import org.etsi.mts.tdl.InlineAction;
import org.etsi.mts.tdl.Interaction;
import org.etsi.mts.tdl.InterruptBehaviour;
import org.etsi.mts.tdl.LiteralValueUse;
import org.etsi.mts.tdl.LocalExpression;
import org.etsi.mts.tdl.MappableDataElement;
import org.etsi.mts.tdl.Member;
import org.etsi.mts.tdl.MemberAssignment;
import org.etsi.mts.tdl.MemberReference;
import org.etsi.mts.tdl.Message;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.OptionalBehaviour;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.PackageableElement;
import org.etsi.mts.tdl.ParallelBehaviour;
import org.etsi.mts.tdl.Parameter;
import org.etsi.mts.tdl.ParameterBinding;
import org.etsi.mts.tdl.ParameterKind;
import org.etsi.mts.tdl.ParameterMapping;
import org.etsi.mts.tdl.PeriodicBehaviour;
import org.etsi.mts.tdl.PredefinedFunction;
import org.etsi.mts.tdl.PredefinedFunctionCall;
import org.etsi.mts.tdl.ProcedureCall;
import org.etsi.mts.tdl.ProcedureParameter;
import org.etsi.mts.tdl.ProcedureSignature;
import org.etsi.mts.tdl.Quiescence;
import org.etsi.mts.tdl.SingleCombinedBehaviour;
import org.etsi.mts.tdl.SpecialValueUse;
import org.etsi.mts.tdl.Stop;
import org.etsi.mts.tdl.StructuredDataInstance;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.Target;
import org.etsi.mts.tdl.TestConfiguration;
import org.etsi.mts.tdl.TestDescription;
import org.etsi.mts.tdl.TestDescriptionReference;
import org.etsi.mts.tdl.TestObjective;
import org.etsi.mts.tdl.Time;
import org.etsi.mts.tdl.TimeConstraint;
import org.etsi.mts.tdl.TimeLabel;
import org.etsi.mts.tdl.TimeLabelUse;
import org.etsi.mts.tdl.TimeOperation;
import org.etsi.mts.tdl.TimeOut;
import org.etsi.mts.tdl.Timer;
import org.etsi.mts.tdl.TimerOperation;
import org.etsi.mts.tdl.TimerStart;
import org.etsi.mts.tdl.TimerStop;
import org.etsi.mts.tdl.UnboundedLoopBehaviour;
import org.etsi.mts.tdl.ValueAssignment;
import org.etsi.mts.tdl.Variable;
import org.etsi.mts.tdl.VariableUse;
import org.etsi.mts.tdl.VerdictAssignment;
import org.etsi.mts.tdl.Wait;
import org.etsi.mts.tdl.execution.java.codegen.Reference;
import org.etsi.mts.tdl.execution.java.codegen.Renderer;
import org.etsi.mts.tdl.execution.java.codegen.Settings;

public class JUnitTestGenerator
extends Renderer {
    public static final String PACKAGE_PREFIX = "org.etsi.mts.tdl.execution.java";
    public static final String CORE_PACKAGE = "org.etsi.mts.tdl.execution.java.rt.core";
    public static final String TRI_PACKAGE = "org.etsi.mts.tdl.execution.java.tri";
    public static final String TESTER_CLASS = "TestControl";
    public static final String FUNCTIONS_FIELD = "functions";
    public static final String SYSTEM_ADAPTER_FIELD = "systemAdapter";
    public static final String VALIDATOR_FIELD = "validator";
    public static final String REPORTER_FIELD = "reporter";
    public static final String HELPER_FIELD = "runtimeHelper";
    public static final String COMPONENT_CLASS_SUFFIX = "_Component";
    public static final String ASSERTION_EXCEPTION = "junit.framework.AssertionFailedError";
    public static final String FUTURE_EXECUTION_EXCEPTION = "java.util.concurrent.ExecutionException";
    public static final String INTERRUPTED_EXCEPTION = "InterruptedException";
    public static final String BREAK_EXCEPTION = "BreakException";
    public static final String STOP_EXCEPTION = "StopException";
    public static final String LANGUAGE_KEY = "Language";
    public static final String JAVA_LANGUAGE_VALUE = "Java";
    public static final String MAPPING_KEY = "MappingName";
    public static final String JAVA_MAPPING_VALUE = "Java";
    public static final String MAPPING_ANNOTATION_PREFIX = "Java";
    public static final String MAPPING_ANNOTATION_PACKAGE = "JavaPackage";
    public static final String MAPPING_ANNOTATION_METHOD = "JavaMethod";
    public static final String MAPPING_ANNOTATION_STATIC_METHOD = "JavaStaticMethod";
    public static final String MAPPING_ANNOTATION_CLASS = "JavaClass";
    public static final String MAPPING_ANNOTATION_FIELD = "JavaField";
    public static final String MAPPING_ANNOTATION_STATIC_FIELD = "JavaStaticField";
    public static final String MAPPING_ANNOTATION_GETTER = "JavaGetter";
    public static final String MAPPING_ANNOTATION_SETTER = "JavaSetter";
    private Package model;
    private Settings settings;
    private String guiceModule;
    private boolean logEvents = true;
    protected Map<MappableDataElement, Set<DataElementMapping>> elementMappings = new Hashtable<MappableDataElement, Set<DataElementMapping>>();
    protected Map<Element, String> classNames = new Hashtable<Element, String>();
    private ComponentInstance currentTester = null;
    private Map<DataType, String> declaredTypes = new Hashtable<DataType, String>();

    public JUnitTestGenerator(Package model, Settings settings) {
        super(settings.outputFile, settings.outPackage);
        this.model = model;
        this.settings = settings;
        this.guiceModule = settings.injector;
        if (this.guiceModule == "") {
            throw new RuntimeException("Guice module must be configured in settings.");
        }
    }

    public void generate() throws IOException {
        this.render();
    }

    public void render() throws IOException {
        this.resolveMappings(this.model);
        ArrayList tdList = new ArrayList();
        this.gatherPackageableElements(this.model, false, e -> {
            if (e instanceof TestDescription && ((TestDescription)e).isIsLocallyOrdered()) {
                tdList.add((TestDescription)e);
            }
        });
        Set configurations = tdList.stream().map(td -> td.getTestConfiguration()).collect(Collectors.toSet());
        for (TestConfiguration tc : configurations) {
            this.renderTestConfiguration(tc);
        }
        for (TestDescription td2 : tdList) {
            this.renderTestCase(td2);
        }
    }

    protected void resolveMappings(Package model) {
        this.gatherPackageableElements(model, true, e -> {
            if (e instanceof DataElementMapping) {
                MappableDataElement el = ((DataElementMapping)e).getMappableDataElement();
                Set<DataElementMapping> mappings = this.elementMappings.get(el);
                if (mappings == null) {
                    mappings = new HashSet<DataElementMapping>();
                    this.elementMappings.put(el, mappings);
                }
                mappings.add((DataElementMapping)e);
            }
        });
    }

    @Override
    protected DataElementMapping getMapping(MappableDataElement e) {
        return this.getMapping(e, "Java");
    }

    protected DataElementMapping getMapping(MappableDataElement e, String mappingName) {
        Set<DataElementMapping> mappings = this.elementMappings.get(e);
        if (mappings != null && !mappings.isEmpty()) {
            for (DataElementMapping m : mappings) {
                if (!m.getDataResourceMapping().getAnnotation().stream().anyMatch(a -> a.getKey().getName().equals(MAPPING_KEY) && a.getValue().equalsIgnoreCase(mappingName))) continue;
                return m;
            }
        }
        return null;
    }

    protected DataElementMapping getMappingChecked(MappableDataElement e) {
        DataElementMapping m = this.getMapping(e);
        if (m != null) {
            return m;
        }
        throw new RuntimeException("Mapping missing for " + e.getQualifiedName());
    }

    private String getParameterMappingUri(Parameter p) {
        ParameterMapping pm = this.getParameterMapping(p);
        if (pm != null) {
            return pm.getParameterURI();
        }
        return null;
    }

    private ParameterMapping getParameterMapping(Parameter p) {
        DataElementMapping typeMapping = this.getMapping((MappableDataElement)p.container());
        if (typeMapping != null) {
            for (ParameterMapping pm : typeMapping.getParameterMapping()) {
                if (!pm.getParameter().equals(p)) continue;
                return pm;
            }
        }
        return null;
    }

    private boolean isUnmapped() {
        return this.settings.unmappedData;
    }

    @Override
    protected String getElementName(Element e) {
        if (this.isUnmapped() && e instanceof DataType) {
            return "org.etsi.mts.tdl.execution.java.rt.core.ValueImpl";
        }
        return super.getElementName(e);
    }

    private boolean hasAnnotation(Element e, String keyName) {
        return e.getAnnotation().stream().anyMatch(a -> a.getKey().getName().equals(keyName));
    }

    private Annotation getAnnotation(Element e, String keyName) {
        Optional<Annotation> op = e.getAnnotation().stream().filter(a -> a.getKey().getName().equals(keyName)).findAny();
        if (op.isPresent()) {
            return op.get();
        }
        return null;
    }

    private boolean isVerdict(DataType t) {
        return t.getQualifiedName().equals("TDL::Verdict");
    }

    protected void addImport(DataElementMapping m, Set<String> imports) {
        if (m == null) {
            return;
        }
        MappableDataElement e = m.getMappableDataElement();
        if (e instanceof DataType) {
            DataResourceMapping resource = m.getDataResourceMapping();
            boolean resourceIsClass = this.hasAnnotation((Element)resource, MAPPING_ANNOTATION_CLASS);
            if (resourceIsClass) {
                imports.add(resource.getResourceURI());
                return;
            }
            boolean isPackage = this.hasAnnotation((Element)resource, MAPPING_ANNOTATION_PACKAGE);
            if (!isPackage) {
                throw new RuntimeException("Unsupported resource mapping: " + resource.getQualifiedName());
            }
            boolean isClass = this.hasAnnotation((Element)m, MAPPING_ANNOTATION_CLASS);
            if (isClass) {
                String classQName = m.getElementURI();
                if (classQName.startsWith("java.")) {
                    imports.add(classQName);
                } else {
                    imports.add(String.valueOf(resource.getResourceURI()) + "." + classQName);
                }
            }
        }
    }

    private String getPackagefullName(Package p) {
        String packageName = this.getElementName((Element)p);
        while ((p = (Package)p.container()) != null) {
            packageName = String.valueOf(this.getElementName((Element)p)) + "." + packageName;
        }
        packageName = packageName.toLowerCase();
        if (this.getRootPackageName() != null && this.getRootPackageName().length() > 0) {
            packageName = String.valueOf(this.getRootPackageName()) + "." + packageName;
        }
        return packageName;
    }

    private void renderTestConfiguration(TestConfiguration tc) throws IOException {
        Package p = (Package)tc.container();
        String packageName = this.getPackagefullName(p);
        Set testerTypes = tc.getComponentInstance().stream().filter(c -> c.getRole() == ComponentInstanceRole.TESTER).map(c -> c.getType()).collect(Collectors.toSet());
        String fPackageName = packageName;
        for (ComponentType ct : testerTypes) {
            String className = String.valueOf(this.getElementName((Element)ct)) + COMPONENT_CLASS_SUFFIX;
            this.writeClassFile(packageName, className, () -> this.renderComponentTypeClass(fPackageName, tc, ct));
        }
    }

    private void renderComponentTypeClass(String packageName, TestConfiguration tc, ComponentType ct) {
        String className = String.valueOf(this.getElementName((Element)ct)) + COMPONENT_CLASS_SUFFIX;
        this.classNames.put((Element)ct, String.valueOf(packageName) + "." + className);
        this.line("package " + packageName + ";");
        this.newLine();
        HashSet<String> imports = new HashSet<String>();
        this.gatherImports(imports);
        this.gatherImports((Element)ct, imports);
        this.writeImports(imports);
        this.append("public class " + className + " extends " + TESTER_CLASS);
        this.blockOpen();
        this.newLine();
        this.writeComponentType(tc, ct, className);
        this.blockClose();
    }

    private void writeComponentType(TestConfiguration tc, ComponentType ct, String className) {
        ct.getVariable().forEach(v -> {
            this.append("public " + this.getElementName((Element)v.getDataType()) + " " + this.getElementName((Element)v));
            if (this.isUnmapped()) {
                this.append(" = new ");
                this.append("org.etsi.mts.tdl.execution.java.rt.core.ValueImpl");
                this.append("();");
            }
            this.line(";");
        });
        this.newLine();
        ct.getTimer().forEach(t -> {
            String timerClass = "org.etsi.mts.tdl.execution.java.rt.core.Timer ";
            this.line("public " + timerClass + this.getTimerName((Timer)t) + " = new " + timerClass + "(TimeUnit.Second" + ", \"" + t.getName() + "\", \"" + t.getQualifiedName() + "\");");
        });
        this.newLine();
        this.append("protected " + className + "()");
        this.blockOpen();
        this.append("super(");
        this.append("new ");
        this.append(this.settings.injector);
        this.append("()");
        this.line(");");
        this.blockClose();
    }

    private String getTimerName(Timer t) {
        String timerNameSuffix = "_t";
        return String.valueOf(this.getElementName((Element)t)) + timerNameSuffix;
    }

    private String getTimeLabelName(TimeLabel label) {
        AtomicBehaviour b = (AtomicBehaviour)label.container();
        String labelNameSuffix = "_tl";
        return String.valueOf(this.getElementName((Element)b)) + labelNameSuffix;
    }

    private void renderTestCase(TestDescription td) throws IOException {
        String packageName;
        Package p = (Package)td.container();
        String fPackageName = packageName = this.getPackagefullName(p);
        ArrayList ex = new ArrayList();
        List<ComponentInstance> testers = td.getTestConfiguration().getComponentInstance().stream().filter(c -> c.getRole() == ComponentInstanceRole.TESTER).collect(Collectors.toList());
        testers.forEach(tester -> {
            String className = this.getElementName((Element)td);
            if (testers.size() > 1) {
                className = String.valueOf(className) + "_" + this.getElementName((Element)tester);
            }
            try {
                this.currentTester = tester;
                String fClassName = className;
                this.writeClassFile(packageName, className, () -> this.renderTestDescriptionClass(fPackageName, fClassName, td, (ComponentInstance)tester));
            }
            catch (IOException e) {
                ex.add(e);
                return;
            }
        });
        if (!ex.isEmpty()) {
            throw (IOException)ex.get(0);
        }
    }

    private void renderTestDescriptionClass(String packageName, String className, TestDescription td, ComponentInstance tester) {
        this.line("package " + packageName + ";");
        this.newLine();
        HashSet<String> imports = new HashSet<String>();
        this.gatherImports(imports);
        this.gatherImports((Element)td, imports);
        this.writeImports(imports);
        String componentClassName = this.classNames.get(tester.getType());
        this.line("@TestInstance(TestInstance.Lifecycle.PER_CLASS)");
        this.append("public class " + className + " extends " + componentClassName);
        this.blockOpen();
        this.newLine();
        td.eAllContents().forEachRemaining(e -> {
            if (e instanceof TimeLabel) {
                String name = this.getTimeLabelName((TimeLabel)e);
                this.line("private TimeLabel " + name + " = new TimeLabel();");
            }
        });
        this.newLine();
        this.writeTestConfiguration(td);
        this.newLine();
        this.writeTypes(td);
        this.newLine();
        this.writeTestDescription(td);
        this.blockClose();
    }

    protected void gatherPackageableElements(Package p, boolean includeImports, PackageableElementAcceptor a) {
        this.gatherPackageableElements(p, includeImports, a, new HashSet<Package>());
    }

    private void gatherPackageableElements(Package p, boolean includeImports, PackageableElementAcceptor a, Set<Package> scanned) {
        if (scanned.contains(p)) {
            return;
        }
        scanned.add(p);
        p.getPackagedElement().forEach(a::accept);
        if (includeImports) {
            p.getImport().forEach(i -> {
                EList ie = i.getImportedElement();
                if (ie.isEmpty()) {
                    this.gatherPackageableElements(i.getImportedPackage(), includeImports, a, scanned);
                } else {
                    ie.forEach(a::accept);
                }
            });
        }
        p.getNestedPackage().forEach(np -> this.gatherPackageableElements((Package)np, includeImports, a, scanned));
    }

    protected void gatherImports(Set<String> imports) {
        imports.add("org.junit.jupiter.api.*");
        imports.add("com.google.inject.*");
        imports.add("javax.inject.*");
        imports.add("java.util.concurrent.Future");
        imports.add("java.util.List");
        imports.add("org.etsi.mts.tdl.execution.java.tri.*");
        imports.add("org.etsi.mts.tdl.execution.java.rt.core.*");
    }

    protected void gatherImports(Element el, Set<String> imports) {
        this.elementMappings.keySet().forEach(e -> this.addImport(this.getMapping((MappableDataElement)e), imports));
    }

    private void writeTestConfiguration(TestDescription tc) {
        TestConfiguration config = tc.getTestConfiguration();
        this.line("@BeforeAll");
        this.append("public void configure_" + this.getElementName((Element)tc) + "()");
        this.blockOpen();
        ArrayList connectionNames = new ArrayList();
        config.getConnection().forEach(conn -> {
            String connectionName = this.getElementName((Element)conn);
            connectionNames.add(connectionName);
            EList endpoints = conn.getEndPoint();
            this.append("Connection " + connectionName + " = new ConnectionImpl");
            this.callOpen();
            this.line("\"" + conn.getName() + "\", ");
            this.writeGateReference((GateReference)endpoints.get(0));
            this.line(", ");
            this.writeGateReference((GateReference)endpoints.get(1));
            this.callClose();
        });
        this.append("configure(new Connection[] {");
        boolean first = true;
        for (String cn : connectionNames) {
            if (!first) {
                this.append(", ");
            }
            first = false;
            this.append(cn);
        }
        this.line("});");
        this.blockClose();
        this.newLine();
    }

    private void writeGateReference(GateReference e) {
        this.append("new GateReferenceImpl(");
        this.writeElement((Element)e.getGate());
        this.append(", ");
        this.writeElement((Element)e.getGate().getType());
        this.append(", ");
        this.append("GateTypeKind." + e.getGate().getType().getKind());
        this.append(", ");
        this.writeElement((Element)e.getComponent());
        this.append(", ");
        this.writeElement((Element)e.getComponent().getType());
        this.append(", ");
        this.append("ComponentInstanceRole." + e.getComponent().getRole());
        this.append(")");
    }

    private void writeGetConnection(GateReference tester, GateReference remote) {
        this.append("getConnection(\"" + tester.getComponent().getName() + "\", \"" + tester.getGate().getName() + "\", \"" + remote.getComponent().getName() + "\", \"" + remote.getGate().getName() + "\")");
    }

    private void writeGetGateReference(GateReference tester) {
        this.append("getGateReference(\"" + tester.getComponent().getName() + "\", \"" + tester.getGate().getName() + "\")");
    }

    private void writeTypes(TestDescription tc) {
        if (!this.isUnmapped()) {
            return;
        }
        this.append("protected void declareTypes()");
        this.blockOpen();
        TreeIterator i = tc.eAllContents();
        while (i.hasNext()) {
            EObject e = (EObject)i.next();
            if (e instanceof DataUse) {
                DataType type = ((DataUse)e).resolveDataType();
                if (type == null) continue;
                this.declareType(type, this.declaredTypes);
                continue;
            }
            if (!(e instanceof Variable)) continue;
            this.declareType(((Variable)e).getDataType(), this.declaredTypes);
        }
        this.blockClose();
        this.newLine();
    }

    private String declareType(DataType t, Map<DataType, String> declaredTypes) {
        if (declaredTypes.containsKey(t)) {
            return declaredTypes.get(t);
        }
        String name = super.getElementName((Element)t);
        declaredTypes.put(t, name);
        if (t instanceof StructuredDataType) {
            for (Member m : ((StructuredDataType)t).allMembers()) {
                DataType mType = m.getDataType();
                this.declareType(mType, declaredTypes);
            }
        } else if (t instanceof CollectionDataType) {
            DataType iType = ((CollectionDataType)t).getItemType();
            this.declareType(iType, declaredTypes);
        }
        DataElementMapping mapping = this.getMapping((MappableDataElement)t);
        if (mapping == null) {
            mapping = this.getMapping((MappableDataElement)t, this.settings.useMapping);
        }
        String mappingName = String.valueOf(name) + "_mapping";
        if (mapping != null) {
            this.writeMapping(mapping, mappingName, false);
        }
        this.line("org.etsi.mts.tdl.execution.java.rt.core.TypeImpl " + name + " = new " + CORE_PACKAGE + ".TypeImpl()");
        this.writeSetName((NamedElement)t);
        this.writeAddAnnotations((Element)t);
        if (mapping != null) {
            this.line(".setMapping(" + mappingName + ")");
        }
        if (t instanceof StructuredDataType) {
            this.line(".setIsStructure(true)");
            for (Member m : ((StructuredDataType)t).allMembers()) {
                String mTypeName = declaredTypes.get(m.getDataType());
                this.line(".setParameter(\"" + m.getName() + "\", " + mTypeName + ")");
            }
        } else if (t instanceof CollectionDataType) {
            this.line(".setIsCollection(true)");
            String iTypeName = declaredTypes.get(((CollectionDataType)t).getItemType());
            this.line(".setItemType(" + iTypeName + ")");
        }
        this.line(";");
        this.line("addType(\"" + name + "\", " + name + ");");
        return name;
    }

    private void writeMapping(DataElementMapping mapping, String mappingVarName, boolean inline) {
        String name;
        Annotation nameAnnotation = this.getAnnotation((Element)mapping.getDataResourceMapping(), MAPPING_KEY);
        String string = name = nameAnnotation != null ? nameAnnotation.getValue() : null;
        if (!inline) {
            this.append("org.etsi.mts.tdl.execution.java.rt.core.MappingImpl " + mappingVarName + " = ");
        }
        this.append("new org.etsi.mts.tdl.execution.java.rt.core.MappingImpl(");
        this.append("\"" + name + "\", ");
        String uri = mapping.getElementURI().replaceAll("\\n|\\r", " ").replaceAll("\\\\", "_");
        this.append("\"" + uri + "\"");
        this.line(")");
        DataResourceMapping rsMapping = mapping.getDataResourceMapping();
        this.append(".setResource");
        this.blockOpenParen();
        this.line("new org.etsi.mts.tdl.execution.java.rt.core.MappingImpl(\"" + name + "\", \"" + rsMapping.getResourceURI() + "\")");
        this.line(".setIsResource(true)");
        this.writeAddAnnotations((Element)rsMapping);
        this.blockCloseParen();
        for (ParameterMapping pMapping : mapping.getParameterMapping()) {
            String pName = pMapping.getParameter().getName();
            this.append(".setParameter");
            this.blockOpenParen();
            this.line("\"" + pName + "\", ");
            this.line("new org.etsi.mts.tdl.execution.java.rt.core.MappingImpl(\"" + name + "\", \"" + pMapping.getParameterURI() + "\")");
            this.line(".setIsParameter(true)");
            this.writeAddAnnotations((Element)pMapping);
            this.blockCloseParen();
        }
        if (!inline) {
            this.line(";");
        }
    }

    private void writeSetName(NamedElement e) {
        this.line(".setName(\"" + e.getName() + "\", \"" + e.getQualifiedName() + "\")");
    }

    private void writeAddAnnotations(Element e) {
        for (Annotation a : e.getAnnotation()) {
            String value = a.getValue();
            this.line(".addAnnotation(\"" + a.getKey().getQualifiedName() + "\", " + (value != null ? "\"" + a.getValue() + "\"" : "null") + ")");
        }
    }

    private void writeElement(Element e) {
        if (e instanceof NamedElement) {
            this.append("new NamedElementImpl(\"" + e.getName() + "\", \"" + ((NamedElement)e).getQualifiedName() + "\")");
        } else {
            this.append("new ElementImpl(\"" + e.getName() + "\")");
        }
    }

    private void writeTestDescription(TestDescription tc) {
        for (TestObjective to : tc.getTestObjective()) {
            this.line("/**");
            String toDesc = to.getDescription();
            if (toDesc != null && toDesc.length() > 0) {
                this.line(" * " + toDesc);
            }
            this.line("*/");
        }
        this.line("@Test");
        this.append("public void test_" + this.getElementName((Element)tc) + "()");
        this.blockOpen();
        this.newLine();
        this.append("try");
        this.blockOpen();
        HashSet<String> thrownExceptions = new HashSet<String>();
        this.write(tc.getBehaviourDescription().getBehaviour(), null, null, thrownExceptions);
        this.blockClose();
        if (!thrownExceptions.isEmpty()) {
            for (String ex : thrownExceptions) {
                this.append("catch (" + ex + " e)");
                this.blockOpen();
                if (ex.equals(STOP_EXCEPTION)) {
                    this.append("if (e.getVerdict() != null)");
                    this.blockOpen();
                    this.line("validator.setVerdict(e.getVerdict());");
                    this.blockClose();
                }
                this.line("throw new junit.framework.AssertionFailedError(e.getMessage());");
                this.blockClose();
            }
        }
        this.append("catch (RuntimeException e)");
        this.blockOpen();
        this.line("reporter.runtimeError(e);");
        this.line("throw e;");
        this.blockClose();
        this.blockClose();
        this.newLine();
    }

    private void write(Behaviour b, Map<DataUse, String> dataUseVariables, List<FutureInfo> futures, Set<String> thrownExceptions) {
        this.lineComment(b.eClass().getName());
        this.writeComment((Element)b);
        this.writeNotification(b, true);
        if (!(b instanceof CompoundBehaviour) && dataUseVariables == null) {
            throw new RuntimeException();
        }
        ArrayList<FutureInfo> myFutures = new ArrayList<FutureInfo>();
        boolean writeAfter = true;
        ArrayList<String> exceptionalBehaviours = new ArrayList<String>();
        if (b instanceof AtomicBehaviour) {
            FutureInfo futureInfo;
            DataUse verdict;
            VariableUse v;
            ComponentInstance c;
            if (b instanceof ActionBehaviour ? (c = ((ActionBehaviour)b).getComponentInstance()) != null && !this.isCurrentComponentInstance(c) : (b instanceof TimerOperation ? (c = ((TimerOperation)b).getComponentInstance()) != null && !this.isCurrentComponentInstance(c) : b instanceof Assignment && !this.isCurrentComponentInstance((v = ((Assignment)b).getVariable()).getComponentInstance()))) {
                return;
            }
            TimeLabel timeLabel = ((AtomicBehaviour)b).getTimeLabel();
            if (timeLabel != null) {
                String labelName = this.getTimeLabelName(timeLabel);
                this.line(String.valueOf(labelName) + ".timestamp();");
            }
            for (TimeConstraint tc : ((AtomicBehaviour)b).getTimeConstraint()) {
                FutureInfo futureInfo2 = this.declareFuture(b, tc, dataUseVariables);
                if (!this.isTesterInput(b)) {
                    this.line(String.valueOf(futureInfo2.varName) + ".get();");
                    continue;
                }
                myFutures.add(futureInfo2);
            }
            if (b instanceof ActionReference) {
                Action action = ((ActionReference)b).getAction();
                DataElementMapping mapping = this.getMapping((MappableDataElement)action);
                if (mapping == null || !this.hasAnnotation((Element)mapping, MAPPING_ANNOTATION_STATIC_METHOD) && !this.hasAnnotation((Element)mapping, MAPPING_ANNOTATION_METHOD)) {
                    throw new RuntimeException("No supported mapping for action: " + action.getQualifiedName());
                }
                for (ParameterBinding arg : ((ActionReference)b).getArgument()) {
                    this.initializeDataUse(arg.getDataUse(), dataUseVariables);
                }
                String mappingPrefix = mapping.getDataResourceMapping().getResourceURI();
                if (mappingPrefix.length() > 0) {
                    this.append(String.valueOf(mappingPrefix) + ".");
                }
                this.append(this.getElementName((Element)action));
                if (!((ActionReference)b).getArgument().isEmpty()) {
                    this.append("(");
                    boolean first = true;
                    for (ParameterBinding arg : ((ActionReference)b).getArgument()) {
                        this.write(arg.getDataUse(), dataUseVariables);
                        if (first) {
                            first = false;
                            continue;
                        }
                        this.append(", ");
                    }
                    this.line(");");
                }
            } else if (b instanceof InlineAction) {
                if (b.getAnnotation().stream().anyMatch(a -> a.getKey().getName().equals(LANGUAGE_KEY) && a.getValue().equals("Java"))) {
                    this.append(((InlineAction)b).getBody());
                    this.newLine();
                }
            } else if (b instanceof Assignment) {
                VariableUse v2 = ((Assignment)b).getVariable();
                this.initializeDataUse(((Assignment)b).getExpression(), dataUseVariables);
                this.append("this.");
                this.write((DataUse)v2, dataUseVariables);
                this.append(" = ");
                this.write(((Assignment)b).getExpression(), dataUseVariables);
                this.line(";");
            } else if (b instanceof Assertion) {
                this.initializeDataUse(((Assertion)b).getCondition(), dataUseVariables);
                verdict = ((Assertion)b).getOtherwise();
                if (verdict != null) {
                    this.initializeDataUse(verdict, dataUseVariables);
                }
                this.append("if (!(");
                this.write(((Assertion)b).getCondition(), dataUseVariables);
                this.append("))");
                this.blockOpen();
                this.append("validator.setVerdict(");
                if (verdict != null) {
                    this.write(((Assertion)b).getOtherwise(), dataUseVariables);
                } else {
                    this.append("Verdict.fail");
                }
                this.line(");");
                this.writeNotification(b, false);
                this.writeObjective(b);
                writeAfter = false;
                this.line("throw new junit.framework.AssertionFailedError(\"" + this.getMessage(b) + "\");");
                this.blockClose();
            } else if (b instanceof VerdictAssignment) {
                verdict = ((VerdictAssignment)b).getVerdict();
                this.initializeDataUse(verdict, dataUseVariables);
                this.append("validator.setVerdict(");
                this.write(verdict, dataUseVariables);
                this.line(");");
            } else if (b instanceof Break) {
                if (!(b.container() instanceof Block)) {
                    throw new RuntimeException("Break not contained in a Block " + this.getQName(b));
                }
                Block bl = (Block)((Break)b).container();
                this.writeNotification(b, false);
                this.writeObjective(b);
                writeAfter = false;
                this.line("throw new BreakException(\"" + this.getElementName((Element)bl) + "\");");
                thrownExceptions.add(BREAK_EXCEPTION);
            } else if (b instanceof Stop) {
                this.writeNotification(b, false);
                this.writeObjective(b);
                writeAfter = false;
                this.line("throw new StopExceptionImpl(\"Stop " + this.getQName(b) + "\");");
                thrownExceptions.add(STOP_EXCEPTION);
            } else if (b instanceof TimerStart) {
                DataUse period = ((TimerStart)b).getPeriod();
                Time timeType = this.resolveTimeType(period);
                this.initializeDataUse(period, dataUseVariables);
                this.append(String.valueOf(this.getTimerName(((TimerOperation)b).getTimer())) + ".start(");
                this.write(period, dataUseVariables);
                if (timeType != null) {
                    this.append(", TimeUnit." + timeType.getName());
                }
                this.line(");");
            } else if (b instanceof TimerStop) {
                this.append(String.valueOf(this.getTimerName(((TimerOperation)b).getTimer())) + ".stop();");
            } else if (b instanceof TimeOut) {
                futureInfo = this.writeTesterInput(b, dataUseVariables, true, true);
                myFutures.add(futureInfo);
            } else if (b instanceof Wait) {
                futureInfo = this.declareFuture(b, dataUseVariables, true);
                this.line(String.valueOf(futureInfo.varName) + ".get();");
            } else if (b instanceof Quiescence) {
                futureInfo = this.writeTesterInput(b, dataUseVariables, true, true);
                myFutures.add(futureInfo);
            } else if (b instanceof Message) {
                if (this.isTesterInput(b)) {
                    futureInfo = this.writeTesterInput(b, dataUseVariables, true, true);
                    myFutures.add(futureInfo);
                    thrownExceptions.add(INTERRUPTED_EXCEPTION);
                    thrownExceptions.add(FUTURE_EXECUTION_EXCEPTION);
                } else {
                    Message m = (Message)b;
                    DataUse arg = m.getArgument();
                    this.initializeDataUse(arg, dataUseVariables);
                    for (Target t2 : m.getTarget()) {
                        this.append("systemAdapter.send(");
                        this.convertToData(arg, dataUseVariables);
                        this.append(", ");
                        this.writeGetConnection(m.getSourceGate(), t2.getTargetGate());
                        this.line(");");
                    }
                }
            } else if (b instanceof ProcedureCall) {
                ProcedureCall pc = (ProcedureCall)b;
                boolean isCall = pc.getReplyTo() == null;
                boolean isTesterInput = this.isTesterInput(b);
                if (isCall && !isTesterInput) {
                    FutureInfo futureInfo3 = this.writeTesterInput(b, dataUseVariables, true, true);
                    myFutures.add(futureInfo3);
                }
            } else if (b instanceof TestDescriptionReference) {
                ((TestDescriptionReference)b).getTestDescription();
            }
            this.newLine();
        } else if (b instanceof CombinedBehaviour) {
            for (PeriodicBehaviour pb : ((CombinedBehaviour)b).getPeriodic()) {
                this.lineComment(String.valueOf(pb.eClass().getName()) + " not supported currently");
            }
            for (ExceptionalBehaviour eb2 : ((CombinedBehaviour)b).getExceptional()) {
                this.newLine();
                this.lineComment(eb2.eClass().getName());
                ComponentInstance gc = eb2.getGuardedComponent();
                if (gc != null && !this.isCurrentComponentInstance(gc)) continue;
                String exceptionalBehaviourName = this.getElementName((Element)eb2);
                this.append("ExceptionalBehaviour " + exceptionalBehaviourName + " = new ExceptionalBehaviour(");
                this.append(Boolean.toString(eb2 instanceof InterruptBehaviour));
                this.line(");");
                HashSet<String> innerExceptions = new HashSet<String>();
                this.write(eb2.getBlock(), exceptionalBehaviourName, null, innerExceptions);
                this.line("addExceptionalBehaviour(" + exceptionalBehaviourName + ");");
                this.newLine();
                exceptionalBehaviours.add(exceptionalBehaviourName);
            }
            if (b instanceof CompoundBehaviour) {
                this.write(((CompoundBehaviour)b).getBlock(), null, null, thrownExceptions);
            } else if (b instanceof BoundedLoopBehaviour) {
                Optional<LocalExpression> exp = ((BoundedLoopBehaviour)b).getNumIteration().stream().filter(l -> this.isCurrentComponentInstance(l.getComponentInstance())).findFirst();
                if (exp.isEmpty()) {
                    throw new RuntimeException("Appropriate local expression not provided for " + this.getMessage(b) + " on " + this.currentTester.getName());
                }
                DataUse d = exp.get().getExpression();
                this.initializeDataUse(d, dataUseVariables);
                String counterName = String.valueOf(this.getElementName((Element)b)) + "_counter";
                String counterType = "int";
                this.append("for (" + counterType + " " + counterName + " = 0; " + counterName + " < ");
                this.write(d, dataUseVariables);
                this.append("; " + counterName + "++)");
                this.blockOpen();
                this.write(((SingleCombinedBehaviour)b).getBlock(), null, null, thrownExceptions);
                this.blockClose();
            } else if (b instanceof UnboundedLoopBehaviour) {
                this.append("while (true)");
                this.blockOpen();
                this.write(((SingleCombinedBehaviour)b).getBlock(), null, null, thrownExceptions);
                this.blockClose();
            } else if (b instanceof OptionalBehaviour) {
                this.lineComment(String.valueOf(b.eClass().getName()) + " not supported currently");
            } else if (!(b instanceof AlternativeBehaviour)) {
                if (b instanceof ConditionalBehaviour) {
                    EList blocks = ((ConditionalBehaviour)b).getBlock();
                    boolean first = true;
                    for (Block block : blocks) {
                        if (!first) {
                            this.append(" else ");
                        }
                        first = false;
                        this.write(block, null, null, thrownExceptions);
                    }
                } else if (b instanceof ParallelBehaviour) {
                    this.lineComment(String.valueOf(b.eClass().getName()) + " not supported currently");
                }
            }
        }
        if (writeAfter) {
            this.writeNotification(b, false);
            this.writeObjective(b);
            this.newLine();
            exceptionalBehaviours.forEach(eb -> this.line("removeExceptionalBehaviour(" + eb + ");"));
        }
        if (futures == null) {
            if (!myFutures.isEmpty()) {
                String futureName = String.valueOf(this.getElementName((Element)b)) + "_future";
                this.line("Future<ExecutionResult> " + futureName + " = next();");
                this.append("try ");
                this.blockOpen();
                boolean first = true;
                for (FutureInfo f2 : myFutures) {
                    if (!first) {
                        this.append(" else ");
                    }
                    first = false;
                    this.append("if (" + f2.varName + " == " + futureName + ")");
                    this.blockOpen();
                    this.line(String.valueOf(f2.kind) + " result = (" + f2.kind + ")" + f2.varName + ".get();");
                    if (f2.kind.equals("InteractionResult")) {
                        Target localTarget = ((Interaction)b).getTarget().stream().filter(t -> this.isCurrentComponentInstance(t.getTargetGate().getComponent())).findFirst().get();
                        if (b instanceof Message) {
                            for (ValueAssignment va : localTarget.getValueAssignment()) {
                                this.lineComment("ValueAssignment");
                                Variable var = va.getVariable();
                                this.append(this.getElementName((Element)var));
                                this.append(" = ");
                                this.append("(" + this.getElementName((Element)var.getDataType()) + ")");
                                this.line("result.data.getValue();");
                            }
                        }
                    } else if (f2.kind.equals("TimeoutResult")) {
                        this.line("throw new StopExceptionImpl(\"Timeout\");");
                        thrownExceptions.add(STOP_EXCEPTION);
                    } else {
                        throw new RuntimeException("Unknown execution result kind: " + f2.kind);
                    }
                    this.blockClose();
                }
                this.line(" else ");
                this.blockOpen();
                this.append("ExceptionalBehaviour exceptionalBehaviour = getExceptionalBehaviour(");
                this.append(futureName);
                this.line(");");
                this.append("if (exceptionalBehaviour != null)");
                this.blockOpen();
                this.line("exceptionalBehaviour.behaviour.execute();");
                this.blockClose();
                this.blockClose();
                thrownExceptions.add(STOP_EXCEPTION);
                this.blockClose();
                this.append("finally ");
                this.blockOpen();
                myFutures.forEach(f -> {
                    this.line("stop(" + f.varName + ");");
                    if (f.hasExceptionals) {
                        this.append(f.varName);
                        this.line("_exceptionals.forEach(f -> stop(f));");
                    }
                });
                this.blockClose();
                this.newLine();
            }
        } else {
            futures.addAll(myFutures);
        }
    }

    private FutureInfo writeTesterInput(Behaviour b, Map<DataUse, String> dataUseVariables, boolean autoSubmit, boolean addExceptionals) {
        if (b instanceof TimeOut || b instanceof Quiescence || b instanceof Message || b instanceof ProcedureCall) {
            FutureInfo future = this.declareFuture(b, dataUseVariables, autoSubmit);
            if (addExceptionals) {
                future.hasExceptionals = true;
                this.append("List<Future<ExecutionResult>> ");
                this.append(future.varName);
                this.append("_exceptionals = ");
                this.line("executeExceptionals();");
            }
            return future;
        }
        throw new RuntimeException("Behaviour is not tester-input:" + this.getMessage(b));
    }

    private void write(Block bl, String exceptionalBehaviourName, List<FutureInfo> futures, Set<String> thrownExceptions) {
        this.append("try");
        this.blockOpen();
        Hashtable<DataUse, String> dataUseVariables = new Hashtable<DataUse, String>();
        this.declareDataUses((Element)bl, dataUseVariables, "");
        this.newLine();
        this.writeComment((Element)bl);
        Optional<LocalExpression> guard = bl.getGuard().stream().filter(le -> this.isCurrentComponentInstance(le.getComponentInstance())).findFirst();
        if (guard.isPresent()) {
            DataUse g = guard.get().getExpression();
            this.initializeDataUse(g, dataUseVariables);
            this.append("if (");
            this.write(g, dataUseVariables);
            this.append(")");
            this.blockOpen();
        }
        HashSet<String> myThrownExceptions = new HashSet<String>();
        if (exceptionalBehaviourName != null) {
            Hashtable<DataUse, String> innerDataUseVariables = new Hashtable<DataUse, String>();
            boolean triggerWritten = false;
            for (Behaviour b : bl.getBehaviour()) {
                if (!triggerWritten) {
                    if (!this.isParticipating(b)) continue;
                    if (!this.isTesterInput(b)) {
                        throw new RuntimeException("Exceptional block should start with tester input: " + this.getMessage(b));
                    }
                    this.lineComment("This gets executed automatically with all interactions");
                    FutureInfo callable = this.writeTesterInput(b, dataUseVariables, false, false);
                    this.line(String.valueOf(exceptionalBehaviourName) + ".setCallable(" + callable.varName + ");");
                    this.newLine();
                    this.append(String.valueOf(exceptionalBehaviourName) + ".behaviour = () -> ");
                    this.blockOpen();
                    this.lineComment("Disable while exceptional behaviour is executed");
                    this.line("removeExceptionalBehaviour(" + exceptionalBehaviourName + ");");
                    this.newLine();
                    this.append("try");
                    this.blockOpen();
                    this.declareDataUses((Element)bl, innerDataUseVariables, "exc_");
                    this.newLine();
                    triggerWritten = true;
                } else {
                    this.write(b, innerDataUseVariables, null, myThrownExceptions);
                }
                this.newLine();
            }
            this.blockClose();
            this.append("finally");
            this.blockOpen();
            this.lineComment("Enable the exceptional behaviour again");
            this.line("addExceptionalBehaviour(" + exceptionalBehaviourName + ");");
            this.blockClose();
            this.blockCloseMethod();
        } else {
            for (Behaviour b : bl.getBehaviour()) {
                this.write(b, dataUseVariables, futures, myThrownExceptions);
                this.newLine();
            }
        }
        thrownExceptions.addAll(myThrownExceptions);
        if (guard.isPresent()) {
            this.blockClose();
        }
        this.blockClose();
        if (myThrownExceptions.contains(BREAK_EXCEPTION)) {
            this.append("catch (BreakException e)");
            this.blockOpen();
            this.line("if (\"" + this.getElementName((Element)bl) + "\".equals(e.getBlockName()))");
            this.lineInc(bl.container() instanceof CompoundBehaviour ? "return;" : "break;");
            this.line("else");
            this.lineInc("throw e;");
            this.blockClose();
        } else {
            this.line("finally {}");
        }
    }

    private FutureInfo declareFuture(Behaviour b, TimeConstraint tc, Map<DataUse, String> dataUseVariables) {
        String futureName = "timeConstraint_" + this.getElementName((Element)tc) + "_" + this.getElementName((Element)b);
        this.line("Future<ExecutionResult> " + futureName + " = timeConstraint(() -> ");
        this.blockOpen();
        DataUse exp = tc.getTimeConstraintExpression();
        this.declareDataUses((Element)tc, dataUseVariables, "");
        this.initializeDataUse(exp, dataUseVariables);
        this.append("return ");
        this.write(exp, dataUseVariables);
        this.line(";");
        this.blockClose();
        this.line(").execute();");
        return new FutureInfo(futureName, "TimeoutResult", b);
    }

    private FutureInfo declareFuture(Behaviour b, Map<DataUse, String> dataUseVariables, boolean autoSubmit) {
        String typeSignature = autoSubmit ? "Future<ExecutionResult>" : "ExecutionCallable";
        Target localTarget = null;
        if (b instanceof Interaction) {
            localTarget = ((Interaction)b).getTarget().stream().filter(t -> this.isCurrentComponentInstance(t.getTargetGate().getComponent())).findFirst().get();
        }
        if (b instanceof TimeOut) {
            String futureName = "timeout_" + this.getElementName((Element)b);
            String timerName = this.getTimerName(((TimerOperation)b).getTimer());
            this.append(String.valueOf(typeSignature) + " timeout_" + this.getElementName((Element)b) + " = timeout(" + timerName + ")");
            if (autoSubmit) {
                this.append(".execute()");
            }
            this.line(";");
            return new FutureInfo(futureName, "TimeoutResult", b);
        }
        if (b instanceof Wait) {
            String futureName = "sleep_" + this.getElementName((Element)b);
            DataUse period = ((TimeOperation)b).getPeriod();
            this.initializeDataUse(period, dataUseVariables);
            this.append(String.valueOf(typeSignature) + " " + futureName + " = sleep(");
            this.write(period, dataUseVariables);
            this.append(")");
            if (autoSubmit) {
                this.append(".execute()");
            }
            this.line(";");
            return new FutureInfo(futureName, "TimeoutResult", b);
        }
        if (b instanceof Quiescence) {
            String futureName = "noInput_" + this.getElementName((Element)b);
            DataUse period = ((TimeOperation)b).getPeriod();
            this.initializeDataUse(period, dataUseVariables);
            this.append(String.valueOf(typeSignature) + " " + futureName + " = noInput(");
            this.write(period, dataUseVariables);
            this.append(", ");
            GateReference gr = ((Quiescence)b).getGateReference();
            if (gr != null) {
                this.writeGetGateReference(gr);
            } else {
                this.append("null");
            }
            this.append(")");
            if (autoSubmit) {
                this.append(".execute()");
            }
            this.line(";");
            return new FutureInfo(futureName, "TimeoutResult", b);
        }
        if (b instanceof Message) {
            Message m = (Message)b;
            String futureName = "receive_" + this.getElementName((Element)b);
            DataUse arg2 = m.getArgument();
            this.initializeDataUse(arg2, dataUseVariables);
            this.append(String.valueOf(typeSignature) + " " + futureName + " = " + (m.isIsTrigger() ? "trigger" : "receive") + "(");
            this.convertToData(arg2, dataUseVariables);
            this.append(", ");
            this.writeGetConnection(localTarget.getTargetGate(), m.getSourceGate());
            this.append(")");
            if (autoSubmit) {
                this.append(".execute()");
            }
            this.line(";");
            return new FutureInfo(futureName, "InteractionResult", b);
        }
        if (b instanceof ProcedureCall) {
            ProcedureCall pc = (ProcedureCall)b;
            String futureName = "call_" + this.getElementName((Element)b);
            if (pc.getReplyTo() == null && !this.isTesterInput(b)) {
                ProcedureCall[] reply = new ProcedureCall[1];
                b.getParentTestDescription().eAllContents().forEachRemaining(e -> {
                    if (e instanceof ProcedureCall && b.equals(((ProcedureCall)e).getReplyTo())) {
                        procedureCallArray[0] = (ProcedureCall)e;
                        return;
                    }
                });
                if (reply[0] == null) {
                    throw new RuntimeException("No reply for: " + this.getMessage(b));
                }
                EList arguments = pc.getArgument();
                EList replyArguments = reply[0].getArgument();
                arguments.forEach(arg -> this.initializeDataUse(arg.getDataUse(), dataUseVariables));
                replyArguments.forEach(arg -> this.initializeDataUse(arg.getDataUse(), dataUseVariables));
                this.append(String.valueOf(typeSignature) + " " + futureName + " = call(");
                this.writeCallArguments(pc, reply[0], true, dataUseVariables);
                this.append(", ");
                this.writeGetConnection(localTarget.getTargetGate(), pc.getSourceGate());
                this.line(")");
                if (autoSubmit) {
                    this.append(".execute()");
                }
                this.line(";");
                return new FutureInfo(futureName, "InteractionResult", b);
            }
        }
        throw new RuntimeException("Don't know how to create future for: " + this.getMessage(b));
    }

    private void writeCallArguments(ProcedureCall pc, ProcedureCall reply, boolean call, Map<DataUse, String> dataUseVariables) {
        boolean callProceduresDirectly = true;
        EList arguments = pc.getArgument();
        if (call) {
            if (callProceduresDirectly) {
                ProcedureSignature signature = pc.getSignature();
                DataElementMapping mapping = this.getMappingChecked((MappableDataElement)signature);
                DataResourceMapping resourceMapping = mapping.getDataResourceMapping();
                if (!this.hasAnnotation((Element)resourceMapping, MAPPING_ANNOTATION_CLASS)) {
                    throw new RuntimeException("Unsupported resource mapping: " + signature.getQualifiedName());
                }
                this.append("() ->");
                this.blockOpen();
                String callableRef = null;
                if (this.hasAnnotation((Element)mapping, MAPPING_ANNOTATION_METHOD)) {
                    callableRef = String.valueOf(this.getElementName((Element)signature)) + "_adapter";
                    this.append(String.valueOf(resourceMapping.getResourceURI()) + " " + callableRef + " = ");
                    this.append("(" + resourceMapping.getResourceURI() + ")");
                    this.append("getInstance(" + resourceMapping.getResourceURI() + ".class);");
                    this.newLine();
                } else if (this.hasAnnotation((Element)mapping, MAPPING_ANNOTATION_STATIC_METHOD)) {
                    callableRef = resourceMapping.getResourceURI();
                } else {
                    throw new RuntimeException("Unsupported resource mapping: " + signature.getQualifiedName());
                }
                this.append("return " + callableRef + "." + mapping.getElementURI() + "(");
                boolean first = true;
                for (ParameterBinding arg2 : arguments) {
                    if (!first) {
                        this.append(", ");
                    }
                    first = false;
                    this.write(arg2.getDataUse(), dataUseVariables);
                }
                this.line(");");
                this.blockClose();
            } else {
                String operation = this.getElementName((Element)pc.getSignature());
                this.append("\"" + operation + "\", ");
                this.append("new Argument[] {");
                boolean first = true;
                for (ParameterBinding arg3 : arguments) {
                    if (!first) {
                        this.append(", ");
                    }
                    first = false;
                    Parameter p = arg3.getParameter();
                    String parameterName = this.getParameterMappingUri(p);
                    if (parameterName == null) {
                        parameterName = this.getElementName((Element)p);
                    }
                    this.convertToArgument(parameterName, arg3.getDataUse(), dataUseVariables);
                }
                this.append("}, ");
                Optional<ParameterBinding> out = reply.getArgument().stream().filter(arg -> ((ProcedureParameter)arg.getParameter()).getKind() == ParameterKind.OUT).findAny();
                if (out.isPresent()) {
                    this.convertToData(out.get().getDataUse(), dataUseVariables);
                    this.append(", null");
                } else {
                    Optional<ParameterBinding> ex = reply.getArgument().stream().filter(arg -> ((ProcedureParameter)arg.getParameter()).getKind() == ParameterKind.EXCEPTION).findAny();
                    this.append("null, ");
                    if (ex.isPresent()) {
                        this.convertToData(ex.get().getDataUse(), dataUseVariables);
                    } else {
                        this.append("null");
                    }
                }
            }
        }
    }

    private void declareDataUses(Element b, Map<DataUse, String> dataUseVariables, String prefix) {
        TreeIterator i = b.eAllContents();
        while (i.hasNext()) {
            EObject e = (EObject)i.next();
            if (e instanceof Block) {
                i.prune();
                continue;
            }
            if (e instanceof TimeLabelUse || e instanceof TimeConstraint || e instanceof SpecialValueUse) continue;
            this.declareDataUse(e, dataUseVariables, prefix);
        }
    }

    private void declareDataUse(EObject e, Map<DataUse, String> dataUseVariables, String prefix) {
        if (e instanceof VariableUse) {
            dataUseVariables.put((DataUse)e, this.getElementName((Element)((VariableUse)e).getVariable()));
        } else if (e instanceof DataUse) {
            DataUse d = (DataUse)e;
            String varName = this.getElementName((Element)d);
            varName = varName == null ? "" : String.valueOf(varName) + "_";
            varName = String.valueOf(varName) + prefix + "datause_" + (dataUseVariables.size() + 1);
            DataType type = d.resolveDataType();
            boolean isTime = false;
            if (type == null && d instanceof PredefinedFunctionCall) {
                for (DataUse arg : ((PredefinedFunctionCall)d).getActualParameters()) {
                    if (arg instanceof TimeLabelUse) {
                        isTime = true;
                        break;
                    }
                    type = arg.resolveDataType();
                    if (type != null) break;
                }
            }
            if (type == null && !isTime) {
                if (this.isUnmapped()) {
                    this.line("org.etsi.mts.tdl.execution.java.rt.core.ValueImpl " + varName + ";");
                } else if (d instanceof LiteralValueUse) {
                    LiteralValueUse ld = (LiteralValueUse)d;
                    if (ld.getBoolValue() != null) {
                        this.line("boolean " + varName + ";");
                    } else if (ld.getIntValue() != null) {
                        this.line("int " + varName + ";");
                    } else {
                        this.line("String " + varName + ";");
                    }
                } else if (d instanceof PredefinedFunctionCall) {
                    this.line("// TODO Meta-model problem: DataUse.resolveDataType() return null");
                    this.line(String.valueOf(this.getPredefinedFunctionType(((PredefinedFunctionCall)d).getFunction())) + " " + varName + ";");
                } else {
                    this.line("// TODO Meta-model problem: DataUse.resolveDataType() return null");
                    this.line("String " + varName + ";");
                }
            } else if (type instanceof Time || isTime) {
                this.line("long " + varName + ";");
            } else if (type instanceof CollectionDataType) {
                if (this.isUnmapped()) {
                    this.line("org.etsi.mts.tdl.execution.java.rt.core.ValueImpl " + varName + ";");
                } else {
                    this.line("java.util.List<" + this.getElementName((Element)((CollectionDataType)type).getItemType()) + "> " + varName + ";");
                }
            } else if (this.isUnmapped()) {
                this.line("org.etsi.mts.tdl.execution.java.rt.core.ValueImpl " + varName + ";");
            } else {
                this.line(String.valueOf(this.getElementName((Element)type)) + " " + varName + ";");
            }
            dataUseVariables.put(d, varName);
        }
    }

    private Time resolveTimeType(DataUse d) {
        DataType type = d.resolveDataType();
        if (type instanceof Time) {
            return (Time)type;
        }
        List<DataUse> args = this.getDataUseArgumentValues(d);
        for (DataUse ad : args) {
            type = this.resolveTimeType(ad);
            if (type == null) continue;
            return (Time)type;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeDataUse(DataUse d, Map<DataUse, String> dataUseVariables) {
        String classQName;
        if (d instanceof TimeLabelUse) {
            return;
        }
        if (d instanceof SpecialValueUse) {
            return;
        }
        for (MemberReference r : d.getReduction()) {
            DataUse idx = r.getCollectionIndex();
            if (idx == null) continue;
            this.initializeDataUse(idx, dataUseVariables);
        }
        if (d instanceof DataElementUse) {
            for (DataUse item : ((DataElementUse)d).getItem()) {
                this.initializeDataUse(item, dataUseVariables);
            }
        }
        for (DataUse arg : this.getDataUseArgumentValues(d)) {
            this.initializeDataUse(arg, dataUseVariables);
        }
        this.writeComment((Element)d);
        if (!dataUseVariables.containsKey(d)) {
            this.declareDataUse((EObject)d, dataUseVariables, "");
        }
        DataInstance dataInstance = null;
        DataType dataType = null;
        FormalParameter formalParameter = null;
        Function function = null;
        PredefinedFunction predefinedFunction = null;
        EList memberAssignments = null;
        EList collectionItems = null;
        DataType castTo = null;
        String ref = dataUseVariables.get(d);
        List<ParameterBinding> arguments = this.getDataUseArguments(d);
        if (d instanceof CastDataUse) {
            castTo = ((CastDataUse)d).getDataType();
            d = ((CastDataUse)d).getDataUse();
        }
        if (d instanceof DataElementUse) {
            NamedElement element = ((DataElementUse)d).getDataElement();
            if (element instanceof DataInstance) {
                dataInstance = (DataInstance)element;
                DataElementMapping m = this.getMapping((MappableDataElement)dataInstance);
                if (m == null) {
                    dataType = d.resolveDataType();
                    if (dataInstance instanceof StructuredDataInstance) {
                        memberAssignments = ((StructuredDataInstance)dataInstance).getMemberAssignment();
                    }
                    dataInstance = null;
                }
            } else if (element instanceof DataType) {
                dataType = (DataType)element;
            } else if (element instanceof FormalParameter) {
                formalParameter = (FormalParameter)element;
            } else if (element instanceof Function) {
                function = (Function)element;
            } else if (element instanceof PredefinedFunction) {
                predefinedFunction = (PredefinedFunction)element;
            } else {
                dataType = d.resolveDataType();
                if (dataType == null) {
                    throw new RuntimeException("Unresolved type of DataElementUse " + d.getName());
                }
            }
        } else if (d instanceof DataInstanceUse) {
            dataInstance = ((DataInstanceUse)d).getDataInstance();
            if (dataInstance == null) {
                dataType = d.resolveDataType();
            }
        } else if (d instanceof FunctionCall) {
            function = ((FunctionCall)d).getFunction();
        } else if (d instanceof PredefinedFunctionCall) {
            predefinedFunction = ((PredefinedFunctionCall)d).getFunction();
        }
        this.append(ref);
        if (!this.isUnmapped()) {
            this.append(" = ");
            if (castTo != null) {
                DataElementMapping m = this.getMappingChecked((MappableDataElement)castTo);
                this.append("(" + m.getElementURI() + ")");
            }
        }
        String typeName = this.declaredTypes.get(d.resolveDataType());
        String unmappedDataInitializer = " = new org.etsi.mts.tdl.execution.java.rt.core.ValueImpl(getType(\"" + typeName + "\"))";
        if (dataInstance != null) {
            DataElementMapping m = this.getMapping((MappableDataElement)dataInstance);
            if (m == null) {
                DataType t = dataInstance.getDataType();
                if (!this.isVerdict(t)) throw new RuntimeException("Mapping missing for: " + dataInstance.getQualifiedName());
                this.append("Verdict." + dataInstance.getName());
            } else if (this.isUnmapped()) {
                this.line(unmappedDataInitializer);
                this.append(".setMapping(");
                this.writeMapping(m, String.valueOf(ref) + "_mapping", true);
                this.line(")");
            } else {
                classQName = m.getDataResourceMapping().getResourceURI();
                this.append(String.valueOf(classQName) + "." + m.getElementURI());
                if (this.hasAnnotation((Element)m, MAPPING_ANNOTATION_METHOD) || this.hasAnnotation((Element)m, MAPPING_ANNOTATION_STATIC_METHOD)) {
                    this.append("()");
                }
            }
        } else if (dataType != null) {
            boolean isCollection = false;
            if (dataType instanceof CollectionDataType) {
                dataType = ((CollectionDataType)dataType).getItemType();
                isCollection = true;
                if (d instanceof DataElementUse) {
                    collectionItems = ((DataElementUse)d).getItem();
                }
            }
            if (this.isUnmapped()) {
                this.append(unmappedDataInitializer);
                if (isCollection) {
                    this.line(".setIsCollection(true)");
                } else {
                    this.line(".setIsStructure(true)");
                }
            } else {
                DataElementMapping m = this.getMapping((MappableDataElement)dataType);
                if (m != null) {
                    if (this.hasAnnotation((Element)m, MAPPING_ANNOTATION_CLASS)) {
                        this.append("new ");
                        if (isCollection) {
                            this.append("java.util.ArrayList<");
                        }
                        String classQName2 = m.getDataResourceMapping().getResourceURI();
                        this.append(String.valueOf(classQName2) + "." + m.getElementURI());
                        if (isCollection) {
                            this.append(">");
                        }
                        this.append("()");
                    } else if (isCollection) {
                        this.append("new java.util.ArrayList()");
                    }
                }
            }
        } else if (!(d instanceof SpecialValueUse)) {
            if (d instanceof LiteralValueUse) {
                if (this.isUnmapped()) {
                    this.append(String.valueOf(unmappedDataInitializer) + ".setValue(");
                }
                String str = ((LiteralValueUse)d).getValue();
                BigInteger i = ((LiteralValueUse)d).getIntValue();
                Boolean b = ((LiteralValueUse)d).getBoolValue();
                if (str != null) {
                    this.append("\"" + this.escape(str) + "\"");
                } else if (i != null) {
                    this.append(Integer.toString(i.intValue()));
                } else if (b != null) {
                    this.append(Boolean.toString(b));
                }
                if (this.isUnmapped()) {
                    this.append(")");
                }
            } else if (function != null || predefinedFunction != null) {
                if (this.isUnmapped()) {
                    this.append(String.valueOf(unmappedDataInitializer) + ".setValue(");
                }
                if (function != null) {
                    DataElementMapping m = this.getMappingChecked((MappableDataElement)function);
                    classQName = m.getDataResourceMapping().getResourceURI();
                    String functionName = m.getElementURI();
                    this.append(String.valueOf(classQName) + "." + (String)functionName);
                } else if (predefinedFunction != null) {
                    this.append("this.functions." + this.getPredefinedFunction(predefinedFunction));
                }
                this.append("(");
                boolean first = true;
                for (DataUse arg : this.getDataUseArgumentValues(d)) {
                    if (!first) {
                        this.append(", ");
                    }
                    first = false;
                    if (predefinedFunction != null) {
                        String fn = predefinedFunction.getName();
                        if (fn.equals("==") || fn.equals("!=")) {
                            this.convertToData(arg, dataUseVariables);
                            continue;
                        }
                        this.write(arg, dataUseVariables);
                        continue;
                    }
                    this.write(arg, dataUseVariables);
                }
                this.append(")");
                if (this.isUnmapped()) {
                    this.append(")");
                }
            } else if (formalParameter != null) {
                if (this.isUnmapped()) {
                    this.append(String.valueOf(unmappedDataInitializer) + ".setValue(");
                }
                this.append(this.getElementName((Element)formalParameter));
                if (this.isUnmapped()) {
                    this.append(")");
                }
            } else if (d instanceof VariableUse) {
                this.write(d, dataUseVariables);
            }
        }
        this.line(";");
        if (d instanceof VariableUse) {
            this.lineComment("TODO runtimeHelper.clone(" + this.getElementName((Element)((VariableUse)d).getVariable()) + ")");
        }
        if (!arguments.isEmpty()) {
            for (ParameterBinding arg : arguments) {
                this.append(ref);
                this.append(".");
                this.writeMemberAssignment(arg.getParameter(), arg.getDataUse(), dataUseVariables);
                this.line(";");
            }
        }
        if (memberAssignments != null) {
            for (MemberAssignment ma : memberAssignments) {
                this.append(ref);
                this.append(".");
                this.writeMemberAssignment((Parameter)ma.getMember(), ma.getMemberSpec(), dataUseVariables);
                this.line(";");
            }
        }
        if (collectionItems == null) return;
        for (DataUse item : collectionItems) {
            String itemRef = dataUseVariables.get(item);
            if (this.isUnmapped()) {
                this.append(String.valueOf(ref) + ".addItem(" + itemRef + ".asData())");
            } else {
                this.append(String.valueOf(ref) + ".add(" + itemRef + ")");
            }
            this.line(";");
        }
    }

    private void writeMemberAssignment(Parameter p, DataUse v, Map<DataUse, String> dataUseVariables) {
        if (this.isUnmapped()) {
            this.append("setParameter");
            this.append("(");
            this.append("\"" + p.getName() + "\", ");
            this.write(v, dataUseVariables);
            this.append(")");
        } else {
            ParameterMapping mapping = this.getParameterMapping(p);
            if (mapping != null) {
                if (this.hasAnnotation((Element)mapping, MAPPING_ANNOTATION_SETTER)) {
                    this.append(mapping.getParameterURI());
                    this.append("(");
                    this.write(v, dataUseVariables);
                    this.append(")");
                } else {
                    this.append(mapping.getParameterURI());
                    this.append(" = ");
                    this.write(v, dataUseVariables);
                }
            } else {
                this.append(p.getName());
                this.append(" = ");
                this.write(v, dataUseVariables);
                this.lineComment(" Parameter not mapped");
            }
        }
    }

    private String escape(String s) {
        StringBuilder buf = new StringBuilder();
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\\' || chars[i] == '\"') {
                buf.append('\\');
            }
            buf.append(chars[i]);
            ++i;
        }
        return buf.toString();
    }

    private void write(DataUse d, Map<DataUse, String> dataUseVariables) {
        if (d instanceof TimeLabelUse) {
            this.append(this.getTimeLabelName(((TimeLabelUse)d).getTimeLabel()));
            this.append("." + ((TimeLabelUse)d).getKind().getName().toLowerCase() + "()");
        } else {
            DataType type = d.resolveDataType();
            if (type instanceof Time) {
                this.append("TimeUnit." + this.getElementName((Element)type) + ".toSeconds(" + dataUseVariables.get(d) + ")");
            } else {
                this.append(dataUseVariables.get(d));
                if (this.isUnmapped()) {
                    this.append(".asData()");
                }
            }
        }
        boolean first = true;
        for (MemberReference ref : d.getReduction()) {
            DataUse idx = ref.getCollectionIndex();
            if (first && idx != null) {
                this.writeCollectionIdnex(d.resolveDataType(), idx, dataUseVariables);
            } else {
                Member prop = ref.getMember();
                ParameterMapping pm = this.getParameterMapping((Parameter)prop);
                String mappedName = null;
                Annotation getter = this.getAnnotation((Element)pm, MAPPING_ANNOTATION_GETTER);
                mappedName = getter != null ? getter.getValue() : pm.getParameterURI();
                if (mappedName == null) {
                    mappedName = this.getElementName((Element)prop);
                }
                this.append("." + mappedName);
                if (getter != null) {
                    this.append("()");
                }
                if (idx != null) {
                    this.writeCollectionIdnex(prop.getDataType(), idx, dataUseVariables);
                }
            }
            first = false;
        }
    }

    private void writeCollectionIdnex(DataType t, DataUse idx, Map<DataUse, String> dataUseVariables) {
        String mappedType;
        boolean isArray = true;
        DataElementMapping m = this.getMapping((MappableDataElement)t);
        if (m != null && !(mappedType = m.getElementURI()).contains("[]")) {
            isArray = false;
        }
        Stack<Reference> dataUseVariableRef = new Stack<Reference>();
        dataUseVariableRef.push(new Reference(dataUseVariableRef, dataUseVariables.get(idx)));
        if (isArray) {
            this.append("[");
            this.write(idx, dataUseVariables);
            this.append("]");
        } else {
            this.append("read");
            this.append("(");
            this.write(idx, dataUseVariables);
            this.line(");");
        }
    }

    private void convertToData(DataUse d, Map<DataUse, String> dataUseVariables) {
        if (!this.isUnmapped()) {
            this.append("new PojoData(");
        }
        this.write(d, dataUseVariables);
        if (!this.isUnmapped()) {
            this.append(")");
        }
    }

    private void convertToArgument(String parameterName, DataUse d, Map<DataUse, String> dataUseVariables) {
        if (!this.isUnmapped()) {
            this.append("new PojoArgument(");
        } else {
            this.append("new Argument(");
        }
        this.write(d, dataUseVariables);
        this.append(", \"" + parameterName + "\"");
        this.append(")");
    }

    private String getPredefinedFunction(PredefinedFunction f) {
        switch (f.getName()) {
            case "==": {
                return "equals";
            }
            case "!=": {
                return "notEquals";
            }
            case "<": {
                return "lt";
            }
            case ">": {
                return "gt";
            }
            case "<=": {
                return "lteq";
            }
            case ">=": {
                return "gteq";
            }
            case "+": {
                return "plus";
            }
            case "-": {
                return "minus";
            }
            case "*": {
                return "multiply";
            }
            case "/": {
                return "divide";
            }
        }
        return f.getName();
    }

    private String getPredefinedFunctionType(PredefinedFunction f) {
        switch (f.getName()) {
            case "<": 
            case ">": 
            case "!=": 
            case "<=": 
            case "==": 
            case ">=": {
                return "boolean";
            }
            case "*": 
            case "+": 
            case "-": 
            case "/": {
                return "integer";
            }
        }
        throw new RuntimeException("Unknown predefined function in type resolution.");
    }

    private void writeComment(Element e) {
        e.getComment().forEach(c -> {
            this.append("/* ");
            this.line(c.getBody());
            this.line("*/ ");
            this.line("reporter.comment(\"" + c.getBody() + "\");");
        });
    }

    private void writeObjective(Behaviour b) {
        b.getTestObjective().forEach(to -> {
            this.append("reporter.testObjectiveReached(");
            this.append("\"" + to.getObjectiveURI() + "\", ");
            this.append("\"" + to.getDescription() + "\"");
            this.line(");");
        });
    }

    private void writeNotification(Behaviour b, boolean started) {
        if (this.logEvents) {
            this.append("reporter.");
            this.append(started ? "behaviourStarted" : "behaviourCompleted");
            this.append("(");
            if (started) {
                this.append("\"" + b.eClass().getName() + "\", ");
            }
            this.append("\"" + this.getQName(b) + "\"");
            this.line(");");
        }
    }

    private String getQName(Behaviour b) {
        String name = b.getName();
        if (name == null) {
            name = this.getElementName((Element)b);
        }
        return name;
    }

    private String getMessage(Behaviour b) {
        return String.valueOf(b.eClass().getName()) + ": " + b.getName();
    }

    private boolean isParticipating(Behaviour b) {
        return b.getParticipatingComponents().stream().anyMatch(c -> this.isCurrentComponentInstance((ComponentInstance)c));
    }

    private boolean isTesterInput(Behaviour b) {
        if (b instanceof Interaction) {
            return ((Interaction)b).getTarget().stream().anyMatch(t -> this.isCurrentComponentInstance(t.getTargetGate().getComponent()));
        }
        return b.isTesterInputEvent();
    }

    private boolean isCurrentComponentInstance(ComponentInstance c) {
        if (this.currentTester == null) {
            return false;
        }
        return this.currentTester.equals(c);
    }

    private List<DataUse> getDataUseArgumentValues(DataUse d) {
        if (d instanceof PredefinedFunctionCall) {
            return ((PredefinedFunctionCall)d).getActualParameters();
        }
        ArrayList<DataUse> arguments = new ArrayList<DataUse>();
        List<ParameterBinding> args = this.getDataUseArguments(d);
        args.stream().forEach(pb -> {
            boolean bl = arguments.add(pb.getDataUse());
        });
        List<MemberAssignment> memberAssignments = this.getDataUseMembers(d);
        memberAssignments.stream().forEach(ma -> {
            boolean bl = arguments.add(ma.getMemberSpec());
        });
        return arguments;
    }

    private List<ParameterBinding> getDataUseArguments(DataUse d) {
        EList args = d.getArgument();
        return args;
    }

    private List<MemberAssignment> getDataUseMembers(DataUse d) {
        DataInstance dataInstance = null;
        if (d instanceof DataInstanceUse) {
            dataInstance = ((DataInstanceUse)d).getDataInstance();
        } else if (d instanceof DataElementUse && ((DataElementUse)d).getDataElement() instanceof DataInstance) {
            dataInstance = (DataInstance)((DataElementUse)d).getDataElement();
        }
        return dataInstance instanceof StructuredDataInstance ? ((StructuredDataInstance)dataInstance).getMemberAssignment() : Collections.EMPTY_LIST;
    }

    class FutureInfo {
        public String varName;
        public String kind;
        public Behaviour b;
        public boolean hasExceptionals = false;

        public FutureInfo(String varName, String kind, Behaviour b) {
            this.varName = varName;
            this.kind = kind;
            this.b = b;
        }
    }

    @FunctionalInterface
    public static interface PackageableElementAcceptor {
        public void accept(PackageableElement var1);
    }
}

