/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.graphical.labels.linking;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.etsi.mts.tdl.DataUse;
import org.etsi.mts.tdl.graphical.labels.linking.AlternativeContext;
import org.etsi.mts.tdl.tdlPackage;

public class ContextAwareLinkingService
extends DefaultLinkingService {
    private Map<EClass, AlternativeContext> alternativeContexts;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        EClass requiredType = ref.getEReferenceType();
        if (requiredType == null) {
            return Collections.emptyList();
        }
        String crossRefString = this.getCrossRefNodeAsString(node);
        if (crossRefString != null && !crossRefString.equals("")) {
            Iterator iter;
            AlternativeContext alternative;
            QualifiedName qualifiedLinkName = this.qualifiedNameConverter.toQualifiedName(crossRefString);
            IScope scope = this.getScope(context, ref);
            Iterable eObjectDescriptions = scope.getElements(qualifiedLinkName);
            if (context instanceof DataUse && !eObjectDescriptions.iterator().hasNext() && (alternative = this.getAlternativeContext(context)) != null) {
                EObject current = context;
                int i = 0;
                while (i < alternative.classes.length) {
                    EObject alternativeContext = EcoreUtil.create((EClass)alternative.classes[i]);
                    EcoreUtil.replace((EObject)current, (EObject)alternativeContext);
                    current = alternativeContext;
                    IScope alternativeScope = this.getScope(alternativeContext, alternative.references[i]);
                    Iterable altEObjectDescriptions = alternativeScope.getElements(qualifiedLinkName);
                    if (altEObjectDescriptions.iterator().hasNext()) {
                        alternative.copy(context, alternativeContext);
                        context = alternativeContext;
                        ref = alternative.references[i];
                        scope = alternativeScope;
                        eObjectDescriptions = altEObjectDescriptions;
                        break;
                    }
                    ++i;
                }
                if (context != current) {
                    EcoreUtil.replace((EObject)current, (EObject)context);
                }
            }
            if ((iter = eObjectDescriptions.iterator()).hasNext()) {
                IEObjectDescription eObjectDescription = (IEObjectDescription)iter.next();
                EObject linkedObject = eObjectDescription.getEObjectOrProxy();
                if (!iter.hasNext() || !ref.isMany()) {
                    context.eSet((EStructuralFeature)ref, (Object)linkedObject);
                    return Collections.singletonList(linkedObject);
                }
            }
        }
        return Collections.emptyList();
    }

    public AlternativeContext getAlternativeContext(EObject contextObject) {
        if (this.alternativeContexts == null) {
            this.alternativeContexts = new Hashtable<EClass, AlternativeContext>();
            AlternativeContext dataUseContexts = new AlternativeContext(){

                @Override
                void copy(EObject from, EObject to) {
                    ((DataUse)to).getReduction().addAll((Collection)((DataUse)from).getReduction());
                    ((DataUse)to).getArgument().addAll((Collection)((DataUse)from).getArgument());
                }
            };
            dataUseContexts.classes = new EClass[]{tdlPackage.eINSTANCE.getDataInstanceUse(), tdlPackage.eINSTANCE.getFunctionCall(), tdlPackage.eINSTANCE.getPredefinedFunctionCall(), tdlPackage.eINSTANCE.getVariableUse(), tdlPackage.eINSTANCE.getFormalParameterUse(), tdlPackage.eINSTANCE.getTimeLabelUse()};
            dataUseContexts.references = new EReference[]{tdlPackage.eINSTANCE.getDataInstanceUse_DataInstance(), tdlPackage.eINSTANCE.getFunctionCall_Function(), tdlPackage.eINSTANCE.getPredefinedFunctionCall_Function(), tdlPackage.eINSTANCE.getVariableUse_Variable(), tdlPackage.eINSTANCE.getFormalParameterUse_Parameter(), tdlPackage.eINSTANCE.getTimeLabelUse_TimeLabel()};
            this.alternativeContexts.put(tdlPackage.eINSTANCE.getDataUse(), dataUseContexts);
        }
        for (EClass alternativeClass : this.alternativeContexts.keySet()) {
            if (!alternativeClass.isInstance((Object)contextObject)) continue;
            return this.alternativeContexts.get(alternativeClass);
        }
        System.out.println(contextObject);
        return null;
    }
}

