/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.transform;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.etsi.mts.tdl.Annotation;
import org.etsi.mts.tdl.AnnotationType;
import org.etsi.mts.tdl.CollectionDataType;
import org.etsi.mts.tdl.Comment;
import org.etsi.mts.tdl.Constraint;
import org.etsi.mts.tdl.ConstraintType;
import org.etsi.mts.tdl.DataElementMapping;
import org.etsi.mts.tdl.DataResourceMapping;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.ElementImport;
import org.etsi.mts.tdl.EnumDataType;
import org.etsi.mts.tdl.Extension;
import org.etsi.mts.tdl.MappableDataElement;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.PackageableElement;
import org.etsi.mts.tdl.Parameter;
import org.etsi.mts.tdl.ParameterMapping;
import org.etsi.mts.tdl.SimpleDataInstance;
import org.etsi.mts.tdl.SimpleDataType;
import org.etsi.mts.tdl.StructuredDataInstance;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.tdlFactory;
import org.etsi.mts.tdl.tdlPackage;

public abstract class AbstractTranslator {
    protected DataResourceMapping drm;
    protected DataResourceMapping drmTarget;
    private Package generatedPackage;
    protected SimpleDataType stringType;
    private Resource targetResource;
    protected SimpleDataType referencedType;
    protected boolean useQualifiers = true;
    protected boolean fullPrefix = false;
    protected String sourceMappingTag = "SOURCE_MAPPING";
    protected String targetMappingTag = "TARGET_MAPPING";
    protected String idStartDigitRegex = "\\A\\d.*";
    protected String idInvalidCharRegex = "\\W";

    public abstract void translate(String var1) throws Exception;

    public void initTargetResource(String name) {
        this.generatedPackage = tdlFactory.eINSTANCE.createPackage();
        this.generatedPackage.setName("generated_from_" + name);
        this.targetResource.getContents().add((Object)this.generatedPackage);
        this.stringType = this.getSimpleDataTypeFor("String");
        this.referencedType = this.getSimpleDataTypeFor("TODO_RESOLVE_REFERENCED");
    }

    public void addImports(Package p) {
        this.generatedPackage.getImport().addAll((Collection)p.getImport());
        ElementImport sourceImport = tdlFactory.eINSTANCE.createElementImport();
        sourceImport.setImportedPackage(p);
        this.generatedPackage.getImport().add((Object)sourceImport);
    }

    protected DataType getDataTypeFor(String name) {
        return (DataType)this.getTypeFor(this.getCleanName(name), tdlPackage.Literals.DATA_TYPE);
    }

    protected SimpleDataType getSimpleDataTypeFor(String name) {
        return (SimpleDataType)this.getTypeFor(this.getCleanName(name), tdlPackage.Literals.SIMPLE_DATA_TYPE);
    }

    protected EnumDataType getEnumDataTypeFor(String name) {
        return (EnumDataType)this.getTypeFor(this.getCleanName(name), tdlPackage.Literals.ENUM_DATA_TYPE);
    }

    protected SimpleDataInstance getSimpleDataInstanceFor(String name) {
        return (SimpleDataInstance)this.getTypeFor(this.getCleanName(name), tdlPackage.Literals.SIMPLE_DATA_INSTANCE);
    }

    protected SimpleDataInstance getEnumDataInstanceFor(String name, EnumDataType type) {
        return (SimpleDataInstance)this.getContentWithName(this.getCleanName(name), (NamedElement)type, tdlPackage.Literals.SIMPLE_DATA_INSTANCE);
    }

    protected StructuredDataType getStructuredDataTypeFor(String name) {
        return (StructuredDataType)this.getTypeFor(this.getCleanName(name), tdlPackage.Literals.STRUCTURED_DATA_TYPE);
    }

    protected StructuredDataInstance getStructuredDataInstanceFor(String name) {
        return (StructuredDataInstance)this.getTypeFor(this.getCleanName(name), tdlPackage.Literals.STRUCTURED_DATA_INSTANCE);
    }

    protected CollectionDataType getCollectionDataTypeFor(DataType itemType) {
        CollectionDataType collectionType = (CollectionDataType)this.getTypeFor(String.valueOf(itemType.getName()) + "_collection", tdlPackage.Literals.COLLECTION_DATA_TYPE);
        collectionType.setItemType(itemType);
        return collectionType;
    }

    protected <T extends DataType> void addSuperType(T type, T superType) {
        Extension e2;
        Extension extension;
        if (superType == null) {
            return;
        }
        Object ext = null;
        if (type instanceof SimpleDataType && (extension = ((SimpleDataType)type).getExtension()) != null) {
            ext = Collections.singletonList(extension);
        }
        if (type instanceof StructuredDataType) {
            ext = ((StructuredDataType)type).getExtension();
        }
        if (ext == null) {
            return;
        }
        for (Extension e2 : ext) {
            if (!e2.getExtending().equals(superType)) continue;
            return;
        }
        e2 = tdlFactory.eINSTANCE.createExtension();
        e2.setExtending(superType);
        if (type instanceof SimpleDataType) {
            ((SimpleDataType)type).setExtension(e2);
        }
        if (type instanceof StructuredDataType) {
            ((StructuredDataType)type).getExtension().add((Object)e2);
        }
    }

    public static String cleanName(String name) {
        name = name.replaceAll("-", "_").replaceAll(" ", "_").replaceAll(":", "_").replaceAll("@", "_").replaceAll("\\.", "_").replaceFirst("^(\\d)", "_\\1");
        return name;
    }

    public String getCleanName(String name) {
        return AbstractTranslator.cleanName(name);
    }

    protected <T extends PackageableElement> T getTypeFor(String name, EClass targetType) {
        String cleanName = this.getCleanName(name);
        TreeMap<String, String> mappings = new TreeMap<String, String>();
        mappings.put("AsnInteger", "Integer");
        mappings.put("AsnBoolean", "Boolean");
        mappings.put("AsnOctetString", "OCTETSTRING");
        mappings.put("AsnBitString", "BITSTRING");
        mappings.put("AsnReal", "Real");
        cleanName = mappings.getOrDefault(cleanName, cleanName);
        Object generatedType = this.findElementOfType(cleanName, targetType);
        if (generatedType == null) {
            generatedType = (PackageableElement)tdlFactory.eINSTANCE.create(targetType);
            generatedType.setName(cleanName);
            this.generatedPackage.getPackagedElement().add(generatedType);
        }
        return generatedType;
    }

    protected <T extends PackageableElement> T findElementOfType(String name, EClass targetType) {
        Optional<PackageableElement> optional = this.generatedPackage.getPackagedElement().stream().filter(e -> targetType.isInstance(e) && e.getName().equals(this.getCleanName(name))).findFirst();
        PackageableElement generatedType = null;
        if (optional.isPresent()) {
            generatedType = optional.get();
        }
        return (T)generatedType;
    }

    protected <T extends NamedElement> T findContentWithName(String name, NamedElement container, EClass targetType) {
        Optional<NamedElement> optional = container.eContents().stream().filter(e -> targetType.isInstance(e)).map(e -> (NamedElement)e).filter(e -> e.getName().equals(name)).findFirst();
        NamedElement content = null;
        if (optional.isPresent()) {
            content = optional.get();
        }
        return (T)content;
    }

    protected <T extends NamedElement> T getContentWithName(String name, NamedElement container, EClass targetType) {
        String cleanName = this.getCleanName(name);
        Object content = this.findContentWithName(cleanName, container, targetType);
        if (content == null) {
            content = (NamedElement)tdlFactory.eINSTANCE.create(targetType);
            content.setName(cleanName);
        }
        return content;
    }

    protected <T extends Element> Optional<T> getContentWithName(String name, NamedElement container, Class<T> type) {
        Optional<Element> optional = container.eContents().stream().filter(e -> type.isInstance(e)).map(e -> (Element)e).filter(e -> e.getName().equals(name)).findFirst();
        return optional;
    }

    protected <T extends Element> Optional<T> getContentWithPredicate(Predicate<? super T> predicate, NamedElement container, Class<T> type) {
        Optional<? super T> optional = container.eContents().stream().filter(e -> type.isInstance(e)).map(e -> (Element)e).filter(predicate).findFirst();
        return optional;
    }

    protected Annotation getAnnotation(Element element, String annotationName) {
        AnnotationType annotationType = (AnnotationType)this.getTypeFor(this.getCleanName(annotationName), tdlPackage.Literals.ANNOTATION_TYPE);
        Optional<Annotation> optional = element.getAnnotation().stream().filter(a -> a.getKey() == annotationType).findFirst();
        return optional.orElseGet(() -> {
            Annotation annotation = tdlFactory.eINSTANCE.createAnnotation();
            annotation.setKey(annotationType);
            element.getAnnotation().add((Object)annotation);
            return annotation;
        });
    }

    protected Comment getComment(Element element, String noteName) {
        Optional<Comment> optional = element.getComment().stream().filter(a -> a.getName() == noteName).findFirst();
        return optional.orElseGet(() -> {
            Comment comment = tdlFactory.eINSTANCE.createComment();
            comment.setName(noteName);
            element.getComment().add((Object)comment);
            return comment;
        });
    }

    protected void annotateWith(Element element, String annotationName, String annotationValue) {
        Annotation annotation = this.getAnnotation(element, annotationName);
        annotation.setValue(annotationValue);
    }

    protected void annotateWith(Element element, String annotationName) {
        this.getAnnotation(element, annotationName);
    }

    protected void noteWith(Element element, String commentName, String body) {
        Comment comment = this.getComment(element, commentName);
        comment.setBody(body);
    }

    protected Constraint constrainWith(DataType generatedType, String constraintName) {
        ConstraintType constraintType = (ConstraintType)this.getTypeFor(this.getCleanName(constraintName), tdlPackage.Literals.CONSTRAINT_TYPE);
        if (!generatedType.getConstraint().stream().anyMatch(a -> a.getType() == constraintType)) {
            Constraint constraint = tdlFactory.eINSTANCE.createConstraint();
            constraint.setType(constraintType);
            generatedType.getConstraint().add((Object)constraint);
            return constraint;
        }
        return null;
    }

    protected DataElementMapping addDataElementMapping(String uri, DataType dataType, String tag, DataResourceMapping resourceMapping) {
        DataElementMapping mapping = (DataElementMapping)this.getTypeFor(String.valueOf(dataType.getName()) + "_" + tag, tdlPackage.Literals.DATA_ELEMENT_MAPPING);
        mapping.setMappableDataElement((MappableDataElement)dataType);
        mapping.setElementURI(uri);
        mapping.setDataResourceMapping(resourceMapping);
        return mapping;
    }

    protected void addParameterMapping(DataElementMapping mapping, Parameter p, String uri) {
        Optional<ParameterMapping> opm = this.getContentWithPredicate(e -> e.getParameter() == p, (NamedElement)mapping, ParameterMapping.class);
        if (opm.isEmpty()) {
            ParameterMapping pm = (ParameterMapping)tdlFactory.eINSTANCE.create(tdlPackage.Literals.PARAMETER_MAPPING);
            pm.setParameter(p);
            pm.setParameterURI(uri.replaceAll("\\^", ""));
            mapping.getParameterMapping().add((Object)pm);
        }
    }

    public Resource getTargetResource() {
        return this.targetResource;
    }

    public void setTargetResource(Resource targetResource) {
        this.targetResource = targetResource;
    }

    public Package getGeneratedPackage() {
        return this.generatedPackage;
    }

    public void setGeneratedPackage(Package generatedPackage) {
        this.generatedPackage = generatedPackage;
    }

    public void ensureUniqueNames(Package p) {
        HashSet<String> names = new HashSet<String>();
        for (PackageableElement pe : p.getPackagedElement()) {
            this.makeUnique((NamedElement)pe, names);
            if (pe instanceof EnumDataType) {
                for (PackageableElement l : ((EnumDataType)pe).getValue()) {
                    this.makeUnique((NamedElement)l, names);
                }
                continue;
            }
            if (!(pe instanceof Package)) continue;
            this.ensureUniqueNames((Package)pe);
        }
    }

    private void makeUnique(NamedElement e, Set<String> names) {
        String name = e.getName();
        int i = 1;
        String newName = name;
        while (names.contains(newName)) {
            newName = String.valueOf(name) + "_" + i++;
        }
        if (!newName.equals(name)) {
            e.setName(newName);
        }
        names.add(newName);
    }
}

