/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.yang2tdl;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.etsi.mts.tdl.Annotation;
import org.etsi.mts.tdl.AnnotationType;
import org.etsi.mts.tdl.CollectionDataType;
import org.etsi.mts.tdl.Constraint;
import org.etsi.mts.tdl.DataElementMapping;
import org.etsi.mts.tdl.DataResourceMapping;
import org.etsi.mts.tdl.DataType;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.ElementImport;
import org.etsi.mts.tdl.EnumDataType;
import org.etsi.mts.tdl.Extension;
import org.etsi.mts.tdl.LiteralValueUse;
import org.etsi.mts.tdl.Member;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.PackageableElement;
import org.etsi.mts.tdl.Parameter;
import org.etsi.mts.tdl.SimpleDataInstance;
import org.etsi.mts.tdl.SimpleDataType;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.helper.TDLHelper;
import org.etsi.mts.tdl.tdlFactory;
import org.etsi.mts.tdl.tdlPackage;
import org.etsi.mts.tdl.transform.AbstractTranslator;
import org.opendaylight.yangtools.odlext.parser.MountStatementSupport;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafStatement;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.DeclaredCaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.EmptyChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.EmptyLeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.EmptyLeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.RegularChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.RegularLeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.RegularLeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.SlimLeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.UndeclaredCaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractDeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.source.FileYangTextSource;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.rfc7950.reactor.RFC7950Reactors;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangStatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.CrossSourceStatementReactor;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.EffectiveSchemaContext;

public class Yang2TDLTranslator
extends AbstractTranslator {
    private static final String REFERENCE_DESCRIPTION = "ReferenceDescription";
    private static final String LIST_KEY = "ListKey";
    private static final String LEAF_REF_PATH = "LeafRefPath";
    private boolean isXtext = false;
    private Package theTdlPackage;
    private StructuredDataType messageBody = null;
    private String limit = null;
    private AnnotationType mappingNameAnnotation;

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public void setTargetResource(Resource targetResource) {
        super.setTargetResource(targetResource);
        Class<?> resourceClass = targetResource.getClass();
        do {
            if (!resourceClass.getSimpleName().equals("XtextResource")) continue;
            this.isXtext = true;
            break;
        } while ((resourceClass = resourceClass.getSuperclass()) != null);
    }

    public String getCleanName(String name) {
        String replacement = name;
        if (this.isXtext) {
            if (replacement.matches(this.idStartDigitRegex)) {
                replacement = "_" + replacement;
            }
            replacement = replacement.replaceAll(this.idInvalidCharRegex, "_");
        }
        return replacement;
    }

    public void translate(String targetFilename) throws Exception {
        Path target;
        this.targetMappingTag = "YangSpecification";
        this.drm = (DataResourceMapping)this.getTypeFor(this.sourceMappingTag, tdlPackage.Literals.DATA_RESOURCE_MAPPING);
        this.drm.setResourceURI(new File(targetFilename).getName());
        IProject project = TDLHelper.getProjectForResource((Resource)this.getTargetResource());
        if (project != null) {
            ProjectScope ps = new ProjectScope(project);
            ps.getNode("org.etsi.mts.tdl.yang2tdl");
        }
        this.theTdlPackage = TDLHelper.getTdlPackage((Resource)this.getTargetResource());
        this.mappingNameAnnotation = null;
        if (this.theTdlPackage != null) {
            ElementImport importTdl = tdlFactory.eINSTANCE.createElementImport();
            importTdl.setImportedPackage(this.theTdlPackage);
            this.getGeneratedPackage().getImport().add((Object)importTdl);
            this.getGeneratedPackage().getPackagedElement().remove((Object)this.stringType);
            for (PackageableElement e : this.theTdlPackage.getPackagedElement()) {
                if (!e.eClass().equals(tdlPackage.eINSTANCE.getAnnotationType()) || !e.getName().equals("MappingName")) continue;
                this.mappingNameAnnotation = (AnnotationType)e;
                break;
            }
        }
        Package httpPackage = TDLHelper.getHttpPackage((Resource)this.getTargetResource());
        Package httpMessageBasedPackage = null;
        if (httpPackage != null) {
            block1: for (Package p : httpPackage.getNestedPackage()) {
                for (PackageableElement e : p.getPackagedElement()) {
                    if (!e.eClass().equals(tdlPackage.eINSTANCE.getStructuredDataType()) || !e.getName().equals("Body")) continue;
                    this.messageBody = (StructuredDataType)e;
                    httpMessageBasedPackage = p;
                    break block1;
                }
            }
            if (httpMessageBasedPackage != null) {
                ElementImport importHttp = tdlFactory.eINSTANCE.createElementImport();
                importHttp.setImportedPackage(httpMessageBasedPackage);
                this.getGeneratedPackage().getImport().add((Object)importHttp);
            }
        }
        CrossSourceStatementReactor reactor = Yang2TDLTranslator.createReactor();
        CrossSourceStatementReactor.BuildAction build = reactor.newBuild();
        System.out.println("Load YANG libraries from parent:");
        Path parent = target = Path.of(targetFilename, new String[0]);
        while (parent.getParent() != null && !parent.toAbsolutePath().toString().equals(this.limit)) {
            parent = parent.getParent();
        }
        if (parent != target) {
            Files.walk(parent, new FileVisitOption[0]).filter(f -> f.toFile().isFile() && f.toString().endsWith(".yang") && !f.toString().equals(targetFilename)).forEach(f -> {
                System.out.println(f);
                build.addLibSource((StatementStreamSource)Yang2TDLTranslator.moduleFromPath(f.toString()));
            });
        }
        System.out.println("Processing: " + target);
        if (target.toFile().isDirectory()) {
            Files.walk(target, new FileVisitOption[0]).filter(f -> f.toFile().isFile() && f.toString().endsWith(".yang") && !f.toString().equals(targetFilename)).forEach(f -> {
                System.out.println(f);
                build.addSource((StatementStreamSource)Yang2TDLTranslator.moduleFromPath(f.toString()));
            });
        } else {
            build.addSource((StatementStreamSource)Yang2TDLTranslator.moduleFromPath(targetFilename));
        }
        EffectiveSchemaContext schemaContext = build.buildEffective();
        this.drmTarget = (DataResourceMapping)this.getTypeFor(this.targetMappingTag, tdlPackage.Literals.DATA_RESOURCE_MAPPING);
        if (this.mappingNameAnnotation != null) {
            Annotation annot = tdlFactory.eINSTANCE.createAnnotation();
            annot.setKey(this.mappingNameAnnotation);
            annot.setValue("Yang");
            this.drmTarget.getAnnotation().add((Object)annot);
        }
        this.drmTarget.setResourceURI("TODO");
        this.translate((SchemaContext)schemaContext);
        this.ensureUniqueNames(this.getGeneratedPackage());
    }

    private void translate(SchemaContext schemaContext) {
        for (DataSchemaNode c : schemaContext.getChildNodes()) {
            this.translate(c);
        }
    }

    private DataType translate(DataSchemaNode c) {
        return this.translate(c, null);
    }

    private DataType translate(DataSchemaNode c, String parent) {
        DataType dataType = this.translateOnly(c, parent);
        return dataType;
    }

    private DataType translateOnly(DataSchemaNode c, String parent) {
        String baseName;
        String name = baseName = this.getCleanName(c.getQName().getLocalName());
        if (parent != null) {
            name = String.valueOf(parent) + "___" + name;
        }
        System.out.println(name);
        if (c instanceof ContainerSchemaNode) {
            Collection childNodes = ((ContainerSchemaNode)c).getChildNodes();
            if (childNodes.isEmpty()) {
                StructuredDataType dataType = this.translateStructuredDataType((DataNodeContainer)((ContainerSchemaNode)c), baseName, name);
                return dataType;
            }
            DataSchemaNode first = (DataSchemaNode)childNodes.iterator().next();
            if (childNodes.size() == 1 && first instanceof ListSchemaNode) {
                return this.translate(first, parent);
            }
            StructuredDataType dataType = this.translateStructuredDataType((DataNodeContainer)((ContainerSchemaNode)c), baseName, name);
            return dataType;
        }
        if (c instanceof ListSchemaNode) {
            StructuredDataType itemType = this.translateStructuredDataType((DataNodeContainer)((ListSchemaNode)c), baseName, name);
            CollectionDataType collectionType = this.getCollectionDataTypeFor((DataType)itemType);
            this.addMapping((SchemaNode)c, (DataType)collectionType, this.sourceMappingTag, this.targetMappingTag);
            List keyDefinition = ((ListSchemaNode)c).getKeyDefinition();
            keyDefinition.stream().map(AbstractQName::getLocalName).collect(Collectors.joining(", "));
            ((ListSchemaNode)c).getElementCountConstraint().ifPresent(cs -> {
                Integer value = cs.getMaxElements();
                String constraintName = "maxLength";
                if (value == null) {
                    value = cs.getMinElements();
                    constraintName = "minLength";
                }
                Constraint constraint = this.constrainWith((DataType)collectionType, constraintName);
                LiteralValueUse ut = tdlFactory.eINSTANCE.createLiteralValueUse();
                ut.setIntValue(BigInteger.valueOf(value.longValue()));
                constraint.getQuantifier().add((Object)ut);
            });
            return collectionType;
        }
        if (c instanceof RegularLeafListEffectiveStatement) {
            TypeDefinition type = ((RegularLeafListEffectiveStatement)c).getType();
            CollectionDataType collectionType = this.translateSimpleDataCollection(name, type);
            return collectionType;
        }
        if (c instanceof EmptyLeafListEffectiveStatement) {
            TypeDefinition type = ((EmptyLeafListEffectiveStatement)c).getType();
            CollectionDataType collectionType = this.translateSimpleDataCollection(name, type);
            return collectionType;
        }
        if (c instanceof SlimLeafListEffectiveStatement) {
            TypeDefinition type = ((SlimLeafListEffectiveStatement)c).getType();
            CollectionDataType collectionType = this.translateSimpleDataCollection(name, type);
            return collectionType;
        }
        if (c instanceof EmptyLeafEffectiveStatement) {
            TypeDefinition type = ((EmptyLeafEffectiveStatement)c).getType();
            SimpleDataType dataType = this.translateSimpleDataType(name, type);
            return dataType;
        }
        if (c instanceof RegularLeafEffectiveStatement) {
            String typeName = ((RegularLeafEffectiveStatement)c).getType().getQName().getLocalName();
            SimpleDataType dataType = this.getSimpleDataTypeFor(typeName);
            this.addMapping((SchemaNode)c, (DataType)dataType, this.sourceMappingTag, this.targetMappingTag);
            return dataType;
        }
        if (c instanceof RegularChoiceEffectiveStatement) {
            StructuredDataType dataType = this.getStructuredDataTypeFor(name);
            for (CaseSchemaNode child : ((RegularChoiceEffectiveStatement)c).getCases()) {
                this.translateMember(baseName, dataType, (DataSchemaNode)child);
            }
            this.addMapping((SchemaNode)c, (DataType)dataType, this.sourceMappingTag, this.targetMappingTag);
            return dataType;
        }
        if (c instanceof EmptyChoiceEffectiveStatement) {
            StructuredDataType dataType = this.getStructuredDataTypeFor(name);
            for (CaseSchemaNode child : ((EmptyChoiceEffectiveStatement)c).getCases()) {
                this.translateMember(baseName, dataType, (DataSchemaNode)child);
            }
            this.addMapping((SchemaNode)c, (DataType)dataType, this.sourceMappingTag, this.targetMappingTag);
            return dataType;
        }
        if (c instanceof UndeclaredCaseEffectiveStatement) {
            return this.translateStructuredDataType((DataNodeContainer)c, baseName, name);
        }
        if (c instanceof DeclaredCaseEffectiveStatement) {
            return this.translateStructuredDataType((DataNodeContainer)c, baseName, name);
        }
        System.out.println("TODO:: " + c);
        SimpleDataType todoType = this.getSimpleDataTypeFor("TODO");
        return todoType;
    }

    private CollectionDataType translateSimpleDataCollection(String name, TypeDefinition<?> type) {
        SimpleDataType itemType = this.translateSimpleDataType(name, type);
        CollectionDataType collectionType = this.getCollectionDataTypeFor((DataType)itemType);
        this.addMapping((SchemaNode)type, (DataType)collectionType, this.sourceMappingTag, this.targetMappingTag);
        return collectionType;
    }

    private SimpleDataType translateSimpleDataType(String name, TypeDefinition<?> type) {
        boolean cfr_ignored_0 = type instanceof IdentityrefTypeDefinition;
        boolean cfr_ignored_1 = type instanceof LeafrefTypeDefinition;
        TypeDefinition baseType = type.getBaseType();
        String typeName = type.getQName().getLocalName();
        if (baseType instanceof EnumTypeDefinition) {
            EnumDataType dataType = this.getEnumDataTypeFor(typeName);
            for (EnumTypeDefinition.EnumPair e : ((EnumTypeDefinition)baseType).getValues()) {
                SimpleDataInstance eInstance = this.getEnumDataInstanceFor(e.getName(), dataType);
                eInstance.setDataType((DataType)dataType);
                dataType.getValue().add((Object)eInstance);
            }
            this.addMapping((SchemaNode)baseType, (DataType)dataType, this.sourceMappingTag, this.targetMappingTag);
            return dataType;
        }
        if (type instanceof EnumTypeDefinition) {
            EnumDataType dataType = this.getEnumDataTypeFor(name);
            for (EnumTypeDefinition.EnumPair e : ((EnumTypeDefinition)type).getValues()) {
                SimpleDataInstance eInstance = this.getEnumDataInstanceFor(e.getName(), dataType);
                eInstance.setDataType((DataType)dataType);
                dataType.getValue().add((Object)eInstance);
            }
            this.addMapping((SchemaNode)type, (DataType)dataType, this.sourceMappingTag, this.targetMappingTag);
            return dataType;
        }
        if (type instanceof UnionTypeDefinition) {
            SimpleDataType dataType = this.getSimpleDataTypeFor(name);
            List types = ((UnionTypeDefinition)type).getTypes();
            Constraint constraint = this.constrainWith((DataType)dataType, "union");
            if (constraint != null) {
                for (TypeDefinition t : types) {
                    SimpleDataType unionType = this.translateSimpleDataType(String.valueOf(name) + "___" + t.getQName().getLocalName(), t);
                    LiteralValueUse ut = tdlFactory.eINSTANCE.createLiteralValueUse();
                    ut.setValue(unionType.getName());
                    constraint.getQuantifier().add((Object)ut);
                }
            }
            this.addMapping((SchemaNode)type, (DataType)dataType, this.sourceMappingTag, this.targetMappingTag);
            return dataType;
        }
        SimpleDataType dataType = this.getSimpleDataTypeFor(typeName);
        if (baseType != null) {
            SimpleDataType superType = this.getSimpleDataTypeFor(baseType.getQName().getLocalName());
            Extension e = tdlFactory.eINSTANCE.createExtension();
            e.setExtending((PackageableElement)superType);
            dataType.setExtension(e);
        }
        this.addMapping((SchemaNode)type, (DataType)dataType, this.sourceMappingTag, this.targetMappingTag);
        if (type instanceof StringTypeDefinition) {
            List patternConstraints = ((StringTypeDefinition)type).getPatternConstraints();
            Constraint constraint = this.constrainWith((DataType)dataType, "pattern");
            if (constraint != null) {
                for (PatternConstraint c : patternConstraints) {
                    LiteralValueUse ut = tdlFactory.eINSTANCE.createLiteralValueUse();
                    ut.setValue(c.getRegularExpressionString());
                    constraint.getQuantifier().add((Object)ut);
                }
            }
        }
        return dataType;
    }

    private void translateMember(String baseName, StructuredDataType dataType, DataSchemaNode child) {
        TypeDefinition type;
        DataType memberType = this.translate(child, baseName);
        String propertyName = child.getQName().getLocalName();
        Member m = (Member)this.getContentWithName(propertyName, (NamedElement)dataType, tdlPackage.Literals.MEMBER);
        m.setDataType(memberType);
        if (m.container() == null) {
            dataType.getMember().add((Object)m);
        }
        if (child instanceof TypedDataSchemaNode && (type = ((TypedDataSchemaNode)child).getType()) instanceof LeafrefTypeDefinition) {
            String value = ((LeafrefTypeDefinition)type).getPathStatement().getOriginalString();
            this.annotateWith((Element)m, LEAF_REF_PATH, value);
        }
    }

    private StructuredDataType translateStructuredDataType(DataNodeContainer c, String baseName, String name) {
        StructuredDataType dataType = this.getStructuredDataTypeFor(name);
        this.addSuperType((DataType)dataType, (DataType)this.messageBody);
        for (DataSchemaNode child : c.getChildNodes()) {
            this.translateMember(baseName, dataType, child);
        }
        this.addMapping((SchemaNode)c, (DataType)dataType, this.sourceMappingTag, this.targetMappingTag);
        return dataType;
    }

    private void addMapping(SchemaNode c, DataType dataType, String sourceMappingTag, String targetMappingTag) {
        String uri;
        QNameModule module = c.getQName().getModule();
        String resourceName = this.getCleanName(String.valueOf(module.getNamespace().toString()) + "_resource");
        DataResourceMapping resourceMapping = (DataResourceMapping)this.findElementOfType(resourceName, tdlPackage.Literals.DATA_RESOURCE_MAPPING);
        if (resourceMapping == null) {
            resourceMapping = tdlFactory.eINSTANCE.createDataResourceMapping();
            resourceMapping.setName(resourceName);
            uri = module.getNamespace().toString();
            Optional rev = module.getRevision();
            if (rev.isPresent()) {
                uri = String.valueOf(uri) + "?" + ((Revision)rev.get()).toString();
            }
            resourceMapping.setResourceURI(uri);
            this.getGeneratedPackage().getPackagedElement().add((Object)resourceMapping);
            if (this.mappingNameAnnotation != null) {
                Annotation annot = tdlFactory.eINSTANCE.createAnnotation();
                annot.setKey(this.mappingNameAnnotation);
                annot.setValue("Yang");
                resourceMapping.getAnnotation().add((Object)annot);
            }
        }
        uri = c.getQName().getLocalName();
        boolean addSourceMapping = false;
        DataElementMapping sourceMapping = null;
        if (addSourceMapping) {
            sourceMapping = this.addDataElementMapping(uri, dataType, sourceMappingTag, this.drm);
        }
        DataElementMapping targetMapping = this.addDataElementMapping(uri, dataType, targetMappingTag, resourceMapping);
        if (dataType instanceof StructuredDataType) {
            for (Member m : ((StructuredDataType)dataType).getMember()) {
                Collection children;
                Optional<DataSchemaNode> childNode;
                String mUri = m.getName();
                if (c instanceof DataNodeContainer && (childNode = (children = ((DataNodeContainer)c).getChildNodes()).stream().filter(cn -> this.getCleanName(cn.getQName().getLocalName()).equals(m.getName())).findAny()).isPresent()) {
                    mUri = childNode.get().getQName().getLocalName();
                }
                if (addSourceMapping) {
                    this.addParameterMapping(sourceMapping, (Parameter)m, mUri);
                }
                this.addParameterMapping(targetMapping, (Parameter)m, mUri);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        CrossSourceStatementReactor reactor = Yang2TDLTranslator.createReactor();
        CrossSourceStatementReactor.BuildAction build = reactor.newBuild();
        Files.list(Path.of("samples", "ietf")).forEach(p -> {
            CrossSourceStatementReactor.BuildAction buildAction2 = build.addSource((StatementStreamSource)Yang2TDLTranslator.moduleFromPath(p.toString()));
        });
        Files.list(Path.of("samples", "simple")).forEach(p -> {
            CrossSourceStatementReactor.BuildAction buildAction2 = build.addSource((StatementStreamSource)Yang2TDLTranslator.moduleFromPath(p.toString()));
        });
        EffectiveSchemaContext schemaContext = build.buildEffective();
        Yang2TDLTranslator.expand("  ", (ContainerLike)schemaContext);
    }

    private static CrossSourceStatementReactor createReactor() {
        CrossSourceStatementReactor reactor = RFC7950Reactors.vanillaReactorBuilder().addStatementSupport(ModelProcessingPhase.FULL_DECLARATION, (StatementSupport)new MountStatementSupport(YangParserConfiguration.DEFAULT)).build();
        return reactor;
    }

    private static void processStatic(CrossSourceStatementReactor reactor) throws ReactorException {
        reactor.newBuild().addSources(new StatementStreamSource[]{Yang2TDLTranslator.moduleFromPath("samples/ietf/ietf-yang-types@2013-07-15.yang"), Yang2TDLTranslator.moduleFromPath("samples/ietf/ietf-restconf@2017-01-26.yang"), Yang2TDLTranslator.moduleFromPath("samples/ietf/ietf-inet-types@2013-07-15.yang"), Yang2TDLTranslator.moduleFromPath("samples/nfv/etsi-nfv-common.yang"), Yang2TDLTranslator.moduleFromPath("samples/nfv/etsi-nfv-nsd.yang"), Yang2TDLTranslator.moduleFromPath("samples/nfv/etsi-nfv-pnfd.yang"), Yang2TDLTranslator.moduleFromPath("samples/nfv/etsi-nfv-vnfd.yang"), Yang2TDLTranslator.moduleFromPath("samples/nfv/etsi-nfv-descriptors.yang"), Yang2TDLTranslator.moduleFromPath("samples/nfv/etsi-nfv-ns.yang"), Yang2TDLTranslator.moduleFromPath("samples/nfv/etsi-nfv-pnf.yang"), Yang2TDLTranslator.moduleFromPath("samples/nfv/etsi-nfv-vnf.yang")}).buildEffective().getChildNodes().forEach(e -> System.out.println(e.getQName()));
    }

    private static YangStatementStreamSource moduleFromPath(String path) {
        return Yang2TDLTranslator.moduleFromPath(Path.of(path, new String[0]));
    }

    private static YangStatementStreamSource moduleFromPath(Path path) {
        try {
            return YangStatementStreamSource.create((YangTextSource)new FileYangTextSource(path));
        }
        catch (IOException | YangSyntaxErrorException e) {
            throw new IllegalStateException("Failed to find resource " + path.toString(), e);
        }
    }

    public static void expand(String prefix, ContainerLike node) {
        for (DataSchemaNode c : node.getChildNodes()) {
            Yang2TDLTranslator.expand(prefix, c);
        }
    }

    public static void expand(String prefix, ListSchemaNode node) {
        for (DataSchemaNode c : node.getChildNodes()) {
            Yang2TDLTranslator.expand(prefix, c);
        }
    }

    private static void expand(String prefix, DataSchemaNode c) {
        if (c instanceof LeafListSchemaNode) {
            System.out.println(String.valueOf(prefix) + c.getQName().getLocalName() + " : " + ((LeafListSchemaNode)c).getType().getQName());
        } else if (c instanceof ContainerSchemaNode) {
            System.out.println("!c" + prefix + c.getQName().getLocalName() + " : ");
            Yang2TDLTranslator.expand(String.valueOf(prefix) + "  ", (ContainerLike)((ContainerSchemaNode)c));
        } else if (c instanceof ListSchemaNode) {
            System.out.println("!l" + prefix + c.getQName().getLocalName() + " : ");
            Yang2TDLTranslator.expand(String.valueOf(prefix) + "  ", (ListSchemaNode)c);
        } else if (c instanceof RegularLeafEffectiveStatement) {
            System.out.println("!r" + prefix + c.getQName().getLocalName() + " : " + ((LeafStatement)((RegularLeafEffectiveStatement)c).getDeclared()).getType().argument());
        } else if (c instanceof EmptyLeafEffectiveStatement) {
            System.out.println("!e" + prefix + c.getQName().getLocalName() + " : " + ((EmptyLeafEffectiveStatement)c).getType().getQName());
        } else if (c instanceof LeafrefTypeDefinition) {
            System.out.println(((LeafrefTypeDefinition)c).getPathStatement().getOriginalString());
        } else if (c instanceof LeafSchemaNode) {
            TypeDefinition type = ((LeafSchemaNode)c).getType();
            String t = type.getQName().getLocalName();
            if (!type.getQName().getLocalName().equals("string")) {
                t = type.getQName().toString();
                System.out.println("!x" + ((LeafStatement)((AbstractDeclaredEffectiveStatement.Default)c).getDeclared()).getType());
            }
            System.out.println("!" + prefix + c.getQName().getLocalName() + " : " + t);
        } else {
            System.out.println(String.valueOf(prefix) + c.getQName().getLocalName() + " : " + c.getClass().getSimpleName());
        }
    }
}

