/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.wizards.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.etsi.mts.tdl.wizards.wizards.TDLNewWizardPage;

public class TDLNewWizard
extends Wizard
implements INewWizard {
    private TDLNewWizardPage page;
    private ISelection selection;
    private boolean importStandard;

    public TDLNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new TDLNewWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        String containerName = this.page.getContainerName();
        String fileName = this.page.getFileName();
        this.importStandard = this.page.getImportStandard().getSelection();
        IRunnableWithProgress op = monitor -> {
            try {
                try {
                    this.doFinish(containerName, fileName, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            throw new CoreException(Status.error((String)("Location \"" + containerName + "\" does not exist.")));
        }
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(() -> {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
            catch (PartInitException partInitException) {}
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        String name = "NewPackage";
        String imports = "";
        if (this.importStandard) {
            imports = String.valueOf(imports) + "    Import all from Standard";
        }
        String contents = "Package " + name + " {\n" + imports + "    " + "\n}";
        return new ByteArrayInputStream(contents.getBytes());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

