/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.constraints.evl;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.common.parse.Region;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.emc.emf.InMemoryEmfModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.evl.EvlModule;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.dom.ConstraintContext;
import org.eclipse.epsilon.evl.emf.validation.CompositeEValidator;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.validation.ComposedEValidator;
import org.eclipse.ocl.xtext.completeocl.validation.CompleteOCLEObjectValidator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.etsi.mts.tdl.constraints.evl.TDLDiagnostician;
import org.etsi.mts.tdl.constraints.evl.XtextBridgeNativeTypeDelegate;
import org.etsi.mts.tdl.extendedconfigurations.ExtendedConfigurationsPackage;
import org.etsi.mts.tdl.resources.ResourceHandler;
import org.etsi.mts.tdl.structuredobjectives.StructuredObjectivesPackage;
import org.etsi.mts.tdl.tdlPackage;

public class Validator {
    private static final List<EPackage> packages = List.of(tdlPackage.eINSTANCE, StructuredObjectivesPackage.eINSTANCE, ExtendedConfigurationsPackage.eINSTANCE);

    private static void registerValidator(EPackage ePackage, EValidator validator) {
        EValidator existingValidator = EValidator.Registry.INSTANCE.getEValidator(ePackage);
        if (existingValidator instanceof CompositeEValidator) {
            ((CompositeEValidator)existingValidator).getDelegates().add(validator);
        } else {
            if (existingValidator == null) {
                existingValidator = EObjectValidator.INSTANCE;
            }
            CompositeEValidator newValidator = new CompositeEValidator();
            newValidator.getDelegates().add(existingValidator);
            newValidator.getDelegates().add(validator);
            EValidator.Registry.INSTANCE.put((Object)ePackage, (Object)newValidator);
        }
    }

    public void validateOCL2(Resource r) {
        try {
            OCL ocl = OCL.newInstance((EPackage.Registry)EPackage.Registry.INSTANCE);
            java.net.URI uri = ResourceHandler.getSourceUri(this.getClass(), (String)"org.etsi.mts.tdl.constraints", (String)"/ocl/tdl-constraints.ocl");
            URI oclURI = URI.createURI((String)uri.toString());
            ocl.parse(oclURI);
            ComposedEValidator newEValidator = ComposedEValidator.install((EPackage)tdlPackage.eINSTANCE);
            newEValidator.addChild((EValidator)new CompleteOCLEObjectValidator((EPackage)tdlPackage.eINSTANCE, oclURI));
            TDLDiagnostician diagnostician = new TDLDiagnostician();
            Diagnostic diagnostics = diagnostician.validate(r);
            System.out.println(diagnostics.getChildren().size());
            if (diagnostics.getSeverity() != 0) {
                String formattedDiagnostics = PivotUtil.formatDiagnostics((Diagnostic)diagnostics, (String)"In");
                System.out.println("Validation: " + formattedDiagnostics);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void validateOCL(Resource r) {
        ComposedEValidator.install((EPackage)tdlPackage.eINSTANCE);
        try {
            java.net.URI uri = ResourceHandler.getSourceUri(this.getClass(), (String)"org.etsi.mts.tdl.constraints", (String)"/ocl/tdl-constraints.ocl");
            URI oclURI = URI.createURI((String)uri.toString());
            CompleteOCLEObjectValidator validator = new CompleteOCLEObjectValidator((EPackage)tdlPackage.eINSTANCE, oclURI);
            Validator.registerValidator((EPackage)tdlPackage.eINSTANCE, (EValidator)validator);
            TDLDiagnostician diagnostician = new TDLDiagnostician();
            Diagnostic diagnostics = diagnostician.validate(r);
            System.out.println(diagnostics.getChildren().size());
            if (diagnostics.getSeverity() != 0) {
                String formattedDiagnostics = PivotUtil.formatDiagnostics((Diagnostic)diagnostics, (String)"In");
                System.out.println("Validation: " + formattedDiagnostics);
                System.out.printf("Validation: %s\n", formattedDiagnostics);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public List<UnsatisfiedConstraint> validate(Resource r) throws Exception {
        List<Object> violations = new ArrayList<UnsatisfiedConstraint>();
        String prefix = "tdl-generated-ETSI-ES-203-119-";
        String suffix = "-fixed.evl";
        List<String> constraints = List.of(String.valueOf(prefix) + "1-V1.5.1" + suffix, String.valueOf(prefix) + "4-V1.4.1" + suffix, String.valueOf(prefix) + "7-V1.2.1" + suffix);
        try {
            EcoreUtil.resolveAll((Resource)r);
            IModel tdlModel = this.getTDLModel(r, true, false);
            tdlModel.load();
            ArrayList dependencies = new ArrayList();
            for (String part : constraints) {
                String source = "epsilon/constraints/" + part;
                java.net.URI uri = ResourceHandler.getSourceUri(this.getClass(), (String)"org.etsi.mts.tdl.constraints", (String)source);
                EvlModule module = new EvlModule();
                module.parse(uri);
                module.getContext().getNativeTypeDelegates().add(new XtextBridgeNativeTypeDelegate());
                if (module.getParseProblems().size() > 0) {
                    System.err.println("Parse errors occured...");
                    for (ParseProblem problem : module.getParseProblems()) {
                        System.err.println(problem.toString());
                    }
                }
                module.getContext().getModelRepository().addModel(tdlModel);
                module.getContext().getModelRepository().addModels(dependencies);
                module.execute();
                EvlModule m = module;
                violations.addAll(m.getContext().getUnsatisfiedConstraints());
                violations = violations.stream().filter(v -> ((EObject)v.getInstance()).eResource() == r).collect(Collectors.toList());
            }
            tdlModel.dispose();
            for (IModel d : dependencies) {
                d.dispose();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage().replaceAll("\n.+epsilon/", "\n  at (epsilon/"));
            throw e;
        }
        return violations;
    }

    public void dumpViolations(List<UnsatisfiedConstraint> violations, boolean includeLocation) {
        for (UnsatisfiedConstraint constraint : violations) {
            System.out.println("  Validator: " + constraint.getMessage());
            if (!includeLocation || !(((EObject)constraint.getInstance()).eResource() instanceof XtextResource)) continue;
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)((EObject)constraint.getInstance()));
            String text = "Line " + node.getStartLine() + "-" + node.getEndLine() + ": " + node.getText().trim();
            System.out.println("    " + text);
        }
    }

    private void dumpConstraints(EvlModule module) {
        for (ConstraintContext cx : module.getDeclaredConstraintContexts()) {
            System.out.println(cx);
            for (Constraint cs : cx.getConstraints()) {
                System.out.println("  " + cs);
                System.out.println("    check:" + this.getSnippet(module.getFile(), cs.getCheckBlock().getBody().getRegion()));
                System.out.println("    message:" + this.getSnippet(module.getFile(), cs.getMessageBlock().getBody().getRegion()));
            }
        }
    }

    private String getSnippet(File file, Region region) {
        String snippet = "";
        try {
            List<String> lines = Files.readAllLines(Path.of(file.getPath(), new String[0]));
            lines.add(0, "");
            lines = lines.subList(region.getStart().getLine(), region.getEnd().getLine() + 1);
            lines.set(lines.size() - 1, lines.get(lines.size() - 1).substring(0, region.getEnd().getColumn()));
            lines.set(0, lines.get(0).substring(region.getStart().getColumn() - 1));
            lines = lines.stream().filter(l -> !l.trim().startsWith("//")).collect(Collectors.toList());
            snippet = String.join((CharSequence)" ", lines).replaceAll("\\s+", " ");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return snippet;
    }

    public IModel getTDLModel(Resource resource, boolean read, boolean write) throws Exception {
        InMemoryEmfModel model = new InMemoryEmfModel("TDL", resource, packages);
        model.setStoredOnDisposal(write);
        model.setReadOnLoad(read);
        model.setCachingEnabled(true);
        model.setMetamodelUris(List.of("http://www.etsi.org/spec/TDL/1.4.1", "http://www.etsi.org/spec/TDL/1.3.1/structured", "http://www.etsi.org/spec/TDL/1.3.1/configurations"));
        return model;
    }
}

