/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.execution.java.eclipse.ui;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.etsi.mts.tdl.execution.java.eclipse.ui.ContainerFieldEditor;

public class PropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    public static final String PREFERENCE_SCOPE = "org.etsi.mts.tdl.execution";
    private static final List<String> REQUIRED_SETTINGS = Arrays.asList("JavaRendering.OutputDir", "JavaRendering.Injector");
    protected IAdaptable element;
    protected Map<FieldEditor, String> fields = new Hashtable<FieldEditor, String>();

    public PropertyPage() {
        super(1);
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        ProjectScope ps = new ProjectScope((IProject)this.element);
        return new ScopedPreferenceStore((IScopeContext)ps, PREFERENCE_SCOPE);
    }

    protected void initialize() {
        for (FieldEditor e : this.fields.keySet()) {
            String value = this.getPreferenceStore().getString(e.getPreferenceName());
            this.fields.put(e, value);
            this.initialize(e.getPreferenceName(), value, e);
        }
        super.initialize();
    }

    protected void initialize(String name, String value, FieldEditor e) {
    }

    protected void addField(FieldEditor editor) {
        super.addField(editor);
        this.fields.put(editor, "");
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value")) {
            FieldEditor e = (FieldEditor)event.getSource();
            String name = e.getPreferenceName();
            String value = event.getNewValue().toString();
            this.fields.put(e, value);
            this.initialize(name, value, e);
            this.checkState();
        }
    }

    protected void checkState() {
        this.setErrorMessage(null);
        super.checkState();
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        ContainerFieldEditor outDir = new ContainerFieldEditor("JavaRendering.OutputDir", "Output folder", parent){

            public boolean isValid() {
                return PropertyPage.this.isValid((FieldEditor)this) && this.doCheckState();
            }
        };
        this.addField((FieldEditor)outDir);
        parent = this.getFieldEditorParent();
        StringFieldEditor outPackage = new StringFieldEditor("JavaRendering.Package", "Package", parent);
        this.addField((FieldEditor)outPackage);
        parent = this.getFieldEditorParent();
        StringFieldEditor injector = new StringFieldEditor("JavaRendering.Injector", "Guice module", parent);
        this.addField((FieldEditor)injector);
        parent = this.getFieldEditorParent();
        StringFieldEditor dateFormat = new StringFieldEditor("JavaRendering.DateFormat", "Date format", parent);
        this.addField((FieldEditor)dateFormat);
        parent = this.getFieldEditorParent();
        StringFieldEditor useMapping = new StringFieldEditor("JavaRendering.UseMapping", "Mapping for TRI", parent);
        this.addField((FieldEditor)useMapping);
        parent = this.getFieldEditorParent();
        BooleanFieldEditor unmappedData = new BooleanFieldEditor("JavaRendering.UnmappedData", "Use unmapped data", parent);
        this.addField((FieldEditor)unmappedData);
    }

    private boolean isValid(FieldEditor e) {
        String name = e.getPreferenceName();
        String value = this.fields.get(e);
        if (REQUIRED_SETTINGS.contains(name) && value.isEmpty()) {
            this.setErrorMessage(String.format("%s must be selected!", e.getLabelText()));
            return false;
        }
        return true;
    }
}

