/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.tools.rt.ui.handlers;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.etsi.mts.tdl.Annotation;
import org.etsi.mts.tdl.Block;
import org.etsi.mts.tdl.CompoundBehaviour;
import org.etsi.mts.tdl.Element;
import org.etsi.mts.tdl.Package;
import org.etsi.mts.tdl.TestDescription;
import org.etsi.mts.tdl.tools.rt.ui.TP2TDDialog;

public class TP2TDHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Object firstElement;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEditorInput input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        IFile file = null;
        if (input != null && input instanceof FileEditorInput) {
            file = ((FileEditorInput)input).getFile();
        } else if (selection != null && selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            file = (IFile)firstElement;
        }
        if (file != null) {
            XtextResourceSet resourceSet;
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Injector injector = Guice.createInjector((Module[])new Module[0]);
            XtextResourceSet rs = resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
            Resource r = rs.getResource(uri, true);
            EcoreUtil.resolveAll((Resource)r);
            TP2TDDialog dialog = new TP2TDDialog(Display.getDefault().getActiveShell());
            dialog.setTitleAreaColor(Display.getDefault().getSystemColor(16).getRGB());
            dialog.create();
            if (dialog.open() == 0) {
                URI targetURI = URI.createURI((String)uri.toString());
                String ext = targetURI.fileExtension();
                String last = targetURI.trimFileExtension().lastSegment();
                last = String.valueOf(dialog.getPrefix()) + last + dialog.getSuffix();
                targetURI = targetURI.trimSegments(1).appendSegment(last).appendFileExtension(ext);
                Resource tr = resourceSet.createResource(targetURI);
                tr.getContents().addAll(EcoreUtil.copyAll((Collection)r.getContents()));
                this.processModel(tr, dialog.getPrefix(), dialog.getSuffix(), dialog.getSubstitute(), dialog.getWith(), dialog.isRemoveAnnotations(), dialog.isRemoveAnnotatedBlocks());
                try {
                    EcoreUtil.resolveAll((Resource)tr);
                    tr.save(null);
                }
                catch (Exception e1) {
                    System.err.println("  Translation: " + e1.getMessage());
                    e1.printStackTrace();
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IPath targetPath = file.getFullPath().removeLastSegments(1).append(last).addFileExtension(ext);
                IFile targetFile = workspace.getRoot().getFile(targetPath);
                try {
                    if (dialog.isMarkAsDerived()) {
                        targetFile.setDerived(true);
                    } else {
                        targetFile.setDerived(false);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void processModel(Resource resource, String prefix, String suffix, String substitute, String with, boolean removeAnnotations, boolean removeAnnotatedBlocks) {
        List packages = EcoreUtil2.eAllOfType((EObject)((EObject)resource.getContents().get(0)), Package.class);
        for (Package p : packages) {
            p.setName(String.valueOf(prefix) + p.getName() + suffix);
        }
        if (removeAnnotations) {
            List tds = EcoreUtil2.eAllOfType((EObject)((EObject)resource.getContents().get(0)), TestDescription.class);
            for (TestDescription td : tds) {
                td.setName(td.getName().replace(substitute, with));
                if (!removeAnnotatedBlocks) {
                    this.removeElements((EObject)td, Annotation.class);
                    continue;
                }
                List annotations = EcoreUtil2.eAllOfType((EObject)td, Annotation.class);
                for (Annotation a : annotations) {
                    if (a.getAnnotatedElement() instanceof CompoundBehaviour) {
                        CompoundBehaviour cb = (CompoundBehaviour)a.getAnnotatedElement();
                        if (!(cb.container() instanceof Block)) continue;
                        Block container = (Block)cb.container();
                        EList behaviours = cb.getBlock().getBehaviour();
                        container.getBehaviour().addAll((Collection)behaviours);
                        EcoreUtil2.delete((EObject)cb, (boolean)true);
                        continue;
                    }
                    EcoreUtil2.delete((EObject)a, (boolean)true);
                }
            }
        }
    }

    private <T extends Element> void removeElements(Resource tr, Class<T> type) {
        this.removeElements((EObject)tr.getContents().get(0), type);
    }

    private <T extends Element> void removeElements(EObject element, Class<T> type) {
        List elements = EcoreUtil2.eAllOfType((EObject)element, type);
        EcoreUtil2.deleteAll((Collection)elements, (boolean)true);
    }
}

