/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.tools.rt.ui;

import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

public class TP2TDDialog
extends TitleAreaDialog {
    private Text prefixField;
    private Text suffixField;
    private Text substituteField;
    private Text withField;
    private Button removeAnnotationsButton;
    private Button removeAnnotatedBlocksButton;
    private Button markAsDerivedButton;
    private String regex = "[a-zA-Z_]";
    private String prefix = "";
    private String suffix = "_TDs";
    private String substitute = "TP_";
    private String with = "TD_";
    private boolean removeAnnotations = false;
    private boolean removeAnnotatedBlocks = false;
    private boolean markAsDerived = false;
    private IEclipsePreferences preferences = ConfigurationScope.INSTANCE.getNode("org.etsi.mts.tdl.converters");
    private Preferences tp2td = this.preferences.node("tp2td");

    public TP2TDDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Transform TPs to TDs");
        this.setMessage("Customise the tranformation process", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.prefix = this.tp2td.get("prefix", "");
        this.suffix = this.tp2td.get("suffix", "_TDs");
        this.substitute = this.tp2td.get("substitute", "TP_");
        this.with = this.tp2td.get("with", "TD_");
        this.removeAnnotations = this.tp2td.getBoolean("removeAnnotations", false);
        this.removeAnnotatedBlocks = this.tp2td.getBoolean("removeAnnotatedBlocks", false);
        this.markAsDerived = this.tp2td.getBoolean("markAsDerived", true);
        this.prefixField = this.createTextField(container, "Package prefix", this.prefix);
        this.addValidation(this.prefixField, this.regex);
        this.suffixField = this.createTextField(container, "Package suffix", this.suffix);
        this.addValidation(this.suffixField, this.regex);
        this.substituteField = this.createTextField(container, "Substitute in name", this.substitute);
        this.addValidation(this.substituteField, this.substitute);
        this.withField = this.createTextField(container, "With", this.with);
        this.addValidation(this.withField, this.regex);
        this.removeAnnotationsButton = this.createOption(container, "Remove annotations", this.isRemoveAnnotations());
        this.removeAnnotatedBlocksButton = this.createOption(container, "Remove annotated blocks", this.isRemoveAnnotatedBlocks());
        this.markAsDerivedButton = this.createOption(container, "Mark target file as derived", this.isMarkAsDerived());
        this.removeAnnotationsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (!this.removeAnnotationsButton.getSelection() && this.removeAnnotatedBlocksButton.getSelection()) {
                this.removeAnnotatedBlocksButton.setSelection(false);
            }
        }));
        this.removeAnnotatedBlocksButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (!this.removeAnnotationsButton.getSelection() && this.removeAnnotatedBlocksButton.getSelection()) {
                this.removeAnnotationsButton.setSelection(true);
            }
        }));
        return area;
    }

    private Text createTextField(Composite container, String label, String value) {
        Label l = new Label(container, 0);
        l.setText(label);
        GridData d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        Text text = new Text(container, 2048);
        text.setLayoutData((Object)d);
        text.setText(value);
        return text;
    }

    private void addValidation(Text text, String regex) {
        text.addVerifyListener(e -> {
            Object object = this.validateRegEx(e, regex);
        });
    }

    private Object validateRegEx(VerifyEvent e, String regex) {
        e.doit = e.text.matches(regex) || e.keyCode == 127 || e.keyCode == 8;
        return null;
    }

    private Button createOption(Composite container, String label, boolean value) {
        Button button = new Button(container, 32);
        GridData d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        button.setLayoutData((Object)d);
        button.setText(label);
        button.setSelection(value);
        return button;
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.prefix = this.prefixField.getText();
        this.suffix = this.suffixField.getText();
        this.substitute = this.substituteField.getText();
        this.with = this.withField.getText();
        this.removeAnnotations = this.removeAnnotationsButton.getSelection();
        this.removeAnnotatedBlocks = this.removeAnnotatedBlocksButton.getSelection();
        this.markAsDerived = this.markAsDerivedButton.getSelection();
        this.tp2td.put("prefix", this.prefix);
        this.tp2td.get("suffix", this.suffix);
        this.tp2td.put("substitute", this.substitute);
        this.tp2td.get("with", this.with);
        this.tp2td.putBoolean("removeAnnotations", this.removeAnnotations);
        this.tp2td.putBoolean("removeAnnotatedBlocks", this.removeAnnotatedBlocks);
        this.tp2td.putBoolean("markAsDerived", this.markAsDerived);
        try {
            this.preferences.flush();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isRemoveAnnotations() {
        return this.removeAnnotations;
    }

    public boolean isRemoveAnnotatedBlocks() {
        return this.removeAnnotatedBlocks;
    }

    public String getSubstitute() {
        return this.substitute;
    }

    public String getWith() {
        return this.with;
    }

    public boolean isMarkAsDerived() {
        return this.markAsDerived;
    }
}

