/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl.ui.hover;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.etsi.mts.tdl.MemberAssignment;
import org.etsi.mts.tdl.NamedElement;
import org.etsi.mts.tdl.Parameter;
import org.etsi.mts.tdl.ParameterBinding;
import org.etsi.mts.tdl.StructuredDataInstance;
import org.etsi.mts.tdl.StructuredDataType;
import org.etsi.mts.tdl.TestDescription;
import org.etsi.mts.tdl.TestObjective;

public class TDLtxHoverProvider
extends DefaultEObjectHoverProvider {
    protected String getHoverInfoAsHtml(EObject o) {
        String members;
        String html = super.getHoverInfoAsHtml(o);
        if (o instanceof NamedElement) {
            html = "<b>" + o.eClass().getName() + " : " + ((NamedElement)o).getName() + "</b>";
        }
        if (o instanceof TestObjective) {
            Collection found = EcoreUtil.UsageCrossReferencer.find((EObject)o, (Resource)o.eResource());
            String targets = found.stream().map(e -> ((TestDescription)e.getEObject()).getName()).collect(Collectors.joining("</li><li>"));
            for (EStructuralFeature.Setting f : found) {
                f.getEObject();
            }
            html = String.valueOf(html) + "<br/></br>Referenced in: <b><ul><li>" + targets + "</li></ul></b></br</br>";
        }
        if (o instanceof StructuredDataType) {
            members = this.getListOfMembers((StructuredDataType)o);
            html = String.valueOf(html) + "<br/></br>Members: <b>" + members + "</b></br</br>";
        }
        if (o instanceof StructuredDataInstance) {
            StructuredDataInstance instance = (StructuredDataInstance)o;
            html = String.valueOf(html) + "<br/><br/>Type: <b>" + instance.getDataType().getName() + "</b>";
            String members2 = this.getListOfMembers((StructuredDataType)instance.getDataType());
            html = String.valueOf(html) + "<br/></br>Members: <b>" + members2 + "</b></br</br>";
            String unassigned = this.getListOfUnassignedMembers((StructuredDataType)instance.getDataType(), (List<MemberAssignment>)instance.getMemberAssignment());
            if (!unassigned.equals("<ul><li></li></ul>")) {
                html = String.valueOf(html) + "Unassigned Members: <b>" + unassigned + "</b></br</br>";
            }
        }
        if (o instanceof Parameter) {
            html = String.valueOf(html) + "<br/><br/>Type: <b>" + ((Parameter)o).getDataType().getName() + "</b>";
            if (((Parameter)o).getDataType() instanceof StructuredDataType) {
                members = this.getListOfMembers((StructuredDataType)((Parameter)o).getDataType());
                html = String.valueOf(html) + "<br/></br>Members: <b>" + members + "</b></br</br>";
            }
        }
        return html;
    }

    private String getListOfMembers(StructuredDataType o) {
        String members = o.allMembers().stream().map(e -> String.valueOf(e.getName()) + " : " + e.getDataType().getName() + (e.isIsOptional() ? " (optional)" : "")).collect(Collectors.joining("</li><li>"));
        return "<ul><li>" + members + "</li></ul>";
    }

    private String getListOfUnassignedMembers(StructuredDataType o, List<MemberAssignment> m) {
        List assigned = m.stream().map(e -> e.getMember()).collect(Collectors.toList());
        String members = o.allMembers().stream().filter(e -> !assigned.contains(e)).map(e -> String.valueOf(e.getName()) + " : " + e.getDataType().getName() + (e.isIsOptional() ? " (optional)" : "")).collect(Collectors.joining("</li><li>"));
        return "<ul><li>" + members + "</li></ul>";
    }

    private String getListOfUnboundParameters(StructuredDataType o, List<ParameterBinding> m) {
        List assigned = m.stream().map(e -> e.getParameter()).collect(Collectors.toList());
        String members = o.allMembers().stream().filter(e -> !assigned.contains(e)).map(e -> String.valueOf(e.getName()) + " : " + e.getDataType().getName() + (e.isIsOptional() ? " (optional)" : "")).collect(Collectors.joining("</li><li>"));
        return "<ul><li>" + members + "</li></ul>";
    }

    protected String getHoverInfoAsHtml(TestObjective o) {
        String html = super.getHoverInfoAsHtml((EObject)o);
        System.out.println(html);
        return html;
    }
}

