/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.mts.tdl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TimeLabelUseKind implements Enumerator
{
    LAST(0, "Last", "Last"),
    PREVIOUS(1, "Previous", "Previous"),
    FIRST(2, "First", "First");

    public static final int LAST_VALUE = 0;
    public static final int PREVIOUS_VALUE = 1;
    public static final int FIRST_VALUE = 2;
    private static final TimeLabelUseKind[] VALUES_ARRAY;
    public static final List<TimeLabelUseKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TimeLabelUseKind[]{LAST, PREVIOUS, FIRST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TimeLabelUseKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeLabelUseKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeLabelUseKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeLabelUseKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeLabelUseKind get(int value) {
        switch (value) {
            case 0: {
                return LAST;
            }
            case 1: {
                return PREVIOUS;
            }
            case 2: {
                return FIRST;
            }
        }
        return null;
    }

    private TimeLabelUseKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

